/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.codegen.rest;

import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.codegen.ProjectGenerator;
import io.quarkus.devtools.project.codegen.SourceType;
import io.quarkus.devtools.project.codegen.writer.FileProjectWriter;
import io.quarkus.devtools.project.codegen.writer.ProjectWriter;
import io.quarkus.maven.utilities.MojoUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;

public class BasicRestProjectGenerator
implements ProjectGenerator {
    public static final String NAME = "basic-rest";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void generate(QuarkusCommandInvocation invocation) throws IOException {
        FileProjectWriter writer = new FileProjectWriter(invocation.getQuarkusProject().getProjectDirPath().toFile());
        writer.init();
        this.generate(writer, invocation);
    }

    void generate(ProjectWriter writer, QuarkusCommandInvocation invocation) throws IOException {
        BasicRestProject project = new BasicRestProject(writer, invocation);
        project.initProject();
        project.setupContext();
        project.createClasses();
        project.createIndexPage();
        project.createDockerFiles();
        project.createDockerIgnore();
        project.createApplicationConfig();
        project.createReadme();
        project.createGitIgnore();
    }

    private class BasicRestProject {
        private QuarkusCommandInvocation invocation;
        private String path = "/hello";
        private ProjectWriter writer;
        private String srcMainPath;
        private String testMainPath;
        private String nativeTestMainPath;
        private SourceType type;

        private BasicRestProject(ProjectWriter writer, QuarkusCommandInvocation invocation) {
            this.writer = writer;
            this.invocation = invocation;
            this.type = invocation.getValue("source_type", SourceType.JAVA);
        }

        private <T> T get(String key, T defaultValue) {
            return this.invocation.getValue(key, defaultValue);
        }

        private boolean initProject() throws IOException {
            boolean newProject = this.initBuildTool();
            this.path = this.get("path", this.path);
            this.srcMainPath = this.writer.mkdirs(this.type.getSrcDir());
            this.testMainPath = this.writer.mkdirs(this.type.getTestSrcDir());
            this.nativeTestMainPath = this.getBuildTool() == BuildTool.GRADLE ? this.writer.mkdirs(this.type.getTestSrcDir().replace("test", "native-test")) : this.testMainPath;
            return newProject;
        }

        private boolean initBuildTool() throws IOException {
            boolean newProject;
            BuildTool buildTool = this.getBuildTool();
            if (!this.invocation.hasValue("additional_gitignore_entries")) {
                this.invocation.setValue("additional_gitignore_entries", buildTool.getGitIgnoreEntries());
            }
            if (!this.invocation.hasValue("build_dir")) {
                this.invocation.setValue("build_dir", buildTool.getBuildDirectory());
            }
            if (!this.invocation.hasValue("maven_repositories")) {
                this.invocation.setValue("maven_repositories", "");
            }
            if (!this.invocation.hasValue("maven_plugin_repositories")) {
                this.invocation.setValue("maven_plugin_repositories", "");
            }
            boolean bl = newProject = !this.writer.exists(buildTool.getDependenciesFile());
            if (newProject) {
                for (String buildFile : buildTool.getBuildFiles()) {
                    this.generate(this.type.getBuildFileResourceTemplate(BasicRestProjectGenerator.this.getName(), buildFile), this.invocation, buildFile, buildFile);
                }
            } else {
                String[] gav;
                if (BuildTool.MAVEN.equals((Object)buildTool)) {
                    ByteArrayInputStream buildFileInputStream = new ByteArrayInputStream(this.writer.getContent(buildTool.getDependenciesFile()));
                    gav = MojoUtils.readGavFromPom(buildFileInputStream);
                } else {
                    gav = new String[3];
                    for (String buildFile : buildTool.getBuildFiles()) {
                        if (!this.writer.exists(buildFile)) continue;
                        try (ByteArrayInputStream buildFileInputStream = new ByteArrayInputStream(this.writer.getContent(buildFile));){
                            gav = MojoUtils.readGavFromSettingsGradle(buildFileInputStream, gav);
                        }
                    }
                }
                if (gav[0] != null) {
                    this.invocation.setValue("project_groupId", gav[0]);
                }
                if (gav[1] != null) {
                    this.invocation.setValue("project_artifactId", gav[1]);
                }
            }
            return newProject;
        }

        private BuildTool getBuildTool() {
            return this.invocation.getQuarkusProject().getBuildTool();
        }

        private void generate(String templateName, QuarkusCommandInvocation invocation, String outputFilePath, String resourceType) throws IOException {
            if (!this.writer.exists(outputFilePath)) {
                String template = invocation.getPlatformDescriptor().getTemplate(templateName);
                if (template == null) {
                    throw new IOException("Template resource is missing: " + templateName);
                }
                for (Map.Entry<String, Object> e : invocation.getValues().entrySet()) {
                    if (!(e.getValue() instanceof String)) continue;
                    template = template.replace(String.format("${%s}", e.getKey()), (String)e.getValue());
                }
                if ("11".equals(invocation.getValue("java_target"))) {
                    if (BuildTool.GRADLE.equals((Object)invocation.getQuarkusProject().getBuildTool())) {
                        template = template.replace("JavaVersion.VERSION_1_8", "JavaVersion.VERSION_11");
                    } else {
                        template = template.replace("<maven.compiler.source>1.8</maven.compiler.source>", "<maven.compiler.source>11</maven.compiler.source>");
                        template = template.replace("<maven.compiler.target>1.8</maven.compiler.target>", "<maven.compiler.target>11</maven.compiler.target>");
                        template = template.replace("<jvmTarget>1.8</jvmTarget>", "<jvmTarget>11</jvmTarget>");
                    }
                }
                this.writer.write(outputFilePath, template);
            }
        }

        private void createIndexPage() throws IOException {
            String resources = "src/main/resources/META-INF/resources";
            String index = this.writer.mkdirs(resources) + "/index.html";
            if (!this.writer.exists(index)) {
                this.generate("templates/index.ftl", this.invocation, index, "welcome page");
            }
        }

        private void createDockerFiles() throws IOException {
            String dockerRoot = "src/main/docker";
            String dockerRootDir = this.writer.mkdirs(dockerRoot);
            this.generate("templates/dockerfile-native.ftl", this.invocation, dockerRootDir + "/Dockerfile.native", "native docker file");
            this.generate("templates/dockerfile-jvm.ftl", this.invocation, dockerRootDir + "/Dockerfile.jvm", "jvm docker file");
            this.generate("templates/dockerfile-fast-jar.ftl", this.invocation, dockerRootDir + "/Dockerfile.fast-jar", "jvm docker file");
        }

        private void createReadme() throws IOException {
            String readme = this.writer.mkdirs("") + "README.md";
            BuildTool buildTool = this.getBuildTool();
            switch (buildTool) {
                case MAVEN: {
                    this.generate("templates/README.maven.ftl", this.invocation, readme, "read me");
                    break;
                }
                case GRADLE: {
                    this.generate("templates/README.gradle.ftl", this.invocation, readme, "read me");
                    break;
                }
                default: {
                    throw new IllegalStateException("buildTool is none of Maven or Gradle");
                }
            }
        }

        private void createDockerIgnore() throws IOException {
            String docker = this.writer.mkdirs("") + ".dockerignore";
            this.generate("templates/dockerignore.ftl", this.invocation, docker, "docker ignore");
        }

        private void createGitIgnore() throws IOException {
            String gitignore = this.writer.mkdirs("") + ".gitignore";
            this.generate("templates/gitignore.ftl", this.invocation, gitignore, "git ignore");
        }

        private void createApplicationConfig() throws IOException {
            String meta = "src/main/resources";
            String file = this.writer.mkdirs(meta) + "/application.properties";
            if (!this.writer.exists(file)) {
                this.writer.write(file, "# Configuration file" + System.lineSeparator() + "# key = value");
            }
        }

        private void setupContext() throws IOException {
            if (this.invocation.getValue("class_name") != null) {
                String packageName = this.invocation.getStringValue("package_name");
                if (packageName != null) {
                    String packageDir = this.srcMainPath + '/' + packageName.replace('.', '/');
                    String originalTestMainPath = this.testMainPath;
                    String testPackageDir = this.testMainPath + '/' + packageName.replace('.', '/');
                    this.srcMainPath = this.writer.mkdirs(packageDir);
                    this.testMainPath = this.writer.mkdirs(testPackageDir);
                    if (!originalTestMainPath.equals(this.nativeTestMainPath)) {
                        String nativeTestPackageDir = this.nativeTestMainPath + '/' + packageName.replace('.', '/');
                        this.nativeTestMainPath = this.writer.mkdirs(nativeTestPackageDir);
                    } else {
                        this.nativeTestMainPath = this.testMainPath;
                    }
                } else {
                    throw new NullPointerException("Need a non-null package name");
                }
            }
        }

        private void createClasses() throws IOException {
            Object className = this.invocation.getValue("class_name");
            if (className != null) {
                String extension = this.type.getExtension();
                String classFile = this.srcMainPath + '/' + className + extension;
                String testClassFile = this.testMainPath + '/' + className + "Test" + extension;
                String itTestClassFile = this.nativeTestMainPath + '/' + "Native" + className + "IT" + extension;
                String name = BasicRestProjectGenerator.this.getName();
                String srcResourceTemplate = this.type.getSrcResourceTemplate(name);
                Object isSpring = this.invocation.getValue("is_spring");
                if (isSpring != null && Boolean.valueOf(this.invocation.getValue("is_spring").equals(Boolean.TRUE)).booleanValue()) {
                    srcResourceTemplate = this.type.getSrcSpringControllerTemplate(name);
                }
                this.generate(srcResourceTemplate, this.invocation, classFile, "resource code");
                this.generate(this.type.getTestResourceTemplate(name), this.invocation, testClassFile, "test code");
                this.generate(this.type.getNativeTestResourceTemplate(name), this.invocation, itTestClassFile, "IT code");
            }
        }
    }
}

