/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands;

import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.CreateProjectCommandHandler;
import io.quarkus.devtools.commands.handlers.LegacyCreateProjectCommandHandler;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.codegen.SourceType;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.tools.ToolsUtils;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;

public class CreateProject {
    public static final String NAME = "create-project";
    public static final String NO_DOCKERFILES = ToolsUtils.dotJoin("quarkus", "create-project", "no-dockerfiles");
    public static final String NO_BUILDTOOL_WRAPPER = ToolsUtils.dotJoin("quarkus", "create-project", "no-buildtool-wrapper");
    public static final String NO_EXAMPLES = ToolsUtils.dotJoin("quarkus", "create-project", "no-examples");
    public static final String CODESTARTS = ToolsUtils.dotJoin("quarkus", "create-project", "codestarts");
    private static final Pattern JAVA_VERSION_PATTERN = Pattern.compile("(?:1\\.)?(\\d+)(?:\\..*)?");
    private boolean legacyCodegen = false;
    private final Path projectDirPath;
    private final QuarkusPlatformDescriptor platformDescr;
    private String javaTarget;
    private Set<String> extensions = new HashSet<String>();
    private BuildTool buildTool = BuildTool.MAVEN;
    private Map<String, Object> values = new HashMap<String, Object>();

    public CreateProject(Path projectDirPath, QuarkusPlatformDescriptor platformDescr) {
        this.projectDirPath = Objects.requireNonNull(projectDirPath, "projectDirPath is required");
        this.platformDescr = Objects.requireNonNull(platformDescr, "platformDescr is required");
    }

    public CreateProject groupId(String groupId) {
        this.setValue("project_groupId", groupId);
        return this;
    }

    public CreateProject artifactId(String artifactId) {
        this.setValue("project_artifactId", artifactId);
        return this;
    }

    public CreateProject version(String version) {
        this.setValue("project_version", version);
        return this;
    }

    public CreateProject quarkusMavenPluginVersion(String version) {
        this.setValue("maven_plugin_version", version);
        return this;
    }

    public CreateProject quarkusGradlePluginVersion(String version) {
        this.setValue("gradle_plugin_version", version);
        return this;
    }

    public CreateProject sourceType(SourceType sourceType) {
        this.setValue("source_type", (Object)sourceType);
        return this;
    }

    public CreateProject javaTarget(String javaTarget) {
        this.javaTarget = javaTarget;
        return this;
    }

    public CreateProject resourcePath(String resourcePath) {
        this.setValue("path", resourcePath);
        return this;
    }

    @Deprecated
    public CreateProject className(String className) {
        if (className == null) {
            return this;
        }
        if (!SourceVersion.isName(className) || SourceVersion.isKeyword(className)) {
            throw new IllegalArgumentException(className + " is not a valid class name");
        }
        this.setValue("class_name", className);
        return this;
    }

    public CreateProject packageName(String packageName) {
        if (packageName == null) {
            return this;
        }
        if (!SourceVersion.isName(packageName) || SourceVersion.isKeyword(packageName)) {
            throw new IllegalArgumentException(packageName + " is not a  package name");
        }
        this.setValue("package_name", packageName);
        return this;
    }

    public CreateProject extensions(Set<String> extensions) {
        if (extensions == null) {
            return this;
        }
        this.extensions.addAll(extensions);
        return this;
    }

    public CreateProject codestarts(Set<String> codestarts) {
        this.setValue(CODESTARTS, codestarts);
        return this;
    }

    @Deprecated
    public CreateProject codestartsEnabled(boolean value) {
        return this.legacyCodegen(!value);
    }

    @Deprecated
    public CreateProject codestartsEnabled() {
        return this.legacyCodegen(false);
    }

    @Deprecated
    public CreateProject legacyCodegen() {
        return this.legacyCodegen(true);
    }

    @Deprecated
    public CreateProject legacyCodegen(boolean value) {
        this.legacyCodegen = value;
        return this;
    }

    public CreateProject noExamples(boolean value) {
        this.setValue(NO_EXAMPLES, value);
        return this;
    }

    public CreateProject noExamples() {
        return this.noExamples(true);
    }

    public CreateProject noBuildToolWrapper(boolean value) {
        this.setValue(NO_BUILDTOOL_WRAPPER, value);
        return this;
    }

    public CreateProject noBuildToolWrapper() {
        return this.noBuildToolWrapper(true);
    }

    public CreateProject noDockerfiles(boolean value) {
        this.setValue(NO_DOCKERFILES, value);
        return this;
    }

    public CreateProject noDockerfiles() {
        return this.noDockerfiles(true);
    }

    public CreateProject setValue(String name, Object value) {
        if (value != null) {
            this.values.put(name, value);
        }
        return this;
    }

    public CreateProject buildTool(BuildTool buildTool) {
        this.buildTool = Objects.requireNonNull(buildTool, "buildTool is required");
        return this;
    }

    public boolean doCreateProject(Map<String, Object> context) throws QuarkusCommandException {
        if (context != null && !context.isEmpty()) {
            for (Map.Entry<String, Object> entry : context.entrySet()) {
                if (entry.getValue() == null) continue;
                this.setValue(entry.getKey(), entry.getValue());
            }
        }
        return this.execute().isSuccess();
    }

    public QuarkusCommandOutcome execute() throws QuarkusCommandException {
        Matcher matcher = JAVA_VERSION_PATTERN.matcher(this.javaTarget != null ? this.javaTarget : System.getProperty("java.version", ""));
        if (matcher.matches() && Integer.parseInt(matcher.group(1)) < 11) {
            this.setValue("java_target", "8");
        } else {
            this.setValue("java_target", "11");
        }
        if (CreateProject.containsSpringWeb(this.extensions)) {
            this.setValue("is_spring", true);
            if (CreateProject.containsRESTEasy(this.extensions)) {
                this.values.remove("class_name");
                this.values.remove("path");
            }
        }
        this.setValue("extensions", this.extensions);
        QuarkusProject quarkusProject = QuarkusProject.of(this.projectDirPath, this.platformDescr, this.buildTool);
        QuarkusCommandInvocation invocation = new QuarkusCommandInvocation(quarkusProject, this.values);
        if (this.legacyCodegen) {
            return new LegacyCreateProjectCommandHandler().execute(invocation);
        }
        return new CreateProjectCommandHandler().execute(invocation);
    }

    public static SourceType determineSourceType(Set<String> extensions) {
        Optional<SourceType> sourceType = extensions.stream().map(SourceType::parse).filter(Optional::isPresent).map(e -> e.orElse(SourceType.JAVA)).findAny();
        return sourceType.orElse(SourceType.JAVA);
    }

    private static boolean containsSpringWeb(Collection<String> extensions) {
        return extensions.stream().anyMatch(e -> e.toLowerCase().contains("spring-web"));
    }

    private static boolean containsRESTEasy(Collection<String> extensions) {
        return extensions.isEmpty() || extensions.stream().anyMatch(e -> e.toLowerCase().contains("resteasy"));
    }
}

