/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.core;

import io.quarkus.devtools.codestarts.Codestart;
import io.quarkus.devtools.codestarts.CodestartProjectDefinition;
import io.quarkus.devtools.codestarts.CodestartResource;
import io.quarkus.devtools.codestarts.CodestartType;
import io.quarkus.devtools.codestarts.core.CodestartProcessor;
import io.quarkus.devtools.codestarts.core.CodestartSpec;
import io.quarkus.devtools.codestarts.core.strategy.CodestartFileStrategy;
import io.quarkus.devtools.codestarts.utils.NestedMaps;
import io.quarkus.devtools.messagewriter.MessageWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class CodestartProjectGeneration {
    private CodestartProjectGeneration() {
    }

    static void generateProject(CodestartProjectDefinition projectDefinition, Path targetDirectory) throws IOException {
        MessageWriter log = projectDefinition.getProjectInput().log();
        String languageName = projectDefinition.getLanguageName();
        Map<String, Object> data = NestedMaps.deepMerge(Stream.of(projectDefinition.getSharedData(), projectDefinition.getDepsData(), projectDefinition.getCodestartProjectData()));
        log.debug("processed shared-data: %s" + data);
        Codestart projectCodestart = projectDefinition.getRequiredCodestart(CodestartType.PROJECT);
        List<CodestartFileStrategy> strategies = CodestartProcessor.buildStrategies(CodestartProjectGeneration.mergeStrategies(projectDefinition));
        log.debug("file strategies: %s", new Object[]{strategies});
        CodestartProcessor processor = new CodestartProcessor(log, languageName, targetDirectory, strategies, data);
        processor.checkTargetDir();
        projectCodestart.use(project -> {
            for (Codestart codestart : projectDefinition.getCodestarts()) {
                processor.process((CodestartResource)project, codestart);
            }
        });
        processor.writeFiles();
        log.info("\napplying codestarts...");
        log.info(projectDefinition.getCodestarts().stream().map(c -> c.getType().getIcon() + " " + c.getName()).collect(Collectors.joining("\n")));
    }

    private static Map<String, String> mergeStrategies(CodestartProjectDefinition projectDefinition) {
        return NestedMaps.deepMerge(projectDefinition.getCodestarts().stream().map(Codestart::getSpec).map(CodestartSpec::getOutputStrategy));
    }
}

