/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.postgresql.deployment;

import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;

public class PostgresqlDevServicesProcessor {
    public static final String DEFAULT = "postgres:9.6.12";

    @BuildStep
    DevServicesDatasourceProviderBuildItem setupPostgres() {
        return new DevServicesDatasourceProviderBuildItem("postgresql", new DevServicesDatasourceProvider(){

            public DevServicesDatasourceProvider.RunningDevServicesDatasource startDatabase(Optional<String> username, Optional<String> password, Optional<String> datasourceName, Optional<String> imageName, Map<String, String> additionalProperties) {
                final PostgreSQLContainer container = new PostgreSQLContainer(DockerImageName.parse((String)imageName.orElse(PostgresqlDevServicesProcessor.DEFAULT)).asCompatibleSubstituteFor(DockerImageName.parse((String)"postgres"))).withPassword(password.orElse("quarkus")).withUsername(username.orElse("quarkus")).withDatabaseName(datasourceName.orElse("default"));
                additionalProperties.forEach((arg_0, arg_1) -> ((PostgreSQLContainer)container).withUrlParam(arg_0, arg_1));
                container.start();
                return new DevServicesDatasourceProvider.RunningDevServicesDatasource(container.getJdbcUrl(), container.getUsername(), container.getPassword(), new Closeable(){

                    @Override
                    public void close() throws IOException {
                        container.stop();
                    }
                });
            }
        });
    }
}

