/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator.curator;

import io.quarkus.bootstrap.BootstrapDependencyProcessingException;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.util.ZipUtils;
import io.quarkus.creator.AppCreatorException;
import io.quarkus.creator.CuratedApplicationCreator;
import io.quarkus.creator.DependenciesOrigin;
import io.quarkus.creator.VersionUpdate;
import io.quarkus.creator.curator.CurateOutcome;
import io.quarkus.creator.curator.DefaultUpdateDiscovery;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.jboss.logging.Logger;

public class Curator {
    private static final Logger log = Logger.getLogger(Curator.class);
    private static final Map<String, String> BANNED_DEPENDENCIES = Curator.createBannedDependenciesMap();

    public static CurateOutcome run(CuratedApplicationCreator ctx) throws AppCreatorException {
        List appDeps;
        AppModel initialDepsList;
        Object modelRepo;
        AppModelResolver modelResolver;
        CurateOutcome.Builder outcome;
        AppArtifact appArtifact;
        block41: {
            Path appJar;
            log.debug((Object)("provideOutcome depsOrigin=" + (Object)((Object)ctx.getDepsOrigin()) + ", versionUpdate=" + (Object)((Object)ctx.getUpdate()) + ", versionUpdateNumber=" + (Object)((Object)ctx.getUpdateNumber())));
            appArtifact = ctx.getAppArtifact();
            if (appArtifact == null) {
                throw new AppCreatorException("Application artifact has not been provided");
            }
            try {
                appJar = ctx.getArtifactResolver().resolve(appArtifact);
            }
            catch (AppModelResolverException e) {
                throw new AppCreatorException("Failed to resolve artifact", e);
            }
            if (!Files.exists(appJar, new LinkOption[0])) {
                throw new AppCreatorException("Application " + appJar + " does not exist on disk");
            }
            outcome = CurateOutcome.builder();
            modelResolver = ctx.getArtifactResolver();
            try {
                if (modelResolver == null) {
                    BootstrapAppModelResolver bsResolver = new BootstrapAppModelResolver(MavenArtifactResolver.builder().setRepoHome(ctx.getLocalRepo() == null ? ctx.getWorkPath("repo") : ctx.getLocalRepo()).build());
                    bsResolver.relink(appArtifact, appJar);
                    List artifactRepos = bsResolver.resolveArtifactRepos(appArtifact);
                    if (!artifactRepos.isEmpty()) {
                        bsResolver.addRemoteRepositories(artifactRepos);
                        ArrayList<Repository> modelRepos = new ArrayList<Repository>(artifactRepos.size());
                        for (RemoteRepository repo : artifactRepos) {
                            modelRepo = new Repository();
                            modelRepo.setId(repo.getId());
                            modelRepo.setUrl(repo.getUrl());
                            modelRepo.setLayout(repo.getContentType());
                            RepositoryPolicy policy = repo.getPolicy(true);
                            if (policy != null) {
                                modelRepo.setSnapshots(Curator.toMavenRepoPolicy(policy));
                            }
                            if ((policy = repo.getPolicy(false)) != null) {
                                modelRepo.setReleases(Curator.toMavenRepoPolicy(policy));
                            }
                            modelRepos.add((Repository)modelRepo);
                        }
                        outcome.setArtifactRepos(modelRepos);
                    }
                    modelResolver = bsResolver;
                } else {
                    modelResolver.relink(appArtifact, appJar);
                }
                outcome.setAppModelResolver(modelResolver);
                if (ctx.getDepsOrigin() == DependenciesOrigin.LAST_UPDATE) {
                    log.info((Object)"Looking for the state of the last update");
                    Path statePath = null;
                    try {
                        AppArtifact stateArtifact = ModelUtils.getStateArtifact((AppArtifact)appArtifact);
                        String latest = modelResolver.getLatestVersion(stateArtifact, null, false);
                        if (!stateArtifact.getVersion().equals(latest)) {
                            stateArtifact = new AppArtifact(stateArtifact.getGroupId(), stateArtifact.getArtifactId(), stateArtifact.getClassifier(), stateArtifact.getType(), latest);
                        }
                        statePath = modelResolver.resolve(stateArtifact);
                        outcome.setStateArtifact(stateArtifact);
                        log.info((Object)("- located the state at " + statePath));
                    }
                    catch (AppModelResolverException stateArtifact) {
                        // empty catch block
                    }
                    if (statePath != null) {
                        Model model;
                        try {
                            model = ModelUtils.readModel(statePath);
                        }
                        catch (IOException e) {
                            throw new AppCreatorException("Failed to read application state " + statePath, e);
                        }
                        List modelStateDeps = model.getDependencies();
                        ArrayList<AppDependency> updatedDeps = new ArrayList<AppDependency>(modelStateDeps.size());
                        String groupIdProp = "${creator.app.groupId}";
                        for (Dependency modelDep : modelStateDeps) {
                            if (modelDep.getGroupId().equals("${creator.app.groupId}")) continue;
                            updatedDeps.add(new AppDependency(new AppArtifact(modelDep.getGroupId(), modelDep.getArtifactId(), modelDep.getClassifier(), modelDep.getType(), modelDep.getVersion()), modelDep.getScope(), modelDep.isOptional()));
                        }
                        initialDepsList = modelResolver.resolveModel(appArtifact, updatedDeps);
                        outcome.setLoadedFromState();
                        break block41;
                    }
                    initialDepsList = modelResolver.resolveModel(appArtifact);
                    break block41;
                }
                initialDepsList = modelResolver.resolveModel(appArtifact);
            }
            catch (AppModelResolverException e) {
                throw new AppCreatorException("Failed to resolve initial application dependencies", e);
            }
        }
        outcome.setAppModel(initialDepsList);
        log.debug((Object)"Checking for potential banned dependencies");
        Curator.checkBannedDependencies(initialDepsList);
        if (ctx.getUpdate() == VersionUpdate.NONE) {
            return outcome.build();
        }
        log.info((Object)"Checking for available updates");
        try {
            appDeps = modelResolver.resolveUserDependencies(appArtifact, initialDepsList.getUserDependencies());
        }
        catch (BootstrapDependencyProcessingException | AppModelResolverException e) {
            throw new AppCreatorException("Failed to determine the list of dependencies to update", e);
        }
        Iterator depsI = appDeps.iterator();
        while (depsI.hasNext()) {
            AppArtifact appDep = ((AppDependency)depsI.next()).getArtifact();
            if (!appDep.getType().equals("jar")) {
                depsI.remove();
                continue;
            }
            Path path = appDep.getPath();
            if (Files.isDirectory(path, new LinkOption[0])) {
                if (Files.exists(path.resolve("META-INF/quarkus-extension.properties"), new LinkOption[0])) continue;
                depsI.remove();
                continue;
            }
            try {
                FileSystem artifactFs = ZipUtils.newFileSystem((Path)path);
                modelRepo = null;
                try {
                    if (Files.exists(artifactFs.getPath("META-INF/quarkus-extension.properties", new String[0]), new LinkOption[0])) continue;
                    depsI.remove();
                }
                catch (Throwable modelDep) {
                    modelRepo = modelDep;
                    throw modelDep;
                }
                finally {
                    if (artifactFs == null) continue;
                    if (modelRepo != null) {
                        try {
                            artifactFs.close();
                        }
                        catch (Throwable modelDep) {
                            ((Throwable)modelRepo).addSuppressed(modelDep);
                        }
                        continue;
                    }
                    artifactFs.close();
                }
            }
            catch (IOException e) {
                throw new AppCreatorException("Failed to open " + path, e);
            }
        }
        DefaultUpdateDiscovery ud = new DefaultUpdateDiscovery(modelResolver, ctx.getUpdateNumber());
        ArrayList<AppDependency> availableUpdates = null;
        int i = 0;
        while (i < appDeps.size()) {
            AppDependency dep = (AppDependency)appDeps.get(i++);
            AppArtifact depArtifact = dep.getArtifact();
            String updatedVersion = ctx.getUpdate() == VersionUpdate.NEXT ? ud.getNextVersion(depArtifact) : ud.getLatestVersion(depArtifact);
            if (updatedVersion == null || depArtifact.getVersion().equals(updatedVersion)) continue;
            log.info((Object)(dep.getArtifact() + " -> " + updatedVersion));
            if (availableUpdates == null) {
                availableUpdates = new ArrayList<AppDependency>();
            }
            availableUpdates.add(new AppDependency(new AppArtifact(depArtifact.getGroupId(), depArtifact.getArtifactId(), depArtifact.getClassifier(), depArtifact.getType(), updatedVersion), dep.getScope()));
        }
        if (availableUpdates != null) {
            outcome.setUpdatedDeps(availableUpdates);
            return outcome.build();
        }
        log.info((Object)"- no updates available");
        return outcome.build();
    }

    private static org.apache.maven.model.RepositoryPolicy toMavenRepoPolicy(RepositoryPolicy policy) {
        org.apache.maven.model.RepositoryPolicy mvnPolicy = new org.apache.maven.model.RepositoryPolicy();
        mvnPolicy.setEnabled(policy.isEnabled());
        mvnPolicy.setChecksumPolicy(policy.getChecksumPolicy());
        mvnPolicy.setUpdatePolicy(policy.getUpdatePolicy());
        return mvnPolicy;
    }

    private static void checkBannedDependencies(AppModel initialDepsList) {
        ArrayList<String> detectedBannedDependencies = new ArrayList<String>();
        try {
            for (AppDependency userDependency : initialDepsList.getUserDependencies()) {
                String ga = userDependency.getArtifact().getGroupId() + ":" + userDependency.getArtifact().getArtifactId();
                if ("test".equals(userDependency.getScope()) || !BANNED_DEPENDENCIES.containsKey(ga)) continue;
                detectedBannedDependencies.add(ga);
            }
        }
        catch (BootstrapDependencyProcessingException bootstrapDependencyProcessingException) {
            // empty catch block
        }
        if (!detectedBannedDependencies.isEmpty()) {
            String warnMessage = detectedBannedDependencies.stream().sorted().map(d -> "\t- " + d + " should be replaced by " + BANNED_DEPENDENCIES.get(d)).collect(Collectors.joining("\n"));
            log.warnf("These dependencies are not recommended:%n%s%nYou might end up with two different versions of the same classes or with an artifact you shouldn't have in your classpath.", (Object)warnMessage);
        }
    }

    private static Map<String, String> createBannedDependenciesMap() {
        HashMap<String, String> bannedDependencies = new HashMap<String, String>();
        bannedDependencies.put("org.jboss.spec.javax.annotation:jboss-annotations-api_1.2_spec", "jakarta.annotation:jakarta.annotation-api");
        bannedDependencies.put("org.jboss.spec.javax.annotation:jboss-annotations-api_1.3_spec", "jakarta.annotation:jakarta.annotation-api");
        bannedDependencies.put("org.jboss.spec.javax.transaction:jboss-transaction-api_1.2_spec", "jakarta.transaction:jakarta.transaction-api");
        bannedDependencies.put("org.jboss.spec.javax.transaction:jboss-transaction-api_1.3_spec", "jakarta.transaction:jakarta.transaction-api");
        bannedDependencies.put("org.jboss.spec.javax.servlet:jboss-servlet-api_4.0_spec", "jakarta.servlet:jakarta.servlet-api");
        bannedDependencies.put("org.jboss.spec.javax.security.jacc:jboss-jacc-api_1.5_spec", "jakarta.security.jacc:jakarta.security.jacc-api");
        bannedDependencies.put("org.jboss.spec.javax.security.auth.message:jboss-jaspi-api_1.1_spec", "jakarta.security.auth.message:jakarta.security.auth.message-api");
        bannedDependencies.put("org.jboss.spec.javax.websocket:jboss-websocket-api_1.1_spec", "jakarta.websocket:jakarta.websocket-api");
        bannedDependencies.put("org.jboss.spec.javax.interceptor:jboss-interceptors-api_1.2_spec", "jakarta.interceptor:jakarta.interceptor-api");
        bannedDependencies.put("javax.activation:activation", "com.sun.activation:jakarta.activation");
        bannedDependencies.put("javax.activation:javax.activation-api", "jakarta.activation:jakarta.activation-api");
        bannedDependencies.put("javax.annotation:javax.annotation-api", "jakarta.annotation:jakarta.annotation-api");
        bannedDependencies.put("javax.enterprise:cdi-api", "jakarta.enterprise:jakarta.enterprise.cdi-api");
        bannedDependencies.put("javax.inject:javax.inject", "jakarta.inject:jakarta.inject-api");
        bannedDependencies.put("javax.json:javax.json-api", "jakarta.json:jakarta.json-api");
        bannedDependencies.put("javax.json.bind:javax.json.bind-api", "jakarta.json.bind:jakarta.json.bind-api");
        bannedDependencies.put("org.glassfish:javax.json", "org.glassfish:jakarta.json");
        bannedDependencies.put("org.glassfish:javax.el", "org.glassfish:jakarta.el");
        bannedDependencies.put("javax.persistence:javax.persistence-api", "jakarta.persistence:jakarta.persistence-api");
        bannedDependencies.put("javax.persistence:persistence-api", "jakarta.persistence:jakarta.persistence-api");
        bannedDependencies.put("javax.security.enterprise:javax.security.enterprise-api", "");
        bannedDependencies.put("javax.servlet:servlet-api", "jakarta.servlet:jakarta.servlet-api");
        bannedDependencies.put("javax.servlet:javax.servlet-api", "jakarta.servlet:jakarta.servlet-api");
        bannedDependencies.put("javax.transaction:jta", "jakarta.transaction:jakarta.transaction-api");
        bannedDependencies.put("javax.transaction:javax.transaction-api", "jakarta.transaction:jakarta.transaction-api");
        bannedDependencies.put("javax.validation:validation-api", "jakarta.validation:jakarta.validation-api");
        bannedDependencies.put("javax.xml.bind:jaxb-api", "org.jboss.spec.javax.xml.bind:jboss-jaxb-api_2.3_spec");
        bannedDependencies.put("javax.websocket:javax.websocket-api", "jakarta.websocket:jakarta.websocket-api");
        bannedDependencies.put("javax.ws.rs:javax.ws.rs-api", "org.jboss.spec.javax.ws.rs:jboss-jaxrs-api_2.1_spec");
        bannedDependencies.put("jakarta.xml.bind:jakarta.xml.bind-api", "org.jboss.spec.javax.xml.bind:jboss-jaxb-api_2.3_spec");
        bannedDependencies.put("jakarta.ws.rs:jakarta.ws.rs-api", "org.jboss.spec.javax.ws.rs:jboss-jaxrs-api_2.1_spec");
        return Collections.unmodifiableMap(bannedDependencies);
    }
}

