/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.bootstrap.BootstrapDependencyProcessingException;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.PersistentAppModel;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.runner.QuarkusEntryPoint;
import io.quarkus.bootstrap.runner.SerializedApplication;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.bootstrap.util.ZipUtils;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedNativeImageClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.builditem.QuarkusBuildCloseablesBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.AppCDSRequestedBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageSourceJarBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.UberJarRequiredBuildItem;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.logging.Logger;

public class JarResultBuildStep {
    private static final Collection<String> IGNORED_ENTRIES = Arrays.asList("META-INF/INDEX.LIST", "META-INF/MANIFEST.MF", "module-info.class", "META-INF/LICENSE", "META-INF/LICENSE.txt", "META-INF/LICENSE.md", "META-INF/NOTICE", "META-INF/NOTICE.txt", "META-INF/NOTICE.md", "META-INF/README", "META-INF/README.txt", "META-INF/README.md", "META-INF/DEPENDENCIES", "META-INF/DEPENDENCIES.txt", "META-INF/beans.xml", "META-INF/io.netty.versions.properties", "META-INF/quarkus-config-roots.list", "META-INF/quarkus-javadoc.properties", "META-INF/quarkus-extension.properties", "META-INF/quarkus-extension.json", "META-INF/quarkus-extension.yaml", "META-INF/quarkus-deployment-dependency.graph", "META-INF/jandex.idx", "LICENSE");
    private static final Logger log = Logger.getLogger(JarResultBuildStep.class);
    private static final StandardOpenOption[] DEFAULT_OPEN_OPTIONS = new StandardOpenOption[]{StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.CREATE};
    private static final BiPredicate<Path, BasicFileAttributes> IS_JSON_FILE_PREDICATE = new IsJsonFilePredicate();
    public static final String DEPLOYMENT_CLASS_PATH_DAT = "deployment-class-path.dat";
    public static final String BUILD_SYSTEM_PROPERTIES = "build-system.properties";
    public static final String DEPLOYMENT_LIB = "deployment";
    public static final String APPMODEL_DAT = "appmodel.dat";
    public static final String QUARKUS_RUN_JAR = "quarkus-run.jar";
    public static final String BOOT_LIB = "boot";
    public static final String LIB = "lib";
    public static final String MAIN = "main";
    public static final String GENERATED_BYTECODE_JAR = "generated-bytecode.jar";
    public static final String TRANSFORMED_BYTECODE_JAR = "transformed-bytecode.jar";
    public static final String APP = "app";
    public static final String QUARKUS = "quarkus";
    public static final String DEFAULT_FAST_JAR_DIRECTORY_NAME = "quarkus-app";
    public static final String RENAMED_JAR_EXTENSION = ".jar.original";

    @BuildStep
    OutputTargetBuildItem outputTarget(BuildSystemTargetBuildItem bst, PackageConfig packageConfig) {
        String name = packageConfig.outputName.orElseGet(bst::getBaseName);
        Path path = packageConfig.outputDirectory.map(s -> bst.getOutputDirectory().resolve((String)s)).orElseGet(bst::getOutputDirectory);
        return new OutputTargetBuildItem(path, name, bst.isRebuild(), bst.getBuildSystemProps());
    }

    @BuildStep(onlyIf={JarRequired.class})
    ArtifactResultBuildItem jarOutput(JarBuildItem jarBuildItem) {
        if (jarBuildItem.getLibraryDir() != null) {
            return new ArtifactResultBuildItem(jarBuildItem.getPath(), "jar", Collections.singletonMap("library-dir", jarBuildItem.getLibraryDir()));
        }
        return new ArtifactResultBuildItem(jarBuildItem.getPath(), "jar", Collections.emptyMap());
    }

    @BuildStep
    public JarBuildItem buildRunnerJar(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, ApplicationInfoBuildItem applicationInfo, PackageConfig packageConfig, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, List<UberJarRequiredBuildItem> uberJarRequired, QuarkusBuildCloseablesBuildItem closeablesBuildItem, List<AdditionalApplicationArchiveBuildItem> additionalApplicationArchiveBuildItems, MainClassBuildItem mainClassBuildItem, Optional<AppCDSRequestedBuildItem> appCDS) throws Exception {
        if (appCDS.isPresent()) {
            this.handleAppCDSSupportFileGeneration(transformedClasses, generatedClasses, appCDS.get());
        }
        if (!packageConfig.type.equalsIgnoreCase("jar") && !packageConfig.type.equalsIgnoreCase("uber-jar") && packageConfig.uberJar) {
            throw new RuntimeException("Cannot set quarkus.package.uber-jar=true and quarkus.package.type, if you want an uber-jar set quarkus.package.type=uber-jar.");
        }
        if (!uberJarRequired.isEmpty() || packageConfig.uberJar || packageConfig.type.equalsIgnoreCase("uber-jar")) {
            return this.buildUberJar(curateOutcomeBuildItem, outputTargetBuildItem, transformedClasses, applicationArchivesBuildItem, packageConfig, applicationInfo, generatedClasses, generatedResources, closeablesBuildItem, mainClassBuildItem);
        }
        if (packageConfig.isLegacyJar()) {
            return this.buildLegacyThinJar(curateOutcomeBuildItem, outputTargetBuildItem, transformedClasses, applicationArchivesBuildItem, packageConfig, applicationInfo, generatedClasses, generatedResources, mainClassBuildItem);
        }
        return this.buildThinJar(curateOutcomeBuildItem, outputTargetBuildItem, transformedClasses, applicationArchivesBuildItem, packageConfig, applicationInfo, generatedClasses, generatedResources, additionalApplicationArchiveBuildItems, mainClassBuildItem);
    }

    private void handleAppCDSSupportFileGeneration(TransformedClassesBuildItem transformedClasses, List<GeneratedClassBuildItem> generatedClasses, AppCDSRequestedBuildItem appCDS) throws IOException {
        Path appCDsDir = appCDS.getAppCDSDir();
        Path generatedClassesFile = appCDsDir.resolve("generatedAndTransformed.lst");
        try (BufferedWriter writer = Files.newBufferedWriter(generatedClassesFile, StandardOpenOption.CREATE);){
            StringBuilder classes = new StringBuilder();
            for (GeneratedClassBuildItem generatedClassBuildItem : generatedClasses) {
                classes.append(generatedClassBuildItem.getName().replace('/', '.')).append(System.lineSeparator());
            }
            for (Set set : transformedClasses.getTransformedClassesByJar().values()) {
                for (TransformedClassesBuildItem.TransformedClass transformedClass : set) {
                    classes.append(transformedClass.getFileName().replace('/', '.').replace(".class", "")).append(System.lineSeparator());
                }
            }
            if (classes.length() != 0) {
                writer.write(classes.toString());
            }
        }
    }

    private JarBuildItem buildUberJar(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, PackageConfig packageConfig, ApplicationInfoBuildItem applicationInfo, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, QuarkusBuildCloseablesBuildItem closeablesBuildItem, MainClassBuildItem mainClassBuildItem) throws Exception {
        Path runnerJar = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + packageConfig.runnerSuffix + ".jar");
        Files.deleteIfExists(runnerJar);
        this.buildUberJar0(curateOutcomeBuildItem, transformedClasses, applicationArchivesBuildItem, packageConfig, applicationInfo, generatedClasses, generatedResources, mainClassBuildItem, runnerJar);
        Path standardJar = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + ".jar");
        Path originalJar = Files.exists(standardJar, new LinkOption[0]) ? outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + RENAMED_JAR_EXTENSION) : null;
        return new JarBuildItem(runnerJar, originalJar, null, "uber-jar", this.suffixToClassifier(packageConfig.runnerSuffix));
    }

    private String suffixToClassifier(String suffix) {
        return suffix.startsWith("-") ? suffix.substring(1) : suffix;
    }

    private void buildUberJar0(CurateOutcomeBuildItem curateOutcomeBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, PackageConfig packageConfig, ApplicationInfoBuildItem applicationInfo, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, MainClassBuildItem mainClassBuildItem, Path runnerJar) throws Exception {
        try (FileSystem runnerZipFs = ZipUtils.newZip((Path)runnerJar);){
            log.info((Object)("Building fat jar: " + runnerJar));
            HashMap<String, String> seen = new HashMap<String, String>();
            HashMap<String, Set<AppDependency>> duplicateCatcher = new HashMap<String, Set<AppDependency>>();
            HashMap<String, List<byte[]>> services = new HashMap<String, List<byte[]>>();
            HashSet<String> finalIgnoredEntries = new HashSet<String>(IGNORED_ENTRIES);
            packageConfig.userConfiguredIgnoredEntries.ifPresent(finalIgnoredEntries::addAll);
            List appDeps = curateOutcomeBuildItem.getEffectiveModel().getUserDependencies();
            AppArtifact appArtifact = curateOutcomeBuildItem.getEffectiveModel().getAppArtifact();
            this.generateManifest(runnerZipFs, "", packageConfig, appArtifact, mainClassBuildItem.getClassName(), applicationInfo);
            for (AppDependency appDep : appDeps) {
                AppArtifact depArtifact = appDep.getArtifact();
                if (!this.isAppDepAJar(depArtifact)) continue;
                for (Path resolvedDep : depArtifact.getPaths()) {
                    Set<String> transformedFromThisArchive = transformedClasses.getTransformedFilesByJar().get(resolvedDep);
                    if (!Files.isDirectory(resolvedDep, new LinkOption[0])) {
                        FileSystem artifactFs = ZipUtils.newFileSystem((Path)resolvedDep);
                        Throwable throwable = null;
                        try {
                            for (Path root : artifactFs.getRootDirectories()) {
                                this.walkFileDependencyForDependency(root, runnerZipFs, seen, duplicateCatcher, services, finalIgnoredEntries, appDep, transformedFromThisArchive);
                            }
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (artifactFs == null) continue;
                            if (throwable != null) {
                                try {
                                    artifactFs.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            artifactFs.close();
                            continue;
                        }
                    }
                    this.walkFileDependencyForDependency(resolvedDep, runnerZipFs, seen, duplicateCatcher, services, finalIgnoredEntries, appDep, transformedFromThisArchive);
                }
            }
            HashSet explained = new HashSet();
            for (Map.Entry entry : duplicateCatcher.entrySet()) {
                if (((Set)entry.getValue()).size() <= 1 || !explained.add(entry.getValue())) continue;
                log.warn((Object)("Dependencies with duplicate files detected. The dependencies " + entry.getValue() + " contain duplicate files, e.g. " + (String)entry.getKey()));
            }
            this.copyCommonContent(runnerZipFs, services, applicationArchivesBuildItem, transformedClasses, generatedClasses, generatedResources, seen, finalIgnoredEntries);
        }
        runnerJar.toFile().setReadable(true, false);
    }

    private boolean isAppDepAJar(AppArtifact artifact) {
        return "jar".equals(artifact.getType());
    }

    private void walkFileDependencyForDependency(final Path root, final FileSystem runnerZipFs, final Map<String, String> seen, final Map<String, Set<AppDependency>> duplicateCatcher, final Map<String, List<byte[]>> services, final Set<String> finalIgnoredEntries, final AppDependency appDep, final Set<String> transformedFromThisArchive) throws IOException {
        final Path metaInfDir = root.resolve("META-INF");
        Files.walkFileTree(root, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String relativePath = JarResultBuildStep.toUri(root.relativize(dir));
                if (!relativePath.isEmpty()) {
                    JarResultBuildStep.this.addDir(runnerZipFs, relativePath);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                boolean transformed;
                String relativePath = JarResultBuildStep.toUri(root.relativize(file));
                if (JarResultBuildStep.isBlockOrSF(relativePath) && file.relativize(metaInfDir).getNameCount() == 1) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Signature file " + file.toAbsolutePath() + " from app dependency " + appDep + " will not be included in uberjar"));
                    }
                    return FileVisitResult.CONTINUE;
                }
                boolean bl = transformed = transformedFromThisArchive != null && transformedFromThisArchive.contains(relativePath);
                if (!transformed) {
                    if (relativePath.startsWith("META-INF/services/") && relativePath.length() > 18) {
                        services.computeIfAbsent(relativePath, u -> new ArrayList()).add(Files.readAllBytes(file));
                        return FileVisitResult.CONTINUE;
                    }
                    if (!finalIgnoredEntries.contains(relativePath)) {
                        duplicateCatcher.computeIfAbsent(relativePath, a -> new HashSet()).add(appDep);
                        if (!seen.containsKey(relativePath)) {
                            seen.put(relativePath, appDep.toString());
                            Files.copy(file, runnerZipFs.getPath(relativePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        } else if (!relativePath.endsWith(".class")) {
                            log.warn((Object)("Duplicate entry " + relativePath + " entry from " + appDep + " will be ignored. Existing file was provided by " + (String)seen.get(relativePath)));
                        }
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private JarBuildItem buildLegacyThinJar(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, PackageConfig packageConfig, ApplicationInfoBuildItem applicationInfo, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, MainClassBuildItem mainClassBuildItem) throws Exception {
        Path runnerJar = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + packageConfig.runnerSuffix + ".jar");
        Path libDir = outputTargetBuildItem.getOutputDirectory().resolve(LIB);
        Files.deleteIfExists(runnerJar);
        IoUtils.recursiveDelete((Path)libDir);
        Files.createDirectories(libDir, new FileAttribute[0]);
        try (FileSystem runnerZipFs = ZipUtils.newZip((Path)runnerJar);){
            log.info((Object)("Building thin jar: " + runnerJar));
            this.doLegacyThinJarGeneration(curateOutcomeBuildItem, transformedClasses, applicationArchivesBuildItem, applicationInfo, packageConfig, generatedResources, libDir, generatedClasses, runnerZipFs, mainClassBuildItem);
        }
        runnerJar.toFile().setReadable(true, false);
        return new JarBuildItem(runnerJar, null, libDir, "legacy", this.suffixToClassifier(packageConfig.runnerSuffix));
    }

    private JarBuildItem buildThinJar(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, PackageConfig packageConfig, ApplicationInfoBuildItem applicationInfo, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, List<AdditionalApplicationArchiveBuildItem> additionalApplicationArchiveBuildItems, MainClassBuildItem mainClassBuildItem) throws Exception {
        Object target42;
        Throwable throwable;
        FileSystem out;
        boolean rebuild = outputTargetBuildItem.isRebuild();
        Path buildDir = packageConfig.outputDirectory.isPresent() ? outputTargetBuildItem.getOutputDirectory() : outputTargetBuildItem.getOutputDirectory().resolve(DEFAULT_FAST_JAR_DIRECTORY_NAME);
        Path libDir = buildDir.resolve(LIB);
        Path mainLib = libDir.resolve(MAIN);
        Path baseLib = libDir.resolve(BOOT_LIB);
        Files.createDirectories(baseLib, new FileAttribute[0]);
        Path appDir = buildDir.resolve(APP);
        Path quarkus = buildDir.resolve(QUARKUS);
        Path userProviders = null;
        if (packageConfig.userProvidersDirectory.isPresent()) {
            userProviders = buildDir.resolve(packageConfig.userProvidersDirectory.get());
        }
        if (!rebuild) {
            IoUtils.recursiveDelete((Path)buildDir);
            Files.createDirectories(buildDir, new FileAttribute[0]);
            Files.createDirectories(mainLib, new FileAttribute[0]);
            Files.createDirectories(baseLib, new FileAttribute[0]);
            Files.createDirectories(appDir, new FileAttribute[0]);
            Files.createDirectories(quarkus, new FileAttribute[0]);
            if (userProviders != null) {
                Files.createDirectories(userProviders, new FileAttribute[0]);
                Files.createFile(userProviders.resolve(".keep"), new FileAttribute[0]);
            }
        } else {
            IoUtils.recursiveDelete((Path)quarkus);
            Files.createDirectories(quarkus, new FileAttribute[0]);
        }
        HashMap<AppArtifactKey, List<Path>> copiedArtifacts = new HashMap<AppArtifactKey, List<Path>>();
        ArrayList<Path> jars = new ArrayList<Path>();
        ArrayList bootJars = new ArrayList();
        if (!transformedClasses.getTransformedClassesByJar().isEmpty()) {
            Path transformedZip = quarkus.resolve(TRANSFORMED_BYTECODE_JAR);
            jars.add(transformedZip);
            out = ZipUtils.newZip((Path)transformedZip);
            throwable = null;
            try {
                for (Set set : transformedClasses.getTransformedClassesByJar().values()) {
                    for (TransformedClassesBuildItem.TransformedClass transformed : set) {
                        Path target2 = out.getPath(transformed.getFileName(), new String[0]);
                        if (target2.getParent() != null) {
                            Files.createDirectories(target2.getParent(), new FileAttribute[0]);
                        }
                        Files.write(target2, transformed.getData(), new OpenOption[0]);
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        Path generatedZip = quarkus.resolve(GENERATED_BYTECODE_JAR);
        jars.add(generatedZip);
        out = ZipUtils.newZip((Path)generatedZip);
        throwable = null;
        try {
            for (GeneratedClassBuildItem generatedClassBuildItem : generatedClasses) {
                String fileName = generatedClassBuildItem.getName().replace(".", "/") + ".class";
                Path target3 = out.getPath(fileName, new String[0]);
                if (target3.getParent() != null) {
                    Files.createDirectories(target3.getParent(), new FileAttribute[0]);
                }
                Files.write(target3, generatedClassBuildItem.getClassData(), new OpenOption[0]);
            }
            for (GeneratedResourceBuildItem generatedResourceBuildItem : generatedResources) {
                target42 = out.getPath(generatedResourceBuildItem.getName(), new String[0]);
                if (target42.getParent() != null) {
                    Files.createDirectories(target42.getParent(), new FileAttribute[0]);
                }
                Files.write((Path)target42, generatedResourceBuildItem.getClassData(), new OpenOption[0]);
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (out != null) {
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    out.close();
                }
            }
        }
        Path runnerJar = appDir.resolve(outputTargetBuildItem.getBaseName() + ".jar");
        jars.add(runnerJar);
        if (!rebuild) {
            HashSet<String> finalIgnoredEntries = new HashSet<String>(IGNORED_ENTRIES);
            packageConfig.userConfiguredIgnoredEntries.ifPresent(finalIgnoredEntries::addAll);
            Throwable throwable2 = null;
            try (FileSystem runnerZipFs = ZipUtils.newZip((Path)runnerJar);){
                for (Path root : applicationArchivesBuildItem.getRootArchive().getRootDirs()) {
                    this.copyFiles(root, runnerZipFs, null, finalIgnoredEntries);
                }
            }
            catch (Throwable target42) {
                Throwable throwable3 = target42;
                throw target42;
            }
        }
        StringBuilder classPath = new StringBuilder();
        for (AppDependency appDependency : curateOutcomeBuildItem.getEffectiveModel().getUserDependencies()) {
            if (rebuild) {
                jars.addAll(appDependency.getArtifact().getPaths().toList());
            } else {
                this.copyDependency(curateOutcomeBuildItem, copiedArtifacts, mainLib, baseLib, jars, true, classPath, appDependency);
            }
            if (!curateOutcomeBuildItem.getEffectiveModel().getParentFirstArtifacts().contains(appDependency.getArtifact().getKey())) continue;
            bootJars.addAll(appDependency.getArtifact().getPaths().toList());
        }
        for (AdditionalApplicationArchiveBuildItem additionalApplicationArchiveBuildItem : additionalApplicationArchiveBuildItems) {
            for (Object path2 : additionalApplicationArchiveBuildItem.getPaths()) {
                if (!path2.getParent().equals(userProviders)) {
                    throw new RuntimeException("Additional application archives can only be provided from the user providers directory. " + path2 + " is not present in " + userProviders);
                }
                jars.add((Path)path2);
            }
        }
        Path appInfo = buildDir.resolve("quarkus/quarkus-application.dat");
        OutputStream outputStream = Files.newOutputStream(appInfo, new OpenOption[0]);
        target42 = null;
        try {
            SerializedApplication.write((OutputStream)outputStream, (String)mainClassBuildItem.getClassName(), (Path)buildDir, jars, bootJars);
        }
        catch (Throwable path2) {
            target42 = path2;
            throw path2;
        }
        finally {
            if (outputStream != null) {
                if (target42 != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable path2) {
                        ((Throwable)target42).addSuppressed(path2);
                    }
                } else {
                    outputStream.close();
                }
            }
        }
        runnerJar.toFile().setReadable(true, false);
        Path path = buildDir.resolve(QUARKUS_RUN_JAR);
        if (!rebuild) {
            Object path2;
            FileSystem runnerZipFs = ZipUtils.newZip((Path)path);
            path2 = null;
            try {
                AppArtifact appArtifact = curateOutcomeBuildItem.getEffectiveModel().getAppArtifact();
                this.generateManifest(runnerZipFs, classPath.toString(), packageConfig, appArtifact, QuarkusEntryPoint.class.getName(), applicationInfo);
            }
            catch (Throwable appArtifact) {
                path2 = appArtifact;
                throw appArtifact;
            }
            finally {
                if (runnerZipFs != null) {
                    if (path2 != null) {
                        try {
                            runnerZipFs.close();
                        }
                        catch (Throwable appArtifact) {
                            ((Throwable)path2).addSuppressed(appArtifact);
                        }
                    } else {
                        runnerZipFs.close();
                    }
                }
            }
            if (packageConfig.type.equalsIgnoreCase("mutable-jar")) {
                Object obj;
                Path deploymentLib = libDir.resolve(DEPLOYMENT_LIB);
                Files.createDirectories(deploymentLib, new FileAttribute[0]);
                for (Object appDep : curateOutcomeBuildItem.getEffectiveModel().getFullDeploymentDeps()) {
                    this.copyDependency(curateOutcomeBuildItem, copiedArtifacts, deploymentLib, baseLib, jars, false, classPath, (AppDependency)appDep);
                }
                HashMap relativePaths = new HashMap();
                for (Map.Entry entry : copiedArtifacts.entrySet()) {
                    relativePaths.put(entry.getKey(), ((List)entry.getValue()).stream().map(s -> buildDir.relativize((Path)s).toString()).collect(Collectors.toList()));
                }
                PersistentAppModel model = new PersistentAppModel(outputTargetBuildItem.getBaseName(), relativePaths, curateOutcomeBuildItem.getEffectiveModel(), (String)packageConfig.userProvidersDirectory.orElse(null), buildDir.relativize(runnerJar).toString());
                Path path3 = deploymentLib.resolve(APPMODEL_DAT);
                try (OutputStream out3 = Files.newOutputStream(path3, new OpenOption[0]);){
                    obj = new ObjectOutputStream(out3);
                    ((ObjectOutputStream)obj).writeObject(model);
                    ((ObjectOutputStream)obj).close();
                }
                Path deploymentCp = deploymentLib.resolve(DEPLOYMENT_CLASS_PATH_DAT);
                OutputStream out4 = Files.newOutputStream(deploymentCp, new OpenOption[0]);
                obj = null;
                try {
                    ObjectOutputStream obj2 = new ObjectOutputStream(out4);
                    ArrayList paths = new ArrayList();
                    for (AppDependency i : curateOutcomeBuildItem.getEffectiveModel().getFullDeploymentDeps()) {
                        paths.addAll((Collection)relativePaths.get(i.getArtifact().getKey()));
                    }
                    obj2.writeObject(paths);
                    obj2.close();
                }
                catch (Throwable throwable4) {
                    obj = throwable4;
                    throw throwable4;
                }
                finally {
                    if (out4 != null) {
                        if (obj != null) {
                            try {
                                out4.close();
                            }
                            catch (Throwable throwable5) {
                                ((Throwable)obj).addSuppressed(throwable5);
                            }
                        } else {
                            out4.close();
                        }
                    }
                }
                Path buildSystemProps = deploymentLib.resolve(BUILD_SYSTEM_PROPERTIES);
                try (OutputStream out5 = Files.newOutputStream(buildSystemProps, new OpenOption[0]);){
                    outputTargetBuildItem.getBuildSystemProperties().store(out5, "The original build properties");
                }
            }
        }
        try (Stream<Path> files = Files.walk(buildDir, new FileVisitOption[0]);){
            files.forEach(new Consumer<Path>(){

                @Override
                public void accept(Path path) {
                    path.toFile().setReadable(true, false);
                }
            });
        }
        return new JarBuildItem(path, null, libDir, packageConfig.type, null);
    }

    private void copyDependency(CurateOutcomeBuildItem curateOutcomeBuildItem, Map<AppArtifactKey, List<Path>> runtimeArtifacts, Path libDir, Path baseLib, List<Path> jars, boolean allowParentFirst, StringBuilder classPath, AppDependency appDep) throws IOException {
        AppArtifact depArtifact = appDep.getArtifact();
        if (!this.isAppDepAJar(depArtifact)) {
            return;
        }
        if (runtimeArtifacts.containsKey(depArtifact.getKey())) {
            return;
        }
        for (final Path resolvedDep : depArtifact.getPaths()) {
            Path targetPath;
            String fileName;
            if (!Files.isDirectory(resolvedDep, new LinkOption[0])) {
                if (allowParentFirst && curateOutcomeBuildItem.getEffectiveModel().getParentFirstArtifacts().contains(depArtifact.getKey())) {
                    fileName = depArtifact.getGroupId() + "." + resolvedDep.getFileName();
                    targetPath = baseLib.resolve(fileName);
                    Files.copy(resolvedDep, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    classPath.append(" ").append(LIB).append("/").append(BOOT_LIB).append("/").append(fileName);
                    runtimeArtifacts.computeIfAbsent(depArtifact.getKey(), s -> new ArrayList()).add(targetPath);
                    continue;
                }
                fileName = depArtifact.getGroupId() + "." + resolvedDep.getFileName();
                targetPath = libDir.resolve(fileName);
                Files.copy(resolvedDep, targetPath, StandardCopyOption.REPLACE_EXISTING);
                jars.add(targetPath);
                runtimeArtifacts.computeIfAbsent(depArtifact.getKey(), s -> new ArrayList()).add(targetPath);
                continue;
            }
            fileName = depArtifact.getGroupId() + "." + resolvedDep.getFileName();
            targetPath = libDir.resolve(fileName);
            runtimeArtifacts.computeIfAbsent(depArtifact.getKey(), s -> new ArrayList()).add(targetPath);
            jars.add(targetPath);
            final FileSystem runnerZipFs = ZipUtils.newZip((Path)targetPath);
            Throwable throwable = null;
            try {
                Files.walkFileTree(resolvedDep, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path relativePath = resolvedDep.relativize(file);
                        Path targetPath = runnerZipFs.getPath(relativePath.toString(), new String[0]);
                        if (targetPath.getParent() != null) {
                            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                        }
                        Files.copy(file, targetPath, StandardCopyOption.REPLACE_EXISTING);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (runnerZipFs == null) continue;
                if (throwable != null) {
                    try {
                        runnerZipFs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                runnerZipFs.close();
            }
        }
    }

    @BuildStep
    public NativeImageSourceJarBuildItem buildNativeImageJar(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, ApplicationInfoBuildItem applicationInfo, PackageConfig packageConfig, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedNativeImageClassBuildItem> nativeImageResources, List<GeneratedResourceBuildItem> generatedResources, MainClassBuildItem mainClassBuildItem, List<UberJarRequiredBuildItem> uberJarRequired) throws Exception {
        Path targetDirectory = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + "-native-image-source-jar");
        IoUtils.recursiveDelete((Path)targetDirectory);
        Files.createDirectories(targetDirectory, new FileAttribute[0]);
        ArrayList<GeneratedClassBuildItem> allClasses = new ArrayList<GeneratedClassBuildItem>(generatedClasses);
        allClasses.addAll(nativeImageResources.stream().map(s -> new GeneratedClassBuildItem(true, s.getName(), s.getClassData())).collect(Collectors.toList()));
        if (SystemUtils.IS_OS_WINDOWS) {
            log.warn((Object)"Uber JAR strategy is used for native image source JAR generation on Windows. This is done for the time being to work around a current GraalVM limitation on Windows concerning the maximum command length (see https://github.com/oracle/graal/issues/2387).");
            return this.buildNativeImageUberJar(curateOutcomeBuildItem, outputTargetBuildItem, transformedClasses, applicationArchivesBuildItem, packageConfig, applicationInfo, allClasses, generatedResources, mainClassBuildItem, targetDirectory);
        }
        return this.buildNativeImageThinJar(curateOutcomeBuildItem, outputTargetBuildItem, transformedClasses, applicationArchivesBuildItem, applicationInfo, packageConfig, allClasses, generatedResources, mainClassBuildItem, targetDirectory);
    }

    private NativeImageSourceJarBuildItem buildNativeImageThinJar(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, ApplicationInfoBuildItem applicationInfo, PackageConfig packageConfig, List<GeneratedClassBuildItem> allClasses, List<GeneratedResourceBuildItem> generatedResources, MainClassBuildItem mainClassBuildItem, Path targetDirectory) throws Exception {
        this.copyJsonConfigFiles(applicationArchivesBuildItem, targetDirectory);
        Path runnerJar = targetDirectory.resolve(outputTargetBuildItem.getBaseName() + packageConfig.runnerSuffix + ".jar");
        Path libDir = targetDirectory.resolve(LIB);
        Files.createDirectories(libDir, new FileAttribute[0]);
        try (FileSystem runnerZipFs = ZipUtils.newZip((Path)runnerJar);){
            log.info((Object)("Building native image source jar: " + runnerJar));
            this.doLegacyThinJarGeneration(curateOutcomeBuildItem, transformedClasses, applicationArchivesBuildItem, applicationInfo, packageConfig, generatedResources, libDir, allClasses, runnerZipFs, mainClassBuildItem);
        }
        runnerJar.toFile().setReadable(true, false);
        return new NativeImageSourceJarBuildItem(runnerJar, libDir);
    }

    private NativeImageSourceJarBuildItem buildNativeImageUberJar(CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, PackageConfig packageConfig, ApplicationInfoBuildItem applicationInfo, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, MainClassBuildItem mainClassBuildItem, Path targetDirectory) throws Exception {
        Path runnerJar = targetDirectory.resolve(outputTargetBuildItem.getBaseName() + packageConfig.runnerSuffix + ".jar");
        this.buildUberJar0(curateOutcomeBuildItem, transformedClasses, applicationArchivesBuildItem, packageConfig, applicationInfo, generatedClasses, generatedResources, mainClassBuildItem, runnerJar);
        return new NativeImageSourceJarBuildItem(runnerJar, null);
    }

    private void copyJsonConfigFiles(ApplicationArchivesBuildItem applicationArchivesBuildItem, final Path thinJarDirectory) throws IOException {
        for (Path root : applicationArchivesBuildItem.getRootArchive().getRootDirs()) {
            Stream<Path> stream = Files.find(root, 1, IS_JSON_FILE_PREDICATE, new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                stream.forEach(new Consumer<Path>(){

                    @Override
                    public void accept(Path jsonPath) {
                        try {
                            Files.copy(jsonPath, thinJarDirectory.resolve(jsonPath.getFileName().toString()), new CopyOption[0]);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException("Unable to copy json config file from " + jsonPath + " to " + thinJarDirectory, e);
                        }
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
    }

    private void doLegacyThinJarGeneration(CurateOutcomeBuildItem curateOutcomeBuildItem, TransformedClassesBuildItem transformedClasses, ApplicationArchivesBuildItem applicationArchivesBuildItem, ApplicationInfoBuildItem applicationInfo, PackageConfig packageConfig, List<GeneratedResourceBuildItem> generatedResources, Path libDir, List<GeneratedClassBuildItem> allClasses, FileSystem runnerZipFs, MainClassBuildItem mainClassBuildItem) throws BootstrapDependencyProcessingException, AppModelResolverException, IOException {
        HashMap<String, String> seen = new HashMap<String, String>();
        StringBuilder classPath = new StringBuilder();
        HashMap<String, List<byte[]>> services = new HashMap<String, List<byte[]>>();
        List appDeps = curateOutcomeBuildItem.getEffectiveModel().getUserDependencies();
        HashSet<String> finalIgnoredEntries = new HashSet<String>(IGNORED_ENTRIES);
        packageConfig.userConfiguredIgnoredEntries.ifPresent(finalIgnoredEntries::addAll);
        this.copyLibraryJars(runnerZipFs, transformedClasses, libDir, classPath, appDeps, services, finalIgnoredEntries);
        AppArtifact appArtifact = curateOutcomeBuildItem.getEffectiveModel().getAppArtifact();
        this.generateManifest(runnerZipFs, classPath.toString(), packageConfig, appArtifact, mainClassBuildItem.getClassName(), applicationInfo);
        this.copyCommonContent(runnerZipFs, services, applicationArchivesBuildItem, transformedClasses, allClasses, generatedResources, seen, finalIgnoredEntries);
    }

    private void copyLibraryJars(final FileSystem runnerZipFs, TransformedClassesBuildItem transformedClasses, Path libDir, StringBuilder classPath, List<AppDependency> appDeps, final Map<String, List<byte[]>> services, final Set<String> ignoredEntries) throws IOException {
        for (AppDependency appDep : appDeps) {
            AppArtifact depArtifact = appDep.getArtifact();
            if (!this.isAppDepAJar(depArtifact)) continue;
            for (final Path resolvedDep : depArtifact.getPaths()) {
                if (!Files.isDirectory(resolvedDep, new LinkOption[0])) {
                    Path targetPath;
                    String fileName;
                    Set<String> transformedFromThisArchive = transformedClasses.getTransformedFilesByJar().get(resolvedDep);
                    if (transformedFromThisArchive == null || transformedFromThisArchive.isEmpty()) {
                        fileName = depArtifact.getGroupId() + "." + resolvedDep.getFileName();
                        targetPath = libDir.resolve(fileName);
                        Files.copy(resolvedDep, targetPath, StandardCopyOption.REPLACE_EXISTING);
                        classPath.append(" lib/").append(fileName);
                        continue;
                    }
                    fileName = "modified-" + depArtifact.getGroupId() + "." + resolvedDep.getFileName();
                    targetPath = libDir.resolve(fileName);
                    classPath.append(" lib/").append(fileName);
                    this.filterZipFile(resolvedDep, targetPath, transformedFromThisArchive);
                    continue;
                }
                Files.walkFileTree(resolvedDep, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path relativePath = resolvedDep.relativize(file);
                        String relativeUri = JarResultBuildStep.toUri(relativePath);
                        if (ignoredEntries.contains(relativeUri)) {
                            return FileVisitResult.CONTINUE;
                        }
                        if (relativeUri.startsWith("META-INF/services/") && relativeUri.length() > 18) {
                            services.computeIfAbsent(relativeUri, u -> new ArrayList()).add(Files.readAllBytes(file));
                        } else if (file.getFileName().toString().endsWith(".class")) {
                            Path targetPath = runnerZipFs.getPath(relativePath.toString(), new String[0]);
                            if (targetPath.getParent() != null) {
                                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                            }
                            Files.copy(file, targetPath, StandardCopyOption.REPLACE_EXISTING);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
    }

    private void copyCommonContent(FileSystem runnerZipFs, Map<String, List<byte[]>> services, ApplicationArchivesBuildItem appArchives, TransformedClassesBuildItem transformedClassesBuildItem, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, Map<String, String> seen, Set<String> ignoredEntries) throws IOException {
        Object out22;
        for (Set<TransformedClassesBuildItem.TransformedClass> set : transformedClassesBuildItem.getTransformedClassesByJar().values()) {
            for (TransformedClassesBuildItem.TransformedClass i : set) {
                Path target = runnerZipFs.getPath(i.getFileName(), new String[0]);
                this.handleParent(runnerZipFs, i.getFileName(), seen);
                out22 = ZipUtils.wrapForJDK8232879((OutputStream)Files.newOutputStream(target, DEFAULT_OPEN_OPTIONS));
                Throwable throwable = null;
                try {
                    ((OutputStream)out22).write(i.getData());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out22 != null) {
                        if (throwable != null) {
                            try {
                                ((OutputStream)out22).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((OutputStream)out22).close();
                        }
                    }
                }
                seen.put(i.getFileName(), "Current Application");
            }
        }
        for (GeneratedClassBuildItem generatedClassBuildItem : generatedClasses) {
            String fileName = generatedClassBuildItem.getName().replace(".", "/") + ".class";
            seen.put(fileName, "Current Application");
            Path target = runnerZipFs.getPath(fileName, new String[0]);
            this.handleParent(runnerZipFs, fileName, seen);
            if (Files.exists(target, new LinkOption[0])) continue;
            OutputStream os = ZipUtils.wrapForJDK8232879((OutputStream)Files.newOutputStream(target, DEFAULT_OPEN_OPTIONS));
            out22 = null;
            try {
                os.write(generatedClassBuildItem.getClassData());
            }
            catch (Throwable throwable) {
                out22 = throwable;
                throw throwable;
            }
            finally {
                if (os == null) continue;
                if (out22 != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)out22).addSuppressed(throwable);
                    }
                    continue;
                }
                os.close();
            }
        }
        for (GeneratedResourceBuildItem generatedResourceBuildItem : generatedResources) {
            if (ignoredEntries.contains(generatedResourceBuildItem.getName())) continue;
            Path target = runnerZipFs.getPath(generatedResourceBuildItem.getName(), new String[0]);
            this.handleParent(runnerZipFs, generatedResourceBuildItem.getName(), seen);
            if (Files.exists(target, new LinkOption[0])) continue;
            if (generatedResourceBuildItem.getName().startsWith("META-INF/services")) {
                services.computeIfAbsent(generatedResourceBuildItem.getName(), u -> new ArrayList()).add(generatedResourceBuildItem.getClassData());
                continue;
            }
            OutputStream os = ZipUtils.wrapForJDK8232879((OutputStream)Files.newOutputStream(target, DEFAULT_OPEN_OPTIONS));
            Object object = null;
            try {
                os.write(generatedResourceBuildItem.getClassData());
            }
            catch (Throwable out22) {
                object = out22;
                throw out22;
            }
            finally {
                if (os == null) continue;
                if (object != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable out22) {
                        ((Throwable)object).addSuppressed(out22);
                    }
                    continue;
                }
                os.close();
            }
        }
        for (Path path : appArchives.getRootArchive().getRootDirs()) {
            this.copyFiles(path, runnerZipFs, services, ignoredEntries);
        }
        for (Map.Entry entry : services.entrySet()) {
            OutputStream os = ZipUtils.wrapForJDK8232879((OutputStream)Files.newOutputStream(runnerZipFs.getPath((String)entry.getKey(), new String[0]), DEFAULT_OPEN_OPTIONS));
            Throwable throwable = null;
            try {
                for (byte[] i : (List)entry.getValue()) {
                    os.write(i);
                    os.write(10);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (os == null) continue;
                if (throwable != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                os.close();
            }
        }
    }

    private void handleParent(FileSystem runnerZipFs, String fileName, Map<String, String> seen) throws IOException {
        for (int i = 0; i < fileName.length(); ++i) {
            String dir;
            if (fileName.charAt(i) != '/' || seen.containsKey(dir = fileName.substring(0, i))) continue;
            seen.put(dir, "Current Application");
            Files.createDirectories(runnerZipFs.getPath(dir, new String[0]), new FileAttribute[0]);
        }
    }

    private void filterZipFile(Path resolvedDep, Path targetPath, Set<String> transformedFromThisArchive) {
        try {
            byte[] buffer = new byte[10000];
            try (ZipFile in = new ZipFile(resolvedDep.toFile());
                 ZipOutputStream out = new ZipOutputStream(new FileOutputStream(targetPath.toFile()));){
                Enumeration<? extends ZipEntry> entries = in.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (transformedFromThisArchive.contains(entry.getName())) continue;
                    out.putNextEntry(entry);
                    InputStream inStream = in.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        int r = 0;
                        while ((r = inStream.read(buffer)) > 0) {
                            out.write(buffer, 0, r);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inStream == null) continue;
                        if (throwable != null) {
                            try {
                                inStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void generateManifest(FileSystem runnerZipFs, String classPath, PackageConfig config, AppArtifact appArtifact, String mainClassName, ApplicationInfoBuildItem applicationInfo) throws IOException {
        String existingMainClass;
        Path manifestPath = runnerZipFs.getPath("META-INF", "MANIFEST.MF");
        Manifest manifest = new Manifest();
        if (Files.exists(manifestPath, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(manifestPath, new OpenOption[0]);){
                manifest.read(is);
            }
            Files.delete(manifestPath);
        } else {
            Files.createDirectories(runnerZipFs.getPath("META-INF", new String[0]), new FileAttribute[0]);
        }
        Files.createDirectories(manifestPath.getParent(), new FileAttribute[0]);
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        if (attributes.containsKey(Attributes.Name.CLASS_PATH)) {
            log.warn((Object)"Your MANIFEST.MF already defined a CLASS_PATH entry. Quarkus has overwritten this existing entry.");
        }
        attributes.put(Attributes.Name.CLASS_PATH, classPath);
        if (attributes.containsKey(Attributes.Name.MAIN_CLASS) && !mainClassName.equals(existingMainClass = attributes.getValue(Attributes.Name.MAIN_CLASS))) {
            log.warn((Object)"Your MANIFEST.MF already defined a MAIN_CLASS entry. Quarkus has overwritten your existing entry.");
        }
        attributes.put(Attributes.Name.MAIN_CLASS, mainClassName);
        if (config.manifest.addImplementationEntries && !attributes.containsKey(Attributes.Name.IMPLEMENTATION_TITLE)) {
            String name = "<<unset>>".equals(applicationInfo.getName()) ? appArtifact.getArtifactId() : applicationInfo.getName();
            attributes.put(Attributes.Name.IMPLEMENTATION_TITLE, name);
        }
        if (config.manifest.addImplementationEntries && !attributes.containsKey(Attributes.Name.IMPLEMENTATION_VERSION)) {
            String version = "<<unset>>".equals(applicationInfo.getVersion()) ? appArtifact.getVersion() : applicationInfo.getVersion();
            attributes.put(Attributes.Name.IMPLEMENTATION_VERSION, version);
        }
        if (config.manifest.manifestSections.size() > 0) {
            for (String sectionName : config.manifest.manifestSections.keySet()) {
                for (Map.Entry<String, String> entry : config.manifest.manifestSections.get(sectionName).entrySet()) {
                    Attributes attribs = manifest.getEntries().computeIfAbsent(sectionName, k -> new Attributes());
                    attribs.putValue(entry.getKey(), entry.getValue());
                }
            }
        }
        try (OutputStream os = ZipUtils.wrapForJDK8232879((OutputStream)Files.newOutputStream(manifestPath, DEFAULT_OPEN_OPTIONS));){
            manifest.write(os);
        }
    }

    private void copyFiles(final Path dir, final FileSystem fs, final Map<String, List<byte[]>> services, final Set<String> ignoredEntries) throws IOException {
        try (Stream<Path> fileTreeElements = Files.walk(dir, new FileVisitOption[0]);){
            fileTreeElements.forEach(new Consumer<Path>(){

                @Override
                public void accept(Path path) {
                    block8: {
                        Path file = dir.relativize(path);
                        String relativePath = JarResultBuildStep.toUri(file);
                        if (relativePath.isEmpty() || ignoredEntries.contains(relativePath)) {
                            return;
                        }
                        try {
                            Path target;
                            if (Files.isDirectory(path, new LinkOption[0])) {
                                JarResultBuildStep.this.addDir(fs, relativePath);
                                break block8;
                            }
                            if (relativePath.startsWith("META-INF/services/") && relativePath.length() > 18 && services != null) {
                                byte[] content;
                                try {
                                    content = Files.readAllBytes(path);
                                }
                                catch (IOException e) {
                                    throw new UncheckedIOException(e);
                                }
                                services.computeIfAbsent(relativePath, u -> new ArrayList()).add(content);
                                break block8;
                            }
                            if (!relativePath.equals("META-INF/INDEX.LIST") && !Files.exists(target = fs.getPath(relativePath, new String[0]), new LinkOption[0])) {
                                Files.copy(path, target, StandardCopyOption.REPLACE_EXISTING);
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException re) {
            Throwable cause = re.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw re;
        }
    }

    private void addDir(FileSystem fs, String relativePath) throws IOException {
        block2: {
            Path targetDir = fs.getPath(relativePath, new String[0]);
            try {
                Files.createDirectory(targetDir, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                throw e;
            }
        }
    }

    private static String toUri(Path path) {
        if (path.isAbsolute()) {
            return path.toUri().getPath();
        }
        if (path.getNameCount() == 0) {
            return "";
        }
        return JarResultBuildStep.toUri(new StringBuilder(), path, 0).toString();
    }

    private static StringBuilder toUri(StringBuilder b, Path path, int seg) {
        b.append(path.getName(seg));
        if (seg < path.getNameCount() - 1) {
            b.append('/');
            JarResultBuildStep.toUri(b, path, seg + 1);
        }
        return b;
    }

    static boolean isBlockOrSF(String s) {
        if (s == null) {
            return false;
        }
        return s.endsWith(".SF") || s.endsWith(".DSA") || s.endsWith(".RSA") || s.endsWith(".EC");
    }

    private static class IsJsonFilePredicate
    implements BiPredicate<Path, BasicFileAttributes> {
        private IsJsonFilePredicate() {
        }

        @Override
        public boolean test(Path path, BasicFileAttributes basicFileAttributes) {
            return basicFileAttributes.isRegularFile() && path.toString().endsWith(".json");
        }
    }

    static class JarRequired
    implements BooleanSupplier {
        private final PackageConfig packageConfig;

        JarRequired(PackageConfig packageConfig) {
            this.packageConfig = packageConfig;
        }

        @Override
        public boolean getAsBoolean() {
            return this.packageConfig.isAnyJarType();
        }
    }
}

