/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.steps.NativeImageBuildContainerRunner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.List;
import org.jboss.logging.Logger;

public class NativeImageBuildRemoteContainerRunner
extends NativeImageBuildContainerRunner {
    private static final Logger log = Logger.getLogger(NativeImageBuildRemoteContainerRunner.class);
    private final String resultingExecutableName;
    private String containerId;

    public NativeImageBuildRemoteContainerRunner(NativeConfig nativeConfig, Path outputDir, String resultingExecutableName) {
        super(nativeConfig, outputDir);
        this.resultingExecutableName = resultingExecutableName;
    }

    @Override
    protected void preBuild(List<String> buildArgs) throws InterruptedException, IOException {
        List<String> containerRuntimeArgs = this.getContainerRuntimeBuildArgs();
        CharSequence[] createContainerCommand = this.buildCommand("create", containerRuntimeArgs, buildArgs);
        log.info((Object)String.join((CharSequence)" ", createContainerCommand).replace("$", "\\$"));
        Process createContainerProcess = new ProcessBuilder((String[])createContainerCommand).start();
        if (createContainerProcess.waitFor() != 0) {
            throw new RuntimeException("Failed to create builder container.");
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(createContainerProcess.getInputStream()));){
            this.containerId = reader.readLine();
        }
        String[] copyCommand = new String[]{this.containerRuntime.getExecutableName(), "cp", this.outputPath + "/.", this.containerId + ":" + "/project"};
        this.runCommand(copyCommand, "Failed to copy source-jar and libs from host to builder container", null);
        super.preBuild(buildArgs);
    }

    @Override
    protected String[] getBuildCommand(List<String> args) {
        return new String[]{this.containerRuntime.getExecutableName(), "start", "--attach", this.containerId};
    }

    @Override
    protected void postBuild() throws InterruptedException, IOException {
        this.copyFromBuilder(this.resultingExecutableName, "Failed to copy native executable from container back to the host.");
        if (this.nativeConfig.debug.enabled) {
            this.copyFromBuilder("sources", "Failed to copy sources from container back to the host.");
        }
        String[] removeCommand = new String[]{this.containerRuntime.getExecutableName(), "container", "rm", "--volumes", this.containerId};
        this.runCommand(removeCommand, "Failed to remove container: " + this.containerId, null);
    }

    private void copyFromBuilder(String path, String errorMsg) throws IOException, InterruptedException {
        String[] copyCommand = new String[]{this.containerRuntime.getExecutableName(), "cp", this.containerId + ":" + "/project" + "/" + path, this.outputPath};
        this.runCommand(copyCommand, errorMsg, null);
    }
}

