/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.cache.Cache;
import io.quarkus.cache.CacheManager;
import io.quarkus.cache.runtime.caffeine.CaffeineCache;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class CaffeineCacheSupplier
implements Supplier<Collection<CaffeineCache>> {
    @Override
    public List<CaffeineCache> get() {
        CacheManager cacheManager = CaffeineCacheSupplier.cacheManager();
        Collection<String> names = cacheManager.getCacheNames();
        ArrayList<CaffeineCache> allCaches = new ArrayList<CaffeineCache>(names.size());
        for (String name : names) {
            Optional<Cache> cache = cacheManager.getCache(name);
            if (!cache.isPresent() || !(cache.get() instanceof CaffeineCache)) continue;
            allCaches.add((CaffeineCache)cache.get());
        }
        allCaches.sort(Comparator.comparing(CaffeineCache::getName));
        return allCaches;
    }

    public static CacheManager cacheManager() {
        return (CacheManager)Arc.container().instance(CacheManager.class, new Annotation[0]).get();
    }
}

