/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime.caffeine;

import io.quarkus.cache.Cache;
import io.quarkus.cache.CacheManager;
import io.quarkus.cache.runtime.CacheManagerImpl;
import io.quarkus.cache.runtime.caffeine.CaffeineCache;
import io.quarkus.cache.runtime.caffeine.CaffeineCacheInfo;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class CaffeineCacheBuildRecorder {
    private static final Logger LOGGER = Logger.getLogger(CaffeineCacheBuildRecorder.class);

    public Supplier<CacheManager> getCacheManagerSupplier(final Set<CaffeineCacheInfo> cacheInfos) {
        Objects.requireNonNull(cacheInfos);
        return new Supplier<CacheManager>(){

            @Override
            public CacheManager get() {
                if (cacheInfos.isEmpty()) {
                    return new CacheManagerImpl(Collections.emptyMap());
                }
                HashMap<String, Cache> caches = new HashMap<String, Cache>(cacheInfos.size() + 1, 1.0f);
                for (CaffeineCacheInfo cacheInfo : cacheInfos) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debugf("Building Caffeine cache [%s] with [initialCapacity=%s], [maximumSize=%s], [expireAfterWrite=%s] and [expireAfterAccess=%s]", new Object[]{cacheInfo.name, cacheInfo.initialCapacity, cacheInfo.maximumSize, cacheInfo.expireAfterWrite, cacheInfo.expireAfterAccess});
                    }
                    CaffeineCache cache = new CaffeineCache(cacheInfo);
                    caches.put(cacheInfo.name, cache);
                }
                return new CacheManagerImpl(caches);
            }
        };
    }
}

