/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap;

import io.quarkus.bootstrap.app.AdditionalDependency;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.resolver.model.QuarkusModel;
import io.quarkus.bootstrap.resolver.model.WorkspaceModule;
import io.quarkus.bootstrap.util.QuarkusModelHelper;
import io.quarkus.bootstrap.utils.BuildToolHelper;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;

public class IDELauncherImpl {
    public static void launch(Path projectRoot, Map<String, Object> context) {
        try (CuratedApplication app = null;){
            QuarkusBootstrap.Builder builder = QuarkusBootstrap.builder().setApplicationRoot(projectRoot).setBaseClassLoader(IDELauncherImpl.class.getClassLoader()).setProjectRoot(projectRoot).setIsolateDeployment(true).setMode(QuarkusBootstrap.Mode.DEV).setTargetDirectory(projectRoot.getParent());
            if (BuildToolHelper.isGradleProject(projectRoot)) {
                QuarkusModel quarkusModel = BuildToolHelper.enableGradleAppModelForDevMode(projectRoot);
                context.put("quarkus-internal.serialized-quarkus-model.path", QuarkusModelHelper.serializeQuarkusModel((QuarkusModel)quarkusModel));
                WorkspaceModule launchingModule = quarkusModel.getWorkspace().getMainModule();
                Path launchingModulePath = QuarkusModelHelper.getClassPath((WorkspaceModule)launchingModule);
                builder.setProjectRoot(launchingModulePath).setApplicationRoot(launchingModulePath).setTargetDirectory(launchingModule.getBuildDir().toPath());
                for (WorkspaceModule additionalModule : quarkusModel.getWorkspace().getAllModules()) {
                    if (additionalModule.getArtifactCoords().equals(launchingModule.getArtifactCoords())) continue;
                    builder.addAdditionalApplicationArchive(new AdditionalDependency(QuarkusModelHelper.toPathsCollection((Collection)additionalModule.getSourceSet().getSourceDirectories()), true, false));
                    builder.addAdditionalApplicationArchive(new AdditionalDependency(additionalModule.getSourceSet().getResourceDirectory().toPath(), true, false));
                }
            }
            app = builder.build().bootstrap();
            app.runInAugmentClassLoader("io.quarkus.deployment.dev.IDEDevModeMain", context);
        }
    }
}

