/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.ApplicationModelBuilder;
import io.quarkus.bootstrap.model.ExtensionCapabilities;
import io.quarkus.bootstrap.model.PlatformImports;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import io.quarkus.paths.PathList;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MutableJarApplicationModel
implements Serializable {
    private static final long serialVersionUID = 2046278141713688084L;
    private final String baseName;
    private final SerializedDep appArtifact;
    private List<SerializedDep> dependencies;
    private Set<ArtifactKey> parentFirstArtifacts;
    private Set<ArtifactKey> runnerParentFirstArtifacts;
    private Set<ArtifactKey> lesserPriorityArtifacts;
    private Set<ArtifactKey> localProjectArtifacts;
    private Map<ArtifactKey, Set<String>> excludedResources;
    private Collection<ExtensionCapabilities> capabilitiesContracts;
    private PlatformImports platformImports;
    private String userProvidersDirectory;

    public MutableJarApplicationModel(String baseName, Map<ArtifactKey, List<String>> paths, ApplicationModel appModel, String userProvidersDirectory, String appArchivePath) {
        this.baseName = baseName;
        this.userProvidersDirectory = userProvidersDirectory;
        this.appArtifact = new SerializedDep(appModel.getAppArtifact(), paths, 0);
        this.appArtifact.paths = Collections.singletonList(appArchivePath.replace('\\', '/'));
        this.dependencies = new ArrayList<SerializedDep>(appModel.getDependencies().size());
        for (ResolvedDependency i : appModel.getDependencies()) {
            this.dependencies.add(new SerializedDep(i, paths, i.getFlags()));
        }
        this.localProjectArtifacts = new HashSet<ArtifactKey>(appModel.getReloadableWorkspaceDependencies());
        this.parentFirstArtifacts = new HashSet<ArtifactKey>(appModel.getParentFirst());
        this.runnerParentFirstArtifacts = new HashSet<ArtifactKey>(appModel.getRunnerParentFirst());
        this.lesserPriorityArtifacts = new HashSet<ArtifactKey>(appModel.getLowerPriorityArtifacts());
        this.excludedResources = new HashMap<ArtifactKey, Set<String>>(appModel.getRemovedResources());
        this.capabilitiesContracts = new ArrayList<ExtensionCapabilities>(appModel.getExtensionCapabilities());
        this.platformImports = appModel.getPlatforms();
    }

    public String getUserProvidersDirectory() {
        return this.userProvidersDirectory;
    }

    public ApplicationModel getAppModel(Path root) {
        ApplicationModelBuilder model = new ApplicationModelBuilder();
        model.setAppArtifact(this.appArtifact.getDep(root));
        for (SerializedDep serializedDep : this.dependencies) {
            model.addDependency(serializedDep.getDep(root));
        }
        for (ArtifactKey artifactKey : this.parentFirstArtifacts) {
            model.addParentFirstArtifact(artifactKey);
        }
        for (ArtifactKey artifactKey : this.runnerParentFirstArtifacts) {
            model.addRunnerParentFirstArtifact(artifactKey);
        }
        for (ArtifactKey artifactKey : this.lesserPriorityArtifacts) {
            model.addLesserPriorityArtifact(artifactKey);
        }
        for (ArtifactKey artifactKey : this.localProjectArtifacts) {
            model.addReloadableWorkspaceModule(artifactKey);
        }
        for (Map.Entry entry : this.excludedResources.entrySet()) {
            model.addRemovedResources((ArtifactKey)entry.getKey(), (Set)entry.getValue());
        }
        for (ExtensionCapabilities extensionCapabilities : this.capabilitiesContracts) {
            model.addExtensionCapabilities(extensionCapabilities);
        }
        model.setPlatformImports(this.platformImports);
        return model.build();
    }

    public String getBaseName() {
        return this.baseName;
    }

    private static class SerializedDep
    extends GACTV {
        private List<String> paths;
        private final int flags;

        public SerializedDep(ResolvedDependency dependency, Map<ArtifactKey, List<String>> paths, int flags) {
            super(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType(), dependency.getVersion());
            List<String> pathList = paths.get(dependency.getKey());
            if (pathList == null) {
                pathList = Collections.emptyList();
            }
            this.paths = pathList.stream().map(s -> s.replace('\\', '/')).collect(Collectors.toList());
            this.flags = flags;
        }

        public ResolvedDependency getDep(Path root) {
            PathList.Builder builder = PathList.builder();
            for (String i : this.paths) {
                builder.add(root.resolve(i));
            }
            ResolvedDependency d = ((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setGroupId(this.getGroupId())).setArtifactId(this.getArtifactId())).setClassifier(this.getClassifier())).setVersion(this.getVersion())).setResolvedPaths(builder.build()).setFlags(this.flags)).build();
            return d;
        }
    }
}

