/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BeanConfiguratorBase;
import io.quarkus.arc.runtime.ArcRecorder;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.util.HashUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.enterprise.inject.CreationException;
import org.jboss.jandex.DotName;

public class SyntheticBeansProcessor {
    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void initStatic(ArcRecorder recorder, List<SyntheticBeanBuildItem> syntheticBeans, BeanRegistrationPhaseBuildItem beanRegistration, BuildProducer<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> configurators) {
        HashMap suppliersMap = new HashMap();
        for (SyntheticBeanBuildItem bean : syntheticBeans) {
            if (!bean.isStaticInit()) continue;
            this.initSyntheticBean(recorder, suppliersMap, beanRegistration, bean);
        }
        recorder.initStaticSupplierBeans(suppliersMap);
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Produce(value=SyntheticBeansRuntimeInitBuildItem.class)
    @BuildStep
    ServiceStartBuildItem initRuntime(ArcRecorder recorder, List<SyntheticBeanBuildItem> syntheticBeans, BeanRegistrationPhaseBuildItem beanRegistration, BuildProducer<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> configurators) {
        HashMap suppliersMap = new HashMap();
        for (SyntheticBeanBuildItem bean : syntheticBeans) {
            if (bean.isStaticInit()) continue;
            this.initSyntheticBean(recorder, suppliersMap, beanRegistration, bean);
        }
        recorder.initRuntimeSupplierBeans(suppliersMap);
        return new ServiceStartBuildItem("runtime-bean-init");
    }

    private void initSyntheticBean(ArcRecorder recorder, Map<String, Supplier<?>> suppliersMap, BeanRegistrationPhaseBuildItem beanRegistration, SyntheticBeanBuildItem bean) {
        DotName implClazz = bean.configurator().getImplClazz();
        String name = this.createName(implClazz.toString(), bean.configurator().getQualifiers().toString());
        if (bean.configurator().runtimeValue != null) {
            suppliersMap.put(name, recorder.createSupplier(bean.configurator().runtimeValue));
        } else {
            suppliersMap.put(name, bean.configurator().supplier);
        }
        ((BeanConfigurator)((BeanConfigurator)beanRegistration.getContext().configure(implClazz).read((BeanConfiguratorBase)bean.configurator())).creator(this.creator(name, bean))).done();
    }

    private String createName(String beanClass, String qualifiers) {
        return beanClass.replace(".", "_") + "_" + HashUtil.sha1((String)qualifiers);
    }

    private Consumer<MethodCreator> creator(final String name, final SyntheticBeanBuildItem bean) {
        return new Consumer<MethodCreator>(){

            @Override
            public void accept(MethodCreator m) {
                ResultHandle staticMap = m.readStaticField(FieldDescriptor.of(ArcRecorder.class, (String)"supplierMap", Map.class));
                ResultHandle supplier = m.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"get", Object.class, (Class[])new Class[]{Object.class}), staticMap, new ResultHandle[]{m.load(name)});
                m.ifNull(supplier).trueBranch().throwException(CreationException.class, SyntheticBeansProcessor.this.createMessage(name, bean));
                ResultHandle result = m.invokeInterfaceMethod(MethodDescriptor.ofMethod(Supplier.class, (String)"get", Object.class, (Class[])new Class[0]), supplier, new ResultHandle[0]);
                m.returnValue(result);
            }
        };
    }

    private String createMessage(String name, SyntheticBeanBuildItem bean) {
        StringBuilder builder = new StringBuilder();
        builder.append("Synthetic bean instance for ");
        builder.append(bean.configurator().getImplClazz());
        builder.append(" not initialized yet: ");
        builder.append(name);
        if (!bean.isStaticInit()) {
            builder.append("\n\t- a synthetic bean initialized during RUNTIME_INIT must not be accessed during STATIC_INIT");
            builder.append("\n\t- RUNTIME_INIT build steps that require access to synthetic beans initialized during RUNTIME_INIT should consume the SyntheticBeansRuntimeInitBuildItem");
        }
        return builder.toString();
    }
}

