/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.vertx;

import io.undertow.httpcore.BufferAllocator;
import io.undertow.httpcore.ExchangeHandler;
import io.undertow.httpcore.HttpExchange;
import io.undertow.httpcore.UndertowEngine;
import io.undertow.vertx.VertxHttpExchange;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.JksOptions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class VertxUndertowEngine
implements UndertowEngine {
    public UndertowEngine.EngineInstance start(int ioThreads, Executor blockingExecutor, BufferAllocator bufferAllocator) {
        Vertx vertx = Vertx.vertx();
        return new VertxEngineInstance(vertx, blockingExecutor, ioThreads, bufferAllocator);
    }

    public void bindHttp(UndertowEngine.EngineInstance instance, final ExchangeHandler handler, final int port, final String host, final Object options) {
        final VertxEngineInstance ei = (VertxEngineInstance)instance;
        final CompletableFuture deploymentId = new CompletableFuture();
        ei.vertx.deployVerticle((Supplier)new Supplier<Verticle>(){

            @Override
            public Verticle get() {
                HttpServerOptions opts = (HttpServerOptions)options;
                if (opts == null) {
                    opts = new HttpServerOptions();
                }
                return new MyVerticle(ei.allocator, port, host, ei.vertx, ei.executor, handler, opts);
            }
        }, new DeploymentOptions().setInstances(ei.ioThreads), (Handler)new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> event) {
                if (event.failed()) {
                    deploymentId.completeExceptionally(event.cause());
                } else {
                    deploymentId.complete(event.result());
                }
            }
        });
        try {
            deploymentId.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void bindHttps(UndertowEngine.EngineInstance instance, ExchangeHandler handler, int port, String host, String keyStore, String keyStorePassword, String trustStore, String trustStorePassword, Object options) {
        HttpServerOptions opts = (HttpServerOptions)options;
        if (opts == null) {
            opts = new HttpServerOptions();
        }
        opts.setSsl(true);
        opts.setKeyStoreOptions(new JksOptions().setPath(keyStore).setPassword(keyStorePassword));
        if (trustStore != null) {
            opts.setTrustStoreOptions(new JksOptions().setPath(trustStore).setPassword(trustStorePassword));
        }
        this.bindHttp(instance, handler, port, host, opts);
    }

    private static class MyVerticle
    implements Verticle {
        private final BufferAllocator allocator;
        private final int port;
        private final String host;
        private HttpServer server;
        private final Vertx vertx;
        private final Executor blockingExecutor;
        private final ExchangeHandler rootHandler;
        private final HttpServerOptions options;

        public MyVerticle(BufferAllocator allocator, int port, String host, Vertx vertx, Executor blockingExecutor, ExchangeHandler rootHandler, HttpServerOptions options) {
            this.allocator = allocator;
            this.port = port;
            this.host = host;
            this.vertx = vertx;
            this.blockingExecutor = blockingExecutor;
            this.rootHandler = rootHandler;
            this.options = options;
        }

        public Vertx getVertx() {
            return this.vertx;
        }

        public void init(Vertx vertx, Context context) {
        }

        public void start(final Future<Void> startFuture) throws Exception {
            this.server = this.vertx.createHttpServer(this.options);
            this.server.requestHandler(request -> {
                VertxHttpExchange delegate = new VertxHttpExchange((HttpServerRequest)request, this.allocator, this.blockingExecutor, null);
                this.rootHandler.handle((HttpExchange)delegate);
            });
            this.server.listen(this.port, this.host, (Handler)new Handler<AsyncResult<HttpServer>>(){

                public void handle(AsyncResult<HttpServer> event) {
                    if (event.failed()) {
                        startFuture.fail(event.cause());
                    } else {
                        startFuture.complete();
                    }
                }
            });
        }

        public void stop(final Future<Void> stopFuture) throws Exception {
            this.server.close((Handler)new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> event) {
                    if (event.failed()) {
                        stopFuture.fail(event.cause());
                    } else {
                        stopFuture.complete();
                    }
                }
            });
        }
    }

    static class VertxEngineInstance
    implements UndertowEngine.EngineInstance {
        final Vertx vertx;
        final Executor executor;
        final int ioThreads;
        final BufferAllocator allocator;

        VertxEngineInstance(Vertx vertx, Executor executor, int ioThreads, BufferAllocator allocator) {
            this.vertx = vertx;
            this.executor = executor;
            this.ioThreads = ioThreads;
            this.allocator = allocator;
        }

        public void close() {
            final CountDownLatch latch = new CountDownLatch(1);
            this.vertx.close((Handler)new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> event) {
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

