/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl.constant;

import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.Util;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import io.smallrye.classfile.CodeBuilder;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.util.Optional;

public final class ClassConst
extends ConstImpl {
    private final ClassDesc value;

    public ClassConst(ClassDesc value) {
        super(ConstantDescs.CD_Class);
        this.value = value;
    }

    @Override
    public boolean isNonZero() {
        return true;
    }

    public ClassConst(ConstantDesc constantDesc) {
        this((ClassDesc)constantDesc);
    }

    @Override
    public ClassDesc desc() {
        return this.value;
    }

    public Optional<ClassDesc> describeConstable() {
        return Optional.of(this.desc());
    }

    @Override
    public boolean equals(ConstImpl obj) {
        ClassConst other;
        return obj instanceof ClassConst && this.equals(other = (ClassConst)obj);
    }

    public boolean equals(ClassConst other) {
        return this == other || other != null && this.value.equals(other.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public StringBuilder toShortString(StringBuilder b) {
        return Util.descName(b.append("Class["), this.value).append(']');
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        if (this.value.isPrimitive()) {
            ClassDesc wrapper = switch (this.value.descriptorString()) {
                case "B" -> ConstantDescs.CD_Byte;
                case "S" -> ConstantDescs.CD_Short;
                case "C" -> ConstantDescs.CD_Character;
                case "I" -> ConstantDescs.CD_Integer;
                case "J" -> ConstantDescs.CD_Long;
                case "F" -> ConstantDescs.CD_Float;
                case "D" -> ConstantDescs.CD_Double;
                case "Z" -> ConstantDescs.CD_Boolean;
                case "V" -> ConstantDescs.CD_Void;
                default -> throw Assert.impossibleSwitchCase((Object)this.value);
            };
            cb.getstatic(wrapper, "TYPE", ConstantDescs.CD_Class);
            smb.push(this.type());
            smb.wroteCode();
        } else {
            super.writeCode(cb, block, smb);
        }
    }
}

