/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.creator.AnnotationCreator;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.classfile.Annotation;
import io.smallrye.classfile.AnnotationElement;
import io.smallrye.classfile.AnnotationValue;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ClassDesc;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public final class AnnotationCreatorImpl<A extends java.lang.annotation.Annotation>
implements AnnotationCreator<A> {
    private final Class<A> annotationClass;
    private final List<AnnotationElement> elements = new ArrayList<AnnotationElement>();

    static <A extends java.lang.annotation.Annotation> Annotation makeAnnotation(Class<A> type, Consumer<AnnotationCreator<A>> builder) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"builder", builder);
        AnnotationCreatorImpl<A> creator = new AnnotationCreatorImpl<A>(type);
        builder.accept(creator);
        return Annotation.of((ClassDesc)Util.classDesc(type), creator.elements);
    }

    static Annotation makeAnnotation(ClassDesc type, Consumer<AnnotationCreator<java.lang.annotation.Annotation>> builder) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"builder", builder);
        AnnotationCreatorImpl creator = new AnnotationCreatorImpl(null);
        builder.accept(creator);
        return Annotation.of((ClassDesc)type, creator.elements);
    }

    AnnotationCreatorImpl(Class<A> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public void add(AnnotationElement element) {
        Assert.checkNotNullParam((String)"element", (Object)element);
        this.elements.add(element);
    }

    @Override
    public void add(String name, AnnotationValue value) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"value", (Object)value);
        this.add(AnnotationElement.of((String)name, (AnnotationValue)value));
    }

    private void add(SerializedLambda sl, AnnotationValue value) {
        assert (this.annotationClass != null);
        if (!sl.getImplClass().equals(this.annotationClass.getName().replace('.', '/')) || sl.getImplMethodKind() != 9) {
            throw new IllegalArgumentException("Invalid property name");
        }
        this.add(sl.getImplMethodName(), value);
    }

    @Override
    public void add(String name, boolean value) {
        this.add(name, (AnnotationValue)AnnotationValue.ofBoolean((boolean)value));
    }

    @Override
    public void add(AnnotationCreator.BooleanProperty<A> prop, boolean value) {
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofBoolean((boolean)value));
    }

    @Override
    public void add(String name, byte value) {
        this.add(name, (AnnotationValue)AnnotationValue.ofByte((byte)value));
    }

    @Override
    public void add(AnnotationCreator.ByteProperty<A> prop, byte value) {
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofByte((byte)value));
    }

    @Override
    public void add(String name, short value) {
        this.add(name, (AnnotationValue)AnnotationValue.ofShort((short)value));
    }

    @Override
    public void add(AnnotationCreator.ShortProperty<A> prop, short value) {
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofShort((short)value));
    }

    @Override
    public void add(String name, int value) {
        this.add(name, (AnnotationValue)AnnotationValue.ofInt((int)value));
    }

    @Override
    public void add(AnnotationCreator.IntProperty<A> prop, int value) {
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofInt((int)value));
    }

    @Override
    public void add(String name, long value) {
        this.add(name, (AnnotationValue)AnnotationValue.ofLong((long)value));
    }

    @Override
    public void add(AnnotationCreator.LongProperty<A> prop, long value) {
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofLong((long)value));
    }

    @Override
    public void add(String name, float value) {
        this.add(name, (AnnotationValue)AnnotationValue.ofFloat((float)value));
    }

    @Override
    public void add(AnnotationCreator.FloatProperty<A> prop, float value) {
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofFloat((float)value));
    }

    @Override
    public void add(String name, double value) {
        this.add(name, (AnnotationValue)AnnotationValue.ofDouble((double)value));
    }

    @Override
    public void add(AnnotationCreator.DoubleProperty<A> prop, double value) {
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofDouble((double)value));
    }

    @Override
    public void add(String name, char value) {
        this.add(name, (AnnotationValue)AnnotationValue.ofChar((char)value));
    }

    @Override
    public void add(AnnotationCreator.CharProperty<A> prop, char value) {
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofChar((char)value));
    }

    @Override
    public void add(String name, String value) {
        this.add(name, (AnnotationValue)AnnotationValue.ofString((String)value));
    }

    @Override
    public void add(AnnotationCreator.StringProperty<A> prop, String value) {
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofString((String)value));
    }

    @Override
    public void add(String name, Class<?> value) {
        this.add(name, (AnnotationValue)AnnotationValue.ofClass((ClassDesc)Util.classDesc(value)));
    }

    @Override
    public void add(AnnotationCreator.ClassProperty<A> prop, Class<?> value) {
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofClass((ClassDesc)Util.classDesc(value)));
    }

    @Override
    public void add(String name, ClassDesc value) {
        this.add(name, (AnnotationValue)AnnotationValue.ofClass((ClassDesc)value));
    }

    @Override
    public void add(AnnotationCreator.ClassProperty<A> prop, ClassDesc value) {
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofClass((ClassDesc)value));
    }

    @Override
    public <E extends Enum<E>> void add(String name, E value) {
        this.add(name, (AnnotationValue)AnnotationValue.ofEnum((ClassDesc)Util.classDesc(value.getDeclaringClass()), (String)value.name()));
    }

    @Override
    public <E extends Enum<E>> void add(AnnotationCreator.EnumProperty<A, E> prop, E value) {
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofEnum((ClassDesc)Util.classDesc(value.getDeclaringClass()), (String)value.name()));
    }

    @Override
    public void add(String name, ClassDesc enumClass, String enumConstant) {
        this.add(name, (AnnotationValue)AnnotationValue.ofEnum((ClassDesc)enumClass, (String)enumConstant));
    }

    @Override
    public <S extends java.lang.annotation.Annotation> void add(String name, Class<S> annotationClass, Consumer<AnnotationCreator<S>> builder) {
        this.add(name, (AnnotationValue)AnnotationValue.ofAnnotation((Annotation)AnnotationCreatorImpl.makeAnnotation(annotationClass, builder)));
    }

    @Override
    public <S extends java.lang.annotation.Annotation> void add(AnnotationCreator.AnnotationProperty<A, S> prop, Consumer<AnnotationCreator<S>> builder) {
        assert (this.annotationClass != null);
        try {
            SerializedLambda serializedLambda = Util.serializedLambda(prop);
            String annotationElement = serializedLambda.getImplMethodName();
            Class<?> clazz = this.annotationClass.getDeclaredMethod(annotationElement, new Class[0]).getReturnType();
            this.add(serializedLambda, (AnnotationValue)AnnotationValue.ofAnnotation((Annotation)AnnotationCreatorImpl.makeAnnotation(clazz, builder)));
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }

    @Override
    public void add(String name, ClassDesc annotationClass, Consumer<AnnotationCreator<java.lang.annotation.Annotation>> builder) {
        this.add(name, (AnnotationValue)AnnotationValue.ofAnnotation((Annotation)AnnotationCreatorImpl.makeAnnotation(annotationClass, builder)));
    }

    @Override
    public void addArray(String name, boolean ... values) {
        ArrayList<AnnotationValue.OfBoolean> array = new ArrayList<AnnotationValue.OfBoolean>(values.length);
        for (boolean value : values) {
            array.add(AnnotationValue.ofBoolean((boolean)value));
        }
        this.add(name, (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(AnnotationCreator.BooleanArrayProperty<A> prop, boolean ... values) {
        ArrayList<AnnotationValue.OfBoolean> array = new ArrayList<AnnotationValue.OfBoolean>(values.length);
        for (boolean value : values) {
            array.add(AnnotationValue.ofBoolean((boolean)value));
        }
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(String name, byte ... values) {
        ArrayList<AnnotationValue.OfByte> array = new ArrayList<AnnotationValue.OfByte>(values.length);
        for (byte value : values) {
            array.add(AnnotationValue.ofByte((byte)value));
        }
        this.add(name, (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(AnnotationCreator.ByteArrayProperty<A> prop, byte ... values) {
        ArrayList<AnnotationValue.OfByte> array = new ArrayList<AnnotationValue.OfByte>(values.length);
        for (byte value : values) {
            array.add(AnnotationValue.ofByte((byte)value));
        }
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(String name, short ... values) {
        ArrayList<AnnotationValue.OfShort> array = new ArrayList<AnnotationValue.OfShort>(values.length);
        for (short value : values) {
            array.add(AnnotationValue.ofShort((short)value));
        }
        this.add(name, (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(AnnotationCreator.ShortArrayProperty<A> prop, short ... values) {
        ArrayList<AnnotationValue.OfShort> array = new ArrayList<AnnotationValue.OfShort>(values.length);
        for (short value : values) {
            array.add(AnnotationValue.ofShort((short)value));
        }
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(String name, int ... values) {
        ArrayList<AnnotationValue.OfInt> array = new ArrayList<AnnotationValue.OfInt>(values.length);
        for (int value : values) {
            array.add(AnnotationValue.ofInt((int)value));
        }
        this.add(name, (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(AnnotationCreator.IntArrayProperty<A> prop, int ... values) {
        ArrayList<AnnotationValue.OfInt> array = new ArrayList<AnnotationValue.OfInt>(values.length);
        for (int value : values) {
            array.add(AnnotationValue.ofInt((int)value));
        }
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(String name, long ... values) {
        ArrayList<AnnotationValue.OfLong> array = new ArrayList<AnnotationValue.OfLong>(values.length);
        for (long value : values) {
            array.add(AnnotationValue.ofLong((long)value));
        }
        this.add(name, (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(AnnotationCreator.LongArrayProperty<A> prop, long ... values) {
        ArrayList<AnnotationValue.OfLong> array = new ArrayList<AnnotationValue.OfLong>(values.length);
        for (long value : values) {
            array.add(AnnotationValue.ofLong((long)value));
        }
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(String name, float ... values) {
        ArrayList<AnnotationValue.OfFloat> array = new ArrayList<AnnotationValue.OfFloat>(values.length);
        for (float value : values) {
            array.add(AnnotationValue.ofFloat((float)value));
        }
        this.add(name, (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(AnnotationCreator.FloatArrayProperty<A> prop, float ... values) {
        ArrayList<AnnotationValue.OfFloat> array = new ArrayList<AnnotationValue.OfFloat>(values.length);
        for (float value : values) {
            array.add(AnnotationValue.ofFloat((float)value));
        }
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(String name, double ... values) {
        ArrayList<AnnotationValue.OfDouble> array = new ArrayList<AnnotationValue.OfDouble>(values.length);
        for (double value : values) {
            array.add(AnnotationValue.ofDouble((double)value));
        }
        this.add(name, (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(AnnotationCreator.DoubleArrayProperty<A> prop, double ... values) {
        ArrayList<AnnotationValue.OfDouble> array = new ArrayList<AnnotationValue.OfDouble>(values.length);
        for (double value : values) {
            array.add(AnnotationValue.ofDouble((double)value));
        }
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(String name, char ... values) {
        ArrayList<AnnotationValue.OfDouble> array = new ArrayList<AnnotationValue.OfDouble>(values.length);
        for (char value : values) {
            array.add(AnnotationValue.ofDouble((double)value));
        }
        this.add(name, (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(AnnotationCreator.CharArrayProperty<A> prop, char ... values) {
        ArrayList<AnnotationValue.OfChar> array = new ArrayList<AnnotationValue.OfChar>(values.length);
        for (char value : values) {
            array.add(AnnotationValue.ofChar((char)value));
        }
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(String name, String ... values) {
        ArrayList<AnnotationValue.OfString> array = new ArrayList<AnnotationValue.OfString>(values.length);
        for (String value : values) {
            array.add(AnnotationValue.ofString((String)value));
        }
        this.add(name, (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(AnnotationCreator.StringArrayProperty<A> prop, String ... values) {
        ArrayList<AnnotationValue.OfString> array = new ArrayList<AnnotationValue.OfString>(values.length);
        for (String value : values) {
            array.add(AnnotationValue.ofString((String)value));
        }
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(String name, Class<?> ... values) {
        ArrayList<AnnotationValue.OfClass> array = new ArrayList<AnnotationValue.OfClass>(values.length);
        for (Class<?> value : values) {
            array.add(AnnotationValue.ofClass((ClassDesc)Util.classDesc(value)));
        }
        this.add(name, (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(AnnotationCreator.ClassArrayProperty<A> prop, Class<?> ... values) {
        ArrayList<AnnotationValue.OfClass> array = new ArrayList<AnnotationValue.OfClass>(values.length);
        for (Class<?> value : values) {
            array.add(AnnotationValue.ofClass((ClassDesc)Util.classDesc(value)));
        }
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(String name, ClassDesc ... values) {
        ArrayList<AnnotationValue.OfClass> array = new ArrayList<AnnotationValue.OfClass>(values.length);
        for (ClassDesc value : values) {
            array.add(AnnotationValue.ofClass((ClassDesc)value));
        }
        this.add(name, (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(AnnotationCreator.ClassArrayProperty<A> prop, ClassDesc ... values) {
        ArrayList<AnnotationValue.OfClass> array = new ArrayList<AnnotationValue.OfClass>(values.length);
        for (ClassDesc value : values) {
            array.add(AnnotationValue.ofClass((ClassDesc)value));
        }
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public <E extends Enum<E>> void addArray(String name, List<E> values) {
        ArrayList<AnnotationValue.OfEnum> array = new ArrayList<AnnotationValue.OfEnum>(values.size());
        for (Enum value : values) {
            array.add(AnnotationValue.ofEnum((ClassDesc)Util.classDesc(value.getDeclaringClass()), (String)value.name()));
        }
        this.add(name, (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public <E extends Enum<E>> void addArray(AnnotationCreator.EnumArrayProperty<A, E> prop, List<E> values) {
        ArrayList<AnnotationValue.OfEnum> array = new ArrayList<AnnotationValue.OfEnum>(values.size());
        for (Enum value : values) {
            array.add(AnnotationValue.ofEnum((ClassDesc)Util.classDesc(value.getDeclaringClass()), (String)value.name()));
        }
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public void addArray(String name, ClassDesc enumClass, String ... enumConstants) {
        ArrayList<AnnotationValue.OfEnum> array = new ArrayList<AnnotationValue.OfEnum>(enumConstants.length);
        for (String enumConstant : enumConstants) {
            array.add(AnnotationValue.ofEnum((ClassDesc)enumClass, (String)enumConstant));
        }
        this.add(name, (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public <E extends Enum<E>> void addArray(AnnotationCreator.EnumArrayProperty<A, E> prop, ClassDesc enumClass, String ... enumConstants) {
        ArrayList<AnnotationValue.OfEnum> array = new ArrayList<AnnotationValue.OfEnum>(enumConstants.length);
        for (String enumConstant : enumConstants) {
            array.add(AnnotationValue.ofEnum((ClassDesc)enumClass, (String)enumConstant));
        }
        this.add(Util.serializedLambda(prop), (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public <S extends java.lang.annotation.Annotation> void addArray(String name, Class<S> annotationClass, List<Consumer<AnnotationCreator<S>>> builders) {
        ArrayList<AnnotationValue.OfAnnotation> array = new ArrayList<AnnotationValue.OfAnnotation>(builders.size());
        for (Consumer<AnnotationCreator<A>> consumer : builders) {
            array.add(AnnotationValue.ofAnnotation((Annotation)AnnotationCreatorImpl.makeAnnotation(annotationClass, consumer)));
        }
        this.add(name, (AnnotationValue)AnnotationValue.ofArray(array));
    }

    @Override
    public <S extends java.lang.annotation.Annotation> void addArray(AnnotationCreator.AnnotationArrayProperty<A, S> prop, List<Consumer<AnnotationCreator<S>>> builders) {
        assert (this.annotationClass != null);
        try {
            SerializedLambda serializedLambda = Util.serializedLambda(prop);
            String annotationElement = serializedLambda.getImplMethodName();
            Class<?> clazz = this.annotationClass.getDeclaredMethod(annotationElement, new Class[0]).getReturnType().getComponentType();
            ArrayList<AnnotationValue.OfAnnotation> array = new ArrayList<AnnotationValue.OfAnnotation>(builders.size());
            for (Consumer<AnnotationCreator<A>> consumer : builders) {
                array.add(AnnotationValue.ofAnnotation((Annotation)AnnotationCreatorImpl.makeAnnotation(clazz, consumer)));
            }
            this.add(serializedLambda, (AnnotationValue)AnnotationValue.ofArray(array));
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }

    @Override
    public void addArray(String name, ClassDesc annotationClass, List<Consumer<AnnotationCreator<java.lang.annotation.Annotation>>> builders) {
        ArrayList<AnnotationValue.OfAnnotation> array = new ArrayList<AnnotationValue.OfAnnotation>(builders.size());
        for (Consumer<AnnotationCreator<java.lang.annotation.Annotation>> builder : builders) {
            array.add(AnnotationValue.ofAnnotation((Annotation)AnnotationCreatorImpl.makeAnnotation(annotationClass, builder)));
        }
        this.add(name, (AnnotationValue)AnnotationValue.ofArray(array));
    }
}

