/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.http;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import javax.annotation.Nullable;

public final class HttpClientUrlTemplate {
    public static Scope with(Context context, String urlTemplate) {
        return context.with((ImplicitContextKeyed)new UrlTemplateState(urlTemplate)).makeCurrent();
    }

    @Nullable
    public static String get(Context context) {
        UrlTemplateState state = UrlTemplateState.fromContextOrNull(context);
        return state != null ? state.urlTemplate : null;
    }

    private HttpClientUrlTemplate() {
    }

    private static class UrlTemplateState
    implements ImplicitContextKeyed {
        private static final ContextKey<UrlTemplateState> KEY = ContextKey.named((String)"opentelemetry-http-client-url-template-key");
        private final String urlTemplate;

        @Nullable
        static UrlTemplateState fromContextOrNull(Context context) {
            return (UrlTemplateState)context.get(KEY);
        }

        UrlTemplateState(String urlTemplate) {
            this.urlTemplate = urlTemplate;
        }

        public Context storeInContext(Context context) {
            return context.with(KEY, (Object)this);
        }
    }
}

