/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.io.mzml.util;

import io.github.msdk.MSDKRuntimeException;
import java.util.ArrayDeque;
import javolution.text.CharArray;

public class TagTracker {
    private ArrayDeque<CharArray> stack;
    private ArrayDeque<CharArray> pool;
    protected static final int DEFAULT_CHAR_ARR_SIZE = 64;
    private int maxDepth;
    protected static final int DEFAULT_MAX_DEPTH = 128;

    public TagTracker(int maxDepth) {
        this.maxDepth = maxDepth;
        this.stack = new ArrayDeque();
        this.pool = new ArrayDeque();
    }

    public TagTracker() {
        this(128);
    }

    public void enter(CharArray tag) {
        CharArray arr = this.borrowArr(tag.length());
        this.copyContent(tag, arr);
        this.stack.push(arr);
        if (this.stack.size() > this.maxDepth) {
            throw new IllegalStateException("Max stack depth [" + this.maxDepth + "] exceeded");
        }
    }

    public void exit(CharArray tag) {
        CharArray top = this.stack.peek();
        if (top == null) {
            throw new MSDKRuntimeException("Stack exit called when the stack was empty.");
        }
        if (!top.equals(tag)) {
            throw new MSDKRuntimeException("Cannot exit tag '" + tag + "'. Last tag entered was '" + top + "'");
        }
        this.returnArr(this.stack.pop());
    }

    public boolean inside(CharSequence tag) {
        if (tag == null) {
            return false;
        }
        for (CharArray aStack : this.stack) {
            if (!aStack.contentEquals(tag)) continue;
            return true;
        }
        return false;
    }

    public CharArray current() {
        CharArray top = this.stack.peek();
        if (top == null) {
            return new CharArray("");
        }
        return top;
    }

    private CharArray createArr(int capacity) {
        return new CharArray(capacity);
    }

    private CharArray borrowArr(int capacity) {
        if (this.pool.isEmpty()) {
            return this.createArr(capacity);
        }
        CharArray c = this.pool.pop();
        if (c.array().length < capacity) {
            c.setArray(new char[capacity], 0, 0);
        }
        return c;
    }

    private void copyContent(CharArray c1, CharArray c2) {
        char[] a1 = c1.array();
        char[] a2 = c2.array().length >= c1.length() ? c2.array() : new char[c1.length()];
        for (int i = 0; i < c1.length(); ++i) {
            a2[i] = a1[c1.offset() + i];
        }
        c2.setArray(a2, 0, c1.length());
    }

    private void returnArr(CharArray arr) {
        this.pool.push(arr);
    }
}

