/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.io.mzml.data;

import com.google.common.collect.ImmutableList;
import io.github.msdk.datamodel.Chromatogram;
import io.github.msdk.datamodel.FileType;
import io.github.msdk.datamodel.MsScan;
import io.github.msdk.datamodel.RawDataFile;
import java.io.File;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public class MzMLRawDataFile
implements RawDataFile {
    @Nonnull
    private static final FileType fileType = FileType.MZML;
    private final File sourceFile;
    @Nonnull
    private final List<String> msFunctions;
    @Nonnull
    private final List<MsScan> msScans;
    @Nonnull
    private final List<Chromatogram> chromatograms;
    @Nonnull
    private String name;

    public MzMLRawDataFile(File sourceFile, List<String> msFunctions, List<MsScan> msScans, List<Chromatogram> chromatograms) {
        this.sourceFile = sourceFile;
        this.name = sourceFile != null ? sourceFile.getName() : null;
        this.msFunctions = msFunctions;
        this.msScans = msScans;
        this.chromatograms = chromatograms;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public Optional<File> getOriginalFile() {
        return Optional.ofNullable(this.sourceFile);
    }

    @Nonnull
    public FileType getRawDataFileType() {
        return fileType;
    }

    @Nonnull
    public List<String> getMsFunctions() {
        return ImmutableList.copyOf(this.msFunctions);
    }

    @Nonnull
    public List<MsScan> getScans() {
        return ImmutableList.copyOf(this.msScans);
    }

    @Nonnull
    public List<Chromatogram> getChromatograms() {
        return ImmutableList.copyOf(this.chromatograms);
    }

    public void dispose() {
    }
}

