/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.io.mzml.data;

import io.github.msdk.MSDKException;
import io.github.msdk.io.mzml.data.MzMLCompressionType;
import io.github.msdk.io.mzml.util.MSNumpress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Base64;
import java.util.zip.Deflater;

public abstract class MzMLPeaksEncoder {
    public static byte[] encodeDouble(double[] data, MzMLCompressionType compression) throws MSDKException {
        byte[] encodedData = null;
        switch (compression) {
            case NUMPRESS_LINPRED: 
            case NUMPRESS_LINPRED_ZLIB: {
                encodedData = new byte[8 + data.length * 5];
                int encodedBytes = MSNumpress.encodeLinear(data, data.length, encodedData, MSNumpress.optimalLinearFixedPoint(data, data.length));
                if (encodedBytes < 0) {
                    throw new MSDKException("MSNumpress linear encoding failed");
                }
                encodedData = Arrays.copyOf(encodedData, encodedBytes);
                break;
            }
            case NUMPRESS_POSINT: 
            case NUMPRESS_POSINT_ZLIB: {
                encodedData = new byte[data.length * 5];
                int encodedBytes = MSNumpress.encodePic(data, data.length, encodedData);
                if (encodedBytes < 0) {
                    throw new MSDKException("MSNumpress positive integer encoding failed");
                }
                encodedData = Arrays.copyOf(encodedData, encodedBytes);
                break;
            }
            case NUMPRESS_SHLOGF: 
            case NUMPRESS_SHLOGF_ZLIB: {
                encodedData = new byte[8 + data.length * 2];
                int encodedBytes = MSNumpress.encodeSlof(data, data.length, encodedData, MSNumpress.optimalSlofFixedPoint(data, data.length));
                if (encodedBytes < 0) {
                    throw new MSDKException("MSNumpress short floating logarithm encoding failed");
                }
                encodedData = Arrays.copyOf(encodedData, encodedBytes);
                break;
            }
            default: {
                ByteBuffer buffer = ByteBuffer.allocate(data.length * 8);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                for (double d : data) {
                    buffer.putDouble(d);
                }
                encodedData = buffer.array();
            }
        }
        switch (compression) {
            case NUMPRESS_LINPRED_ZLIB: 
            case NUMPRESS_POSINT_ZLIB: 
            case NUMPRESS_SHLOGF_ZLIB: 
            case ZLIB: {
                byte[] tmp = MzMLPeaksEncoder.ZlibCompress(encodedData);
                return Base64.getEncoder().encode(tmp);
            }
        }
        return Base64.getEncoder().encode(encodedData);
    }

    public static byte[] encodeFloat(float[] data, MzMLCompressionType compression) throws MSDKException {
        byte[] encodedData = null;
        switch (compression) {
            case NUMPRESS_LINPRED: 
            case NUMPRESS_LINPRED_ZLIB: 
            case NUMPRESS_POSINT: 
            case NUMPRESS_POSINT_ZLIB: 
            case NUMPRESS_SHLOGF: 
            case NUMPRESS_SHLOGF_ZLIB: {
                throw new MSDKException("MSNumpress compression not supported for float values");
            }
        }
        ByteBuffer buffer = ByteBuffer.allocate(data.length * 8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (float f : data) {
            buffer.putFloat(f);
        }
        encodedData = buffer.array();
        switch (compression) {
            case ZLIB: {
                byte[] tmp = MzMLPeaksEncoder.ZlibCompress(encodedData);
                return Base64.getEncoder().encode(tmp);
            }
        }
        return Base64.getEncoder().encode(encodedData);
    }

    private static byte[] ZlibCompress(byte[] uncompressedData) {
        byte[] data = null;
        byte[] temp = new byte[uncompressedData.length / 2];
        int compressedBytes = temp.length;
        while (compressedBytes == temp.length) {
            temp = new byte[temp.length * 2];
            Deflater compresser = new Deflater();
            compresser.setInput(uncompressedData);
            compresser.finish();
            compressedBytes = compresser.deflate(temp);
        }
        data = new byte[compressedBytes];
        System.arraycopy(temp, 0, data, 0, compressedBytes);
        return data;
    }
}

