/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.io.mzml.data;

import com.google.common.collect.Range;
import io.github.msdk.MSDKRuntimeException;
import io.github.msdk.datamodel.ActivationInfo;
import io.github.msdk.datamodel.ActivationType;
import io.github.msdk.datamodel.Chromatogram;
import io.github.msdk.datamodel.ChromatogramType;
import io.github.msdk.datamodel.IonAnnotation;
import io.github.msdk.datamodel.IsolationInfo;
import io.github.msdk.datamodel.RawDataFile;
import io.github.msdk.datamodel.SeparationType;
import io.github.msdk.datamodel.SimpleActivationInfo;
import io.github.msdk.datamodel.SimpleIsolationInfo;
import io.github.msdk.io.mzml.MzMLFileImportMethod;
import io.github.msdk.io.mzml.data.MzMLBinaryDataInfo;
import io.github.msdk.io.mzml.data.MzMLCVGroup;
import io.github.msdk.io.mzml.data.MzMLCVParam;
import io.github.msdk.io.mzml.data.MzMLIsolationWindow;
import io.github.msdk.io.mzml.data.MzMLPeaksDecoder;
import io.github.msdk.io.mzml.data.MzMLPrecursorElement;
import io.github.msdk.io.mzml.data.MzMLProduct;
import io.github.msdk.io.mzml.data.MzMLRawDataFile;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MzMLChromatogram
implements Chromatogram {
    @Nonnull
    private final MzMLRawDataFile dataFile;
    @Nonnull
    private InputStream inputStream;
    @Nonnull
    private final String chromatogramId;
    @Nonnull
    private final Integer chromatogramNumber;
    @Nonnull
    private final Integer numOfDataPoints;
    private MzMLCVGroup cvParams;
    private MzMLPrecursorElement precursor;
    private MzMLProduct product;
    private MzMLBinaryDataInfo rtBinaryDataInfo;
    private MzMLBinaryDataInfo intensityBinaryDataInfo;
    private ChromatogramType chromatogramType;
    private Double mz;
    private SeparationType separationType;
    private Range<Float> rtRange;
    private float[] rtValues;
    private float[] intensityValues;
    private Logger logger = LoggerFactory.getLogger(MzMLFileImportMethod.class);

    MzMLChromatogram(@Nonnull MzMLRawDataFile dataFile, InputStream is, String chromatogramId, Integer chromatogramNumber, Integer numOfDataPoints) {
        this.cvParams = new MzMLCVGroup();
        this.dataFile = dataFile;
        this.inputStream = is;
        this.chromatogramId = chromatogramId;
        this.chromatogramNumber = chromatogramNumber;
        this.numOfDataPoints = numOfDataPoints;
        this.separationType = SeparationType.UNKNOWN;
        this.rtBinaryDataInfo = null;
        this.intensityBinaryDataInfo = null;
        this.chromatogramType = ChromatogramType.UNKNOWN;
        this.mz = null;
        this.rtRange = null;
        this.rtValues = null;
        this.intensityValues = null;
    }

    @Nullable
    public RawDataFile getRawDataFile() {
        return this.dataFile;
    }

    @Nonnull
    public Integer getChromatogramNumber() {
        return this.chromatogramNumber;
    }

    public MzMLCVGroup getCVParams() {
        return this.cvParams;
    }

    public MzMLBinaryDataInfo getRtBinaryDataInfo() {
        return this.rtBinaryDataInfo;
    }

    public void setRtBinaryDataInfo(MzMLBinaryDataInfo rtBinaryDataInfo) {
        this.rtBinaryDataInfo = rtBinaryDataInfo;
    }

    public MzMLBinaryDataInfo getIntensityBinaryDataInfo() {
        return this.intensityBinaryDataInfo;
    }

    public void setIntensityBinaryDataInfo(MzMLBinaryDataInfo intensityBinaryDataInfo) {
        this.intensityBinaryDataInfo = intensityBinaryDataInfo;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public MzMLPrecursorElement getPrecursor() {
        return this.precursor;
    }

    public void setPrecursor(MzMLPrecursorElement precursor) {
        this.precursor = precursor;
    }

    public MzMLProduct getProduct() {
        return this.product;
    }

    public void setProdcut(MzMLProduct product) {
        this.product = product;
    }

    public String getId() {
        return this.chromatogramId;
    }

    @Nonnull
    public ChromatogramType getChromatogramType() {
        if (this.chromatogramType != ChromatogramType.UNKNOWN) {
            return this.chromatogramType;
        }
        int count = 0;
        if (this.getCVValue("MS:1000235").isPresent()) {
            this.chromatogramType = ChromatogramType.TIC;
            ++count;
        }
        if (this.getCVValue("MS:1001473").isPresent()) {
            this.chromatogramType = ChromatogramType.MRM_SRM;
            ++count;
        }
        if (this.getCVValue("MS:1000627").isPresent()) {
            this.chromatogramType = ChromatogramType.SIC;
            ++count;
        }
        if (this.getCVValue("MS:1000628").isPresent()) {
            this.chromatogramType = ChromatogramType.BPC;
            ++count;
        }
        if (count > 1) {
            this.logger.error("More than one chromatogram type defined by CV terms not allowed");
            this.chromatogramType = ChromatogramType.UNKNOWN;
        }
        return this.chromatogramType;
    }

    @Nullable
    public Double getMz() {
        Optional<String> cvval;
        if (this.mz == null && this.product != null && this.product.getIsolationWindow().isPresent() && (cvval = this.getCVValue(this.product.getIsolationWindow().get(), "MS:1000827")).isPresent()) {
            this.mz = Double.valueOf(cvval.get());
        }
        return this.mz;
    }

    @Nonnull
    public List<IsolationInfo> getIsolations() {
        if (this.getChromatogramType() == ChromatogramType.MRM_SRM) {
            Optional<MzMLIsolationWindow> precursorIsolationWindow = this.getPrecursor().getIsolationWindow();
            Optional<MzMLIsolationWindow> productIsolationWindow = this.getProduct().getIsolationWindow();
            if (!precursorIsolationWindow.isPresent()) {
                this.logger.error("Couldn't find precursor isolation window for chromotgram (#" + this.getChromatogramNumber() + ")");
                return Collections.emptyList();
            }
            if (!productIsolationWindow.isPresent()) {
                this.logger.error("Couldn't find product isolation window for chromotgram (#" + this.getChromatogramNumber() + ")");
                return Collections.emptyList();
            }
            Optional<String> precursorIsolationMz = this.getCVValue(precursorIsolationWindow.get(), "MS:1000827");
            Optional<String> precursorActivationEnergy = this.getCVValue(this.getPrecursor().getActivation(), "MS:1000045");
            Optional<String> productIsolationMz = this.getCVValue(productIsolationWindow.get(), "MS:1000827");
            ActivationType precursorActivation = ActivationType.UNKNOWN;
            SimpleActivationInfo activationInfo = null;
            if (this.getCVValue(this.getPrecursor().getActivation(), "MS:1000133").isPresent()) {
                precursorActivation = ActivationType.CID;
            }
            if (precursorActivationEnergy != null) {
                activationInfo = new SimpleActivationInfo(Double.valueOf(precursorActivationEnergy.get()), precursorActivation);
            }
            ArrayList<SimpleIsolationInfo> isolations = new ArrayList<SimpleIsolationInfo>();
            SimpleIsolationInfo isolationInfo = null;
            if (precursorIsolationMz.isPresent()) {
                isolationInfo = new SimpleIsolationInfo(Range.singleton((Comparable)Double.valueOf(precursorIsolationMz.get())), null, Double.valueOf(precursorIsolationMz.get()), null, (ActivationInfo)activationInfo);
                isolations.add(isolationInfo);
            }
            if (productIsolationMz.isPresent()) {
                isolationInfo = new SimpleIsolationInfo(Range.singleton((Comparable)Double.valueOf(productIsolationMz.get())), null, Double.valueOf(productIsolationMz.get()), null, null);
                isolations.add(isolationInfo);
            }
            return Collections.unmodifiableList(isolations);
        }
        return Collections.emptyList();
    }

    @Nonnull
    public SeparationType getSeparationType() {
        return this.separationType;
    }

    public IonAnnotation getIonAnnotation() {
        return null;
    }

    @Nonnull
    public Integer getNumberOfDataPoints() {
        return this.numOfDataPoints;
    }

    @Nonnull
    public float[] getRetentionTimes(@Nullable float[] array) {
        if (this.rtValues == null) {
            if (this.getRtBinaryDataInfo().getArrayLength() != this.numOfDataPoints.intValue()) {
                this.logger.warn("Retention time binary data array contains a different array length from the default array length of the scan (#" + this.getChromatogramNumber() + ")");
            }
            try {
                this.rtValues = MzMLPeaksDecoder.decodeToFloat(this.inputStream, this.getRtBinaryDataInfo(), array);
            }
            catch (Exception e) {
                throw new MSDKRuntimeException((Throwable)e);
            }
        }
        if (array == null || array.length < this.numOfDataPoints) {
            array = new float[this.numOfDataPoints.intValue()];
            System.arraycopy(this.rtValues, 0, array, 0, this.numOfDataPoints);
        }
        return array;
    }

    @Nonnull
    public float[] getIntensityValues(@Nullable float[] array) {
        if (this.intensityValues == null) {
            if (this.getIntensityBinaryDataInfo().getArrayLength() != this.numOfDataPoints.intValue()) {
                this.logger.warn("Intensity binary data array contains a different array length from the default array length of the chromatogram (#" + this.getChromatogramNumber() + ")");
            }
            try {
                this.intensityValues = MzMLPeaksDecoder.decodeToFloat(this.inputStream, this.getIntensityBinaryDataInfo(), array);
            }
            catch (Exception e) {
                throw new MSDKRuntimeException((Throwable)e);
            }
        }
        if (array == null || array.length < this.numOfDataPoints) {
            array = new float[this.numOfDataPoints.intValue()];
            System.arraycopy(this.intensityValues, 0, array, 0, this.numOfDataPoints);
        }
        return array;
    }

    @Nullable
    public double[] getMzValues(@Nullable double[] array) {
        return null;
    }

    @Nullable
    public Range<Float> getRtRange() {
        if (this.rtRange == null) {
            float[] rtValues = this.getRetentionTimes();
            this.rtRange = Range.closed((Comparable)Float.valueOf(rtValues[0]), (Comparable)Float.valueOf(rtValues[this.numOfDataPoints - 1]));
        }
        return this.rtRange;
    }

    public Optional<String> getCVValue(String accession) {
        return this.getCVValue(this.cvParams, accession);
    }

    public Optional<String> getCVValue(MzMLCVGroup group, String accession) {
        for (MzMLCVParam cvParam : group.getCVParamsList()) {
            if (!cvParam.getAccession().equals(accession)) continue;
            Optional<String> value = cvParam.getValue();
            if (!value.isPresent()) {
                value = Optional.of("");
            }
            return value;
        }
        return Optional.empty();
    }
}

