/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.io.mzml.data;

import java.util.Optional;

public class MzMLCVParam {
    private final String accession;
    private final Optional<String> value;
    private final Optional<String> name;
    private final Optional<String> unitAccession;

    public MzMLCVParam(String accession, String value, String name, String unitAccession) {
        if (accession == null) {
            throw new IllegalArgumentException("Accession can't be null");
        }
        if (accession.length() == 0) {
            throw new IllegalArgumentException("Accession can't be an empty string");
        }
        this.accession = accession;
        if (value != null && value.length() == 0) {
            value = null;
        }
        this.value = Optional.ofNullable(value);
        if (name != null && name.length() == 0) {
            name = null;
        }
        this.name = Optional.ofNullable(name);
        if (unitAccession != null && unitAccession.length() == 0) {
            unitAccession = null;
        }
        this.unitAccession = Optional.ofNullable(unitAccession);
    }

    public String getAccession() {
        return this.accession;
    }

    public Optional<String> getValue() {
        return this.value;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<String> getUnitAccession() {
        return this.unitAccession;
    }
}

