/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.jeremylong.openvulnerability.client.nvd.CvssV3Data;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"source", "type", "cvssData", "exploitabilityScore", "impactScore"})
public class CvssV3
implements Serializable {
    private static final long serialVersionUID = 3239377501678853019L;
    @JsonProperty(value="source")
    private String source;
    @JsonProperty(value="type")
    private Type type;
    @JsonProperty(value="cvssData")
    private CvssV3Data cvssData;
    @JsonProperty(value="exploitabilityScore")
    @JsonPropertyDescription(value="CVSS subscore.")
    private Double exploitabilityScore;
    @JsonProperty(value="impactScore")
    @JsonPropertyDescription(value="CVSS subscore.")
    private Double impactScore;

    public CvssV3() {
    }

    public CvssV3(String source, Type type, CvssV3Data cvssData, Double exploitabilityScore, Double impactScore) {
        this.source = source;
        this.type = type;
        this.cvssData = cvssData;
        this.exploitabilityScore = exploitabilityScore;
        this.impactScore = impactScore;
    }

    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="cvssData")
    public CvssV3Data getCvssData() {
        return this.cvssData;
    }

    @JsonProperty(value="exploitabilityScore")
    public Double getExploitabilityScore() {
        return this.exploitabilityScore;
    }

    @JsonProperty(value="impactScore")
    public Double getImpactScore() {
        return this.impactScore;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CVSS:");
        sb.append(this.cvssData.getVersion() == null ? "" : this.cvssData.getVersion()).append("/AV:").append(this.cvssData.getAttackVector() == null ? "" : this.cvssData.getAttackVector().value().substring(0, 1)).append("/AC:").append(this.cvssData.getAttackComplexity() == null ? "" : this.cvssData.getAttackComplexity().value().substring(0, 1)).append("/PR:").append(this.cvssData.getPrivilegesRequired() == null ? "" : this.cvssData.getPrivilegesRequired().value().substring(0, 1)).append("/UI:").append(this.cvssData.getUserInteraction() == null ? "" : this.cvssData.getUserInteraction().value().substring(0, 1)).append("/S:").append(this.cvssData.getScope() == null ? "" : this.cvssData.getScope().value().substring(0, 1)).append("/C:").append(this.cvssData.getConfidentialityImpact() == null ? "" : this.cvssData.getConfidentialityImpact().value().substring(0, 1)).append("/I:").append(this.cvssData.getIntegrityImpact() == null ? "" : this.cvssData.getIntegrityImpact().value().substring(0, 1)).append("/A:").append(this.cvssData.getAvailabilityImpact() == null ? "" : this.cvssData.getAvailabilityImpact().value().substring(0, 1));
        if (this.exploitabilityScore != null) {
            sb.append("/E:").append(this.exploitabilityScore);
        }
        if (this.cvssData.getRemediationLevel() != null && this.cvssData.getRemediationLevel() != CvssV3Data.RemediationLevelType.NOT_DEFINED) {
            sb.append("/RL:").append(this.cvssData.getRemediationLevel().value().charAt(0));
        }
        if (this.cvssData.getReportConfidence() != null && this.cvssData.getReportConfidence() != CvssV3Data.ConfidenceType.NOT_DEFINED) {
            sb.append("/RC:").append(this.cvssData.getReportConfidence().value().charAt(0));
        }
        if (this.cvssData.getConfidentialityRequirement() != null && this.cvssData.getConfidentialityRequirement() != CvssV3Data.CiaRequirementType.NOT_DEFINED) {
            sb.append("/CR:").append(this.cvssData.getConfidentialityRequirement().value().charAt(0));
        }
        if (this.cvssData.getIntegrityRequirement() != null && this.cvssData.getIntegrityRequirement() != CvssV3Data.CiaRequirementType.NOT_DEFINED) {
            sb.append("/IR:").append(this.cvssData.getIntegrityRequirement().value().charAt(0));
        }
        if (this.cvssData.getAvailabilityRequirement() != null && this.cvssData.getAvailabilityRequirement() != CvssV3Data.CiaRequirementType.NOT_DEFINED) {
            sb.append("/AR:").append(this.cvssData.getAvailabilityRequirement().value().charAt(0));
        }
        if (this.cvssData.getModifiedAttackVector() != null && this.cvssData.getModifiedAttackVector() != CvssV3Data.ModifiedAttackVectorType.NOT_DEFINED) {
            sb.append("/MAV:").append(this.cvssData.getModifiedAttackVector().value().charAt(0));
        }
        if (this.cvssData.getModifiedAttackComplexity() != null && this.cvssData.getModifiedAttackComplexity() != CvssV3Data.ModifiedAttackComplexityType.NOT_DEFINED) {
            sb.append("/MAC:").append(this.cvssData.getModifiedAttackComplexity().value().charAt(0));
        }
        if (this.cvssData.getModifiedPrivilegesRequired() != null && this.cvssData.getModifiedPrivilegesRequired() != CvssV3Data.ModifiedPrivilegesRequiredType.NOT_DEFINED) {
            sb.append("/MPR:").append(this.cvssData.getModifiedPrivilegesRequired().value().charAt(0));
        }
        if (this.cvssData.getModifiedUserInteraction() != null && this.cvssData.getModifiedUserInteraction() != CvssV3Data.ModifiedUserInteractionType.NOT_DEFINED) {
            sb.append("/MUI:").append(this.cvssData.getModifiedUserInteraction().value().charAt(0));
        }
        if (this.cvssData.getModifiedScope() != null && this.cvssData.getModifiedScope() != CvssV3Data.ModifiedScopeType.NOT_DEFINED) {
            sb.append("/MS:").append(this.cvssData.getModifiedScope().value().charAt(0));
        }
        if (this.cvssData.getModifiedConfidentialityImpact() != null && this.cvssData.getModifiedConfidentialityImpact() != CvssV3Data.ModifiedCiaType.NOT_DEFINED) {
            sb.append("/MC:").append(this.cvssData.getModifiedConfidentialityImpact().value().charAt(0));
        }
        if (this.cvssData.getModifiedIntegrityImpact() != null && this.cvssData.getModifiedIntegrityImpact() != CvssV3Data.ModifiedCiaType.NOT_DEFINED) {
            sb.append("/MI:").append(this.cvssData.getModifiedIntegrityImpact().value().charAt(0));
        }
        if (this.cvssData.getModifiedAvailabilityImpact() != null && this.cvssData.getModifiedAvailabilityImpact() != CvssV3Data.ModifiedCiaType.NOT_DEFINED) {
            sb.append("/MA:").append(this.cvssData.getModifiedAvailabilityImpact().value().charAt(0));
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CvssV3 cvssV3 = (CvssV3)o;
        return Objects.equals(this.source, cvssV3.source) && this.type == cvssV3.type && Objects.equals(this.cvssData, cvssV3.cvssData) && Objects.equals(this.exploitabilityScore, cvssV3.exploitabilityScore) && Objects.equals(this.impactScore, cvssV3.impactScore);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.type, this.cvssData, this.exploitabilityScore, this.impactScore});
    }

    public static enum Type {
        PRIMARY("Primary"),
        SECONDARY("Secondary");

        private static final Map<String, Type> CONSTANTS;
        private final String value;

        private Type(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

