/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core.cibuild;

import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import pl.project13.core.cibuild.BuildServerDataProvider;
import pl.project13.core.log.LogInterface;

public class TravisBuildServerData
extends BuildServerDataProvider {
    TravisBuildServerData(LogInterface log, @Nonnull Map<String, String> env) {
        super(log, env);
    }

    public static boolean isActiveServer(@Nonnull Map<String, String> env) {
        return env.containsKey("TRAVIS");
    }

    @Override
    void loadBuildNumber(@Nonnull Properties properties) {
        String buildNumber = this.env.getOrDefault("TRAVIS_BUILD_NUMBER", "");
        String uniqueBuildNumber = this.env.getOrDefault("TRAVIS_BUILD_ID", "");
        this.maybePut(properties, "build.number", () -> buildNumber);
        this.maybePut(properties, "build.number.unique", () -> uniqueBuildNumber);
    }

    @Override
    public String getBuildBranch() {
        String environmentBasedBranch = (String)this.env.get("TRAVIS_BRANCH");
        this.log.info(String.format("Using environment variable based branch name. TRAVIS_BRANCH = %s", environmentBasedBranch));
        return environmentBasedBranch;
    }
}

