/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.cfg.visualize;

import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Map;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.checkerframework.errorprone.checker.mustcall.qual.MustCall;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.analysis.AbstractValue;
import org.checkerframework.errorprone.dataflow.analysis.Analysis;
import org.checkerframework.errorprone.dataflow.analysis.Store;
import org.checkerframework.errorprone.dataflow.analysis.TransferFunction;
import org.checkerframework.errorprone.dataflow.cfg.CFGProcessor;
import org.checkerframework.errorprone.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.errorprone.dataflow.cfg.visualize.CFGVisualizeOptions;
import org.checkerframework.errorprone.dataflow.cfg.visualize.DOTCFGVisualizer;
import org.checkerframework.errorprone.dataflow.cfg.visualize.StringCFGVisualizer;
import org.checkerframework.errorprone.org.plumelib.util.ArrayMap;

public final class CFGVisualizeLauncher {
    private CFGVisualizeLauncher() {
        throw new AssertionError((Object)"Class CFGVisualizeLauncher cannot be instantiated.");
    }

    public static void main(String[] args) {
        CFGVisualizeOptions config = CFGVisualizeOptions.parseArgs(args);
        CFGVisualizeLauncher.performAnalysis(config, null);
    }

    public static <V extends AbstractValue<V>, S extends Store<S>, T extends TransferFunction<V, S>> void performAnalysis(CFGVisualizeOptions config, @Nullable Analysis<V, S, T> analysis) {
        if (!config.isString()) {
            if (analysis == null) {
                CFGVisualizeLauncher.generateDOTofCFGWithoutAnalysis(config.getInputFile(), config.getOutputDirectory(), config.getMethodName(), config.getClassName(), config.isPDF(), config.isVerbose());
            } else {
                CFGVisualizeLauncher.generateDOTofCFG(config.getInputFile(), config.getOutputDirectory(), config.getMethodName(), config.getClassName(), config.isPDF(), config.isVerbose(), analysis);
            }
        } else if (analysis == null) {
            String stringGraph = CFGVisualizeLauncher.generateStringOfCFGWithoutAnalysis(config.getInputFile(), config.getMethodName(), config.getClassName(), config.isVerbose());
            System.out.println(stringGraph);
        } else {
            Map<String, Object> res = CFGVisualizeLauncher.generateStringOfCFG(config.getInputFile(), config.getMethodName(), config.getClassName(), config.isVerbose(), analysis);
            if (res != null) {
                String stringGraph = (String)res.get("stringGraph");
                if (stringGraph == null) {
                    System.err.println("Unexpected output from generating string control flow graph, shouldn't be null. Result map: " + res);
                    return;
                }
                System.out.println(stringGraph);
            } else {
                System.err.println("Unexpected output from generating string control flow graph, shouldn't be null.");
            }
        }
    }

    private static void generateDOTofCFGWithoutAnalysis(String inputFile, String outputDir, String method, String clas, boolean pdf, boolean verbose) {
        CFGVisualizeLauncher.generateDOTofCFG(inputFile, outputDir, method, clas, pdf, verbose, null);
    }

    private static String generateStringOfCFGWithoutAnalysis(String inputFile, String method, String clas, boolean verbose) {
        Map<String, Object> res = CFGVisualizeLauncher.generateStringOfCFG(inputFile, method, clas, verbose, null);
        if (res != null) {
            String stringGraph = (String)res.get("stringGraph");
            if (stringGraph == null) {
                return "Unexpected output from generating string control flow graph, shouldn't be null.";
            }
            return stringGraph;
        }
        return "Unexpected output from generating string control flow graph, shouldn't be null.";
    }

    private static <V extends AbstractValue<V>, S extends Store<S>, T extends TransferFunction<V, S>> void generateDOTofCFG(String inputFile, String outputDir, String method, String clas, boolean pdf, boolean verbose, @Nullable Analysis<V, S, T> analysis) {
        ControlFlowGraph cfg = CFGVisualizeLauncher.generateMethodCFG(inputFile, clas, method);
        if (analysis != null) {
            analysis.performAnalysis(cfg);
        }
        ArrayMap<String, Object> args = new ArrayMap<String, Object>(2);
        args.put("outdir", outputDir);
        args.put("verbose", verbose);
        DOTCFGVisualizer<V, S, T> viz = new DOTCFGVisualizer<V, S, T>();
        viz.init(args);
        Map<String, Object> res = viz.visualizeWithAction(cfg, cfg.getEntryBlock(), analysis);
        viz.shutdown();
        if (pdf && res != null) {
            assert (res.get("dotFileName") != null) : "@AssumeAssertion(nullness): specification";
            CFGVisualizeLauncher.producePDF((String)res.get("dotFileName"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ControlFlowGraph generateMethodCFG(String file, String clas, String method) {
        JavaFileObject l;
        CFGProcessor cfgProcessor = new CFGProcessor(clas, method);
        Context context = new Context();
        Options.instance(context).put("compilePolicy", "ATTR_ONLY");
        JavaCompiler javac = new JavaCompiler(context);
        try (JavacFileManager fileManager = (JavacFileManager)context.get(JavaFileManager.class);){
            l = fileManager.getJavaFileObjectsFromStrings(List.of(file)).iterator().next();
        }
        catch (IOException e) {
            throw new Error(e);
        }
        PrintStream err = System.err;
        try {
            @MustCall OutputStream nullOS = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            };
            System.setErr(new PrintStream(nullOS));
            javac.compile(List.of(l), List.of(clas), List.of(cfgProcessor), List.nil());
        }
        catch (Throwable nullOS) {
        }
        finally {
            System.setErr(err);
        }
        CFGProcessor.CFGProcessResult res = cfgProcessor.getCFGProcessResult();
        if (res == null) {
            CFGVisualizeLauncher.printError("internal error in type processor! method typeProcessOver() doesn't get called.");
            System.exit(1);
        }
        if (!res.isSuccess()) {
            CFGVisualizeLauncher.printError(res.getErrMsg());
            System.exit(1);
        }
        return res.getCFG();
    }

    public static void writeStringOfCFG(String inputFile, String method, String clas, String outputFile, Analysis<?, ?, ?> analysis) {
        Map<String, Object> res = CFGVisualizeLauncher.generateStringOfCFG(inputFile, method, clas, true, analysis);
        try (FileWriter out = new FileWriter(outputFile);){
            if (res != null && res.get("stringGraph") != null) {
                out.write(res.get("stringGraph").toString());
            }
            out.write("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void producePDF(String file) {
        try {
            String command = "dot -Tpdf \"" + file + "\" -o \"" + file + ".pdf\"";
            Process child = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command});
            child.waitFor();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static <V extends AbstractValue<V>, S extends Store<S>, T extends TransferFunction<V, S>> @Nullable Map<String, Object> generateStringOfCFG(String inputFile, String method, String clas, boolean verbose, @Nullable Analysis<V, S, T> analysis) {
        ControlFlowGraph cfg = CFGVisualizeLauncher.generateMethodCFG(inputFile, clas, method);
        if (analysis != null) {
            analysis.performAnalysis(cfg);
        }
        Map<String, Object> args = Collections.singletonMap("verbose", verbose);
        StringCFGVisualizer<V, S, T> viz = new StringCFGVisualizer<V, S, T>();
        viz.init(args);
        Map<String, Object> res = viz.visualize(cfg, cfg.getEntryBlock(), analysis);
        viz.shutdown();
        return res;
    }

    private static void printError(@Nullable String string) {
        System.err.println("ERROR: " + string);
    }
}

