/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.highcharts.template;

import io.gatling.charts.highcharts.series.PercentilesSeries;
import io.gatling.charts.highcharts.template.Template;
import io.gatling.charts.util.Color;
import java.io.Serializable;
import java.util.Locale;
import scala.Function1;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005-3QAD\b\u0003#eA\u0001B\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\t[\u0001\u0011\t\u0011)A\u0005]!)1\u0007\u0001C\u0001i!9\u0001\b\u0001b\u0001\n\u0013I\u0004B\u0002\u001e\u0001A\u0003%\u0001\u0005C\u0004<\u0001\t\u0007I\u0011\u0002\u001f\t\r\u0011\u0003\u0001\u0015!\u0003>\u0011\u001d)\u0005A1A\u0005\nqBaA\u0012\u0001!\u0002\u0013i\u0004bB$\u0001\u0005\u0004%I\u0001\u0010\u0005\u0007\u0011\u0002\u0001\u000b\u0011B\u001f\t\u000b%\u0003A\u0011I\u001d\t\u000b)\u0003A\u0011I\u001d\u00037A+'oY3oi&dWm](wKJ$\u0016.\\3UK6\u0004H.\u0019;f\u0015\t\u0001\u0012#\u0001\u0005uK6\u0004H.\u0019;f\u0015\t\u00112#\u0001\u0006iS\u001eD7\r[1siNT!\u0001F\u000b\u0002\r\rD\u0017M\u001d;t\u0015\t1r#A\u0004hCRd\u0017N\\4\u000b\u0003a\t!![8\u0014\u0005\u0001Q\u0002CA\u000e\u001d\u001b\u0005y\u0011BA\u000f\u0010\u0005!!V-\u001c9mCR,\u0017!C=Bq&\u001ch*Y7f\u0007\u0001\u0001\"!\t\u0016\u000f\u0005\tB\u0003CA\u0012'\u001b\u0005!#BA\u0013 \u0003\u0019a$o\\8u})\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\u00051\u0001K]3eK\u001aL!a\u000b\u0017\u0003\rM#(/\u001b8h\u0015\tIc%\u0001\u0004tKJLWm\u001d\t\u0003_Ej\u0011\u0001\r\u0006\u0003[EI!A\r\u0019\u0003#A+'oY3oi&dWm]*fe&,7/\u0001\u0004=S:LGO\u0010\u000b\u0004kY:\u0004CA\u000e\u0001\u0011\u0015q2\u00011\u0001!\u0011\u0015i3\u00011\u0001/\u0003\u0015!\u0018\u000e\u001e7f+\u0005\u0001\u0013A\u0002;ji2,\u0007%\u0001\u0004kg:\u000bW.Z\u000b\u0002{A\u0011ahQ\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0005Y\u0006twMC\u0001C\u0003\u0011Q\u0017M^1\n\u0005-z\u0014a\u00026t\u001d\u0006lW\rI\u0001\nG\"\f'\u000f\u001e(b[\u0016\f!b\u00195beRt\u0015-\\3!\u0003-\u0019wN\u001c;bS:,'/\u00133\u0002\u0019\r|g\u000e^1j]\u0016\u0014\u0018\n\u001a\u0011\u0002\u0005)\u001c\u0018\u0001\u00025u[2\u0004")
public final class PercentilesOverTimeTemplate
extends Template {
    private final String yAxisName;
    private final PercentilesSeries series;
    private final String title;
    private final String jsName;
    private final String chartName;
    private final String containerId;

    private String title() {
        return this.title;
    }

    private String jsName() {
        return this.jsName;
    }

    private String chartName() {
        return this.chartName;
    }

    private String containerId() {
        return this.containerId;
    }

    @Override
    public String js() {
        return "\nvar " + this.jsName() + " = unpack(" + this.series.render() + ");\n\nvar " + this.chartName() + " = new Highcharts.StockChart({\n  chart: {\n    renderTo: '" + this.containerId() + "',\n    zoomType: 'x',\n    marginBottom: 60\n  },\n  colors: [" + this.series.colors().map((Function1 & Serializable)color -> "'" + color + "'").mkString(", ") + "],\n  credits: { enabled: false },\n  legend: {\n    enabled: true,\n    floating: true,\n    y: -65,\n    borderWidth: 0,\n    itemStyle: { fontWeight: \"normal\" },\n    symbolRadius: 0\n  },\n  title: { text: 'A title to let highcharts reserve the place for the title set later' },\n  navigator: {\n    maskInside: false,\n    baseSeries: 9\n  },\n  rangeSelector: {\n    rangeSelector: { align: \"left\" },\n    buttonSpacing: 0,\n    buttonTheme: {\n      fill: '" + Color.RangeSelector$.Fill$.MODULE$ + "',\n      padding: 1,\n      stroke: '" + Color.RangeSelector$.Border$.MODULE$ + "',\n      'stroke-width': 0.25,\n      style: {\n        color: '" + Color.RangeSelector$.Border$.MODULE$ + "',\n        fontWeight: 'bold',\n      },\n      states: {\n        stroke: '" + Color.RangeSelector$.Hover$.MODULE$ + "',\n        'stroke-width': 0.25,\n        hover: {\n          fill: '" + Color.RangeSelector$.Hover$.MODULE$ + "',\n          style: { color: 'black' }\n        },\n        select: {\n          fill: '" + Color.RangeSelector$.MODULE$.Selected() + "',\n          style: { color: 'white' }\n        }\n      }\n    },\n    buttons : [\n      {\n        type : 'minute',\n        count : 1,\n        text : '1m'\n      }, {\n        type : 'minute',\n        count : 10,\n        text : '10m'\n      }, {\n        type : 'hour',\n        count : 1,\n        text : '1h'\n      }, {\n        type : 'all',\n        count : 1,\n        text : 'All'\n      }\n    ],\n    selected : 3,\n    inputEnabled : false\n  },\n  xAxis: {\n    type: 'datetime',\n    ordinal: false,\n    maxZoom: 10000 // three days\n  },\n  yAxis:[\n    {\n      min: 0,\n      title: { text: '" + this.yAxisName + " (ms)' },\n      opposite: false\n    }, {\n      min: 0,\n      title: {\n        text: 'Active Users',\n        style: { color: '" + Color.Users$.MODULE$.All() + "' }\n      },\n      opposite: true\n    }\n  ],\n  plotOptions: {\n    arearange: { lineWidth: 1 },\n    series: {\n      dataGrouping: { enabled: false }\n    }\n  },\n  series: [\n  " + this.renderPercentilesSeries(this.series, this.jsName()) + "\n  allUsersData\n  ]\n});\n\n" + this.chartName() + ".setTitle({\n  text: '<span class=\"chart_title chart_title_\">" + this.title() + "</span>',\n  useHTML: true\n});\n";
    }

    @Override
    public String html() {
        return "\n            <div class=\"schema geant\">\n              <div id=\"" + this.containerId() + "\" class=\"geant\"></div>\n            </div>\n";
    }

    public PercentilesOverTimeTemplate(String yAxisName, PercentilesSeries series) {
        this.yAxisName = yAxisName;
        this.series = series;
        this.title = series.name();
        this.jsName = this.title().replaceAll("[ ()]", "").toLowerCase(Locale.ROOT) + "Percentiles";
        this.chartName = this.jsName() + "Chart";
        this.containerId = this.jsName() + "Container";
    }
}

