/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl;

import io.gatling.http.client.HttpListener;
import io.gatling.http.client.impl.Http2AppHandler;
import io.gatling.http.client.impl.RequestTimeoutException;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import java.net.InetSocketAddress;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public interface RequestTimeout {
    public static RequestTimeout requestTimeout(long l, HttpListener httpListener) {
        return l > 0L ? new DefaultRequestTimeout(l, httpListener) : NoopRequestTimeout.INSTANCE;
    }

    public void start(EventLoop var1);

    public boolean isDone();

    public void cancel();

    public void setChannel(Channel var1);

    public void setStreamId(int var1);

    public static class NoopRequestTimeout
    implements RequestTimeout {
        private static final NoopRequestTimeout INSTANCE = new NoopRequestTimeout();

        private NoopRequestTimeout() {
        }

        @Override
        public void start(EventLoop eventLoop) {
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public void cancel() {
        }

        @Override
        public void setChannel(Channel channel) {
        }

        @Override
        public void setStreamId(int n) {
        }
    }

    public static class DefaultRequestTimeout
    implements RequestTimeout {
        private final long timeout;
        private final HttpListener listener;
        private Channel channel;
        private Integer streamId;
        private InetSocketAddress remoteAddress;
        private ScheduledFuture<?> f;

        private DefaultRequestTimeout(long l, HttpListener httpListener) {
            this.timeout = l;
            this.listener = httpListener;
        }

        @Override
        public void start(EventLoop eventLoop) {
            this.f = eventLoop.schedule(this::execute, this.timeout, TimeUnit.MILLISECONDS);
        }

        private void execute() {
            this.listener.onThrowable(new RequestTimeoutException(this.timeout, this.remoteAddress));
            if (this.channel != null) {
                if (this.channel.pipeline().get("app-http2") != null) {
                    if (this.streamId != null) {
                        this.channel.pipeline().fireUserEventTriggered((Object)new Http2AppHandler.StreamTimeout(this.streamId));
                    }
                } else {
                    this.channel.close();
                }
            }
        }

        @Override
        public boolean isDone() {
            return this.f.isDone();
        }

        @Override
        public void cancel() {
            this.f.cancel(true);
        }

        @Override
        public void setChannel(Channel channel) {
            this.channel = channel;
            this.remoteAddress = (InetSocketAddress)channel.remoteAddress();
        }

        @Override
        public void setStreamId(int n) {
            this.streamId = n;
        }
    }
}

