/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.tools;

import com.google.common.base.Preconditions;
import fr.ird.t3.T3Configuration;
import fr.ird.t3.entities.T3EntityHelper;
import fr.ird.t3.entities.T3ScriptHelper;
import fr.ird.t3.entities.T3TopiaRootContextFactory;
import fr.ird.t3.entities.data.TripImpl;
import fr.ird.t3.entities.user.JdbcConfiguration;
import fr.ird.t3.entities.user.JdbcConfigurationImpl;
import fr.ird.t3.services.DefaultT3ServiceContext;
import fr.ird.t3.services.T3ServiceContext;
import fr.ird.t3.services.T3ServiceFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaUtil;
import org.nuiton.util.FileUtil;
import org.nuiton.util.ZipUtil;

public class T3ApplicationInstaller {
    private static final Log log = LogFactory.getLog(T3ApplicationInstaller.class);
    protected final File connectionFile;
    protected final File postgisCreationScript;
    protected final File referentielDataScript;
    protected File[] postgisDataFiles;
    protected T3ServiceContext serviceContext;
    protected JdbcConfiguration jdbcConfiguration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) throws Exception {
        if (args.length != 4) {
            T3ApplicationInstaller.usage();
            System.exit(1);
        } else {
            File connectionFile = new File(args[0]);
            File postgisCreationScript = new File(args[1]);
            File referentielDataScript = new File(args[2]);
            File postgisDataScript = new File(args[3]);
            Preconditions.checkArgument((boolean)connectionFile.exists(), (Object)(connectionFile + " was not found!"));
            Preconditions.checkArgument((boolean)postgisCreationScript.exists(), (Object)(postgisCreationScript + " was not found!"));
            Preconditions.checkArgument((boolean)referentielDataScript.exists(), (Object)(referentielDataScript + " was not found!"));
            Preconditions.checkArgument((boolean)postgisDataScript.exists(), (Object)(postgisDataScript + " was not found!"));
            T3ApplicationInstaller installer = new T3ApplicationInstaller(connectionFile, postgisCreationScript, referentielDataScript, postgisDataScript);
            try {
                installer.run();
            }
            finally {
                installer.destroy();
            }
        }
    }

    public static void usage() {
        StringBuilder buffer = new StringBuilder(T3ApplicationInstaller.class.getSimpleName() + " requires 4 parameters :");
        buffer.append("\n").append("- databse connection properties file");
        buffer.append("\n").append("- postgis structure script creation");
        buffer.append("\n").append("- referentiel data script");
        buffer.append("\n").append("- postgis data script").append("\n");
        System.out.println(buffer.toString());
    }

    protected T3ApplicationInstaller(File connectionFile, File postgisCreationScript, File referentielDataScript, File postgisDataScript) {
        this.connectionFile = connectionFile;
        this.postgisCreationScript = postgisCreationScript;
        this.referentielDataScript = referentielDataScript;
        this.postgisDataFiles = postgisDataScript.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".zip");
            }
        });
    }

    public void run() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)"1/6 - Setup installer...");
        }
        this.setup();
        if (log.isInfoEnabled()) {
            log.info((Object)"2/6 - Database configuration verifier...");
        }
        this.checkDatabaseConnection();
        if (log.isInfoEnabled()) {
            log.info((Object)"3/6 - Create database schema...");
        }
        this.createDatabase();
        if (log.isInfoEnabled()) {
            log.info((Object)("4/6 - Create postGis structure...(" + this.postgisCreationScript + ")"));
        }
        this.loadScript(this.postgisCreationScript);
        if (log.isInfoEnabled()) {
            log.info((Object)("5/6 - Load reference datas...(" + this.referentielDataScript + ")"));
        }
        this.loadScript(this.referentielDataScript);
        File unzipDirectory = this.createUnzipDirectory("postgis-data");
        if (log.isInfoEnabled()) {
            log.info((Object)("6/6 - Import postGis datas from " + this.postgisDataFiles.length + " scripts."));
        }
        for (File postgisDataFile : this.postgisDataFiles) {
            if (log.isInfoEnabled()) {
                log.info((Object)(" o Unzip postGis datas...(" + postgisDataFile + ")"));
            }
            File unzipFile = this.unzipFile(unzipDirectory, postgisDataFile);
            if (log.isInfoEnabled()) {
                log.info((Object)(" o Load postGis datas... from " + unzipFile + " script."));
            }
            this.loadScriptLineByLine(unzipFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setup() throws IOException {
        T3Configuration configuration = new T3Configuration();
        configuration.init();
        this.serviceContext = DefaultT3ServiceContext.newContext((Locale)Locale.getDefault(), null, null, (T3Configuration)configuration, (T3ServiceFactory)new T3ServiceFactory());
        DefaultI18nInitializer i18nInitializer = new DefaultI18nInitializer("t3-i18n");
        i18nInitializer.setMissingKeyReturnNull(true);
        I18n.init((I18nInitializer)i18nInitializer, (Locale)Locale.getDefault());
        Properties p = new Properties();
        FileInputStream inputStream = new FileInputStream(this.connectionFile);
        try {
            p.load(inputStream);
        }
        finally {
            inputStream.close();
        }
        Preconditions.checkNotNull((Object)p.getProperty("url"), (Object)("url property not found in file " + this.connectionFile));
        Preconditions.checkNotNull((Object)p.getProperty("login"), (Object)("login property not found in file " + this.connectionFile));
        Preconditions.checkNotNull((Object)p.getProperty("password"), (Object)("password property not found in file " + this.connectionFile));
        this.jdbcConfiguration = new JdbcConfigurationImpl();
        this.jdbcConfiguration.setUrl(p.getProperty("url"));
        this.jdbcConfiguration.setLogin(p.getProperty("login"));
        this.jdbcConfiguration.setPassword(p.getProperty("password"));
    }

    protected void checkDatabaseConnection() throws IOException {
        try {
            T3EntityHelper.checkJDBCConnection((JdbcConfiguration)this.jdbcConfiguration);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not connect to db", e);
        }
    }

    protected void createDatabase() {
        T3TopiaRootContextFactory factory = new T3TopiaRootContextFactory();
        TopiaContext rootContext = factory.newDb(this.jdbcConfiguration);
        this.serviceContext.setTransaction(rootContext);
        try {
            boolean schemaFound = this.isSchemaCreated(rootContext);
            if (!schemaFound) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Will create schema for db (no schema found).");
                }
                rootContext.createSchema();
            }
        }
        catch (TopiaException e) {
            throw new IllegalStateException("could not start db", e);
        }
    }

    protected File unzipFile(File unzipDirectory, File script) throws IOException {
        List[] lists = ZipUtil.scanAndExplodeZip((File)script, (File)unzipDirectory, null);
        ZipUtil.uncompress((File)script, (File)unzipDirectory);
        File result = new File(unzipDirectory, (String)lists[0].get(0));
        result.deleteOnExit();
        return result;
    }

    protected File createUnzipDirectory(String name) throws IOException {
        String tmpPath = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmpPath);
        File unzupDirectory = new File(tmpDir, name + "_" + System.nanoTime());
        unzupDirectory.deleteOnExit();
        FileUtil.createDirectoryIfNecessary((File)unzupDirectory);
        return unzupDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadScript(File script) throws TopiaException, IOException {
        TopiaContext tx = this.serviceContext.getTransaction().beginTransaction();
        try {
            T3ScriptHelper.loadScript((TopiaContext)tx, (File)script);
        }
        finally {
            tx.closeContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadScriptLineByLine(File script) throws TopiaException, IOException {
        TopiaContext tx = this.serviceContext.getTransaction().beginTransaction();
        try {
            T3ScriptHelper.loadScriptLineByLine((TopiaContext)tx, (File)script, (PropertyChangeListener)new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Sql line " + evt.getNewValue() + " done."));
                    }
                }
            });
        }
        finally {
            tx.closeContext();
        }
    }

    protected boolean isSchemaCreated(TopiaContext tx) throws TopiaException {
        boolean schemaFound = TopiaUtil.isSchemaExist((Configuration)((TopiaContextImplementor)tx).getHibernateConfiguration(), (String)TripImpl.class.getName());
        return schemaFound;
    }

    protected void destroy() {
        T3EntityHelper.releaseRootContext((TopiaContext)this.serviceContext.getTransaction());
    }
}

