/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.tools.db.reference;

import fr.ird.t3.entities.T3EntityHelper;
import fr.ird.t3.entities.reference.Species;
import fr.ird.t3.entities.reference.SpeciesDAO;
import fr.ird.t3.services.ioc.InjectDAO;
import fr.ird.t3.services.ioc.InjectFromDAO;
import fr.ird.t3.tools.db.reference.AbstractReferenceImporter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public class SpeciesExtraDataImporter
extends AbstractReferenceImporter<Species> {
    private static final Log log = LogFactory.getLog(SpeciesExtraDataImporter.class);
    @InjectDAO(entityType=Species.class)
    protected SpeciesDAO dao;
    @InjectFromDAO(entityType=Species.class)
    protected List<Species> species;
    protected Map<Integer, Species> specieByCode;

    @Override
    protected void before(TopiaContext tx) throws TopiaException {
        if (CollectionUtils.isEmpty(this.species)) {
            throw new IllegalStateException("No species found in db.");
        }
        this.specieByCode = T3EntityHelper.splitBycode(this.species);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Species> loadFile(File inputFile) throws TopiaException, IOException {
        ArrayList<Species> result = new ArrayList<Species>();
        LineNumberReader reader = new LineNumberReader(new FileReader(inputFile));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] cells;
                if (line.trim().startsWith("#")) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Incoming line : " + line));
                }
                int lineNumber = reader.getLineNumber();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("At Line [" + lineNumber + "] Data line to treat : " + line));
                }
                if ((cells = line.split(":")).length != 5) {
                    throw new IllegalStateException("At line [" + lineNumber + "], data line must have 5 cells but had here " + cells.length);
                }
                this.loadLine(result, lineNumber, cells);
            }
        }
        finally {
            reader.close();
        }
        return result;
    }

    protected void loadLine(List<Species> result, int lineNumber, String[] cells) throws TopiaException {
        int specieCode = this.convertToInt(cells, lineNumber, 0);
        Species species = this.getSpecie(this.specieByCode, specieCode, lineNumber);
        float measuredRatio = this.convertToFloat(cells, lineNumber, 1);
        int lfLengthClassStep = this.convertToInt(cells, lineNumber, 2);
        int thresholdNumberLevel3FreeSchoolType = this.convertToInt(cells, lineNumber, 3);
        int thresholdNumberLevel3ObjectSchoolType = this.convertToInt(cells, lineNumber, 4);
        species.setMeasuredRatio(Float.valueOf(measuredRatio));
        species.setLfLengthClassStep(Integer.valueOf(lfLengthClassStep));
        species.setThresholdNumberLevel3FreeSchoolType(Integer.valueOf(thresholdNumberLevel3FreeSchoolType));
        species.setThresholdNumberLevel3ObjectSchoolType(Integer.valueOf(thresholdNumberLevel3ObjectSchoolType));
        this.dao.update((TopiaEntity)species);
        result.add(species);
    }
}

