/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.tools.db.zone;

import fr.ird.t3.entities.T3DAOHelper;
import fr.ird.t3.entities.reference.Ocean;
import fr.ird.t3.entities.reference.OceanDAO;
import fr.ird.t3.entities.reference.SchoolType;
import fr.ird.t3.entities.reference.SchoolTypeDAO;
import fr.ird.t3.entities.reference.zone.ZoneET;
import fr.ird.t3.entities.reference.zone.ZoneETDAO;
import fr.ird.t3.tools.db.zone.AbstractZoneImporter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ZoneETImporter
extends AbstractZoneImporter<ZoneET, ZoneETDAO> {
    private static final Log log = LogFactory.getLog(ZoneETImporter.class);
    public static final String INSERT_LINE_PATTERN = "INSERT INTO ZONEET(TOPIAID, TOPIAVERSION, TOPIACREATEDATE, VERSIONID, VERSIONLIBELLE, VERSIONSTARTDATE, VERSIONENDDATE, GID, LIBELLE, SCHOOLTYPE, OCEAN, THE_GEOM) VALUES ('%s', %s, %s, '%s', '%s', %s, %s, %s, '%s', '%s', '%s', '%s');";
    Map<Integer, Ocean> oceanByCode;
    Map<Integer, SchoolType> schoolTypeByCode;

    public ZoneETImporter(String versionId, String versionLibelle, Date versionStartDate, Date versionEndDate) {
        super(versionId, versionLibelle, versionStartDate, versionEndDate, 5);
    }

    @Override
    protected ZoneETDAO getDAO(TopiaContext tx) throws TopiaException {
        return T3DAOHelper.getZoneETDAO((TopiaContext)tx);
    }

    @Override
    protected void prepareExecute(TopiaContext tx) throws TopiaException {
        OceanDAO oceanDAO = T3DAOHelper.getOceanDAO((TopiaContext)tx);
        List oceans = oceanDAO.findAll();
        if (CollectionUtils.isEmpty((Collection)oceans)) {
            throw new IllegalStateException("No ocean found in db.");
        }
        SchoolTypeDAO schoolTypeDAO = T3DAOHelper.getSchoolTypeDAO((TopiaContext)tx);
        List schoolTypes = schoolTypeDAO.findAll();
        if (CollectionUtils.isEmpty((Collection)schoolTypes)) {
            throw new IllegalStateException("No school types found in db.");
        }
        this.oceanByCode = new TreeMap<Integer, Ocean>();
        for (Ocean ocean : oceans) {
            this.oceanByCode.put(ocean.getCode(), ocean);
        }
        this.schoolTypeByCode = new TreeMap<Integer, SchoolType>();
        for (SchoolType schoolType : schoolTypes) {
            this.schoolTypeByCode.put(schoolType.getCode(), schoolType);
        }
    }

    @Override
    protected String loadLine(List<ZoneET> result, int lineNumber, String[] cells) throws TopiaException {
        int gid = this.convertToInt(cells, lineNumber, 0);
        String libelle = this.convertToString(cells, lineNumber, 1);
        int oceanCode = this.convertToInt(cells, lineNumber, 2);
        Ocean ocean = this.getOcean(oceanCode, lineNumber);
        int schoolTypeCode = this.convertToInt(cells, lineNumber, 3);
        SchoolType schoolType = this.getSchoolType(schoolTypeCode, lineNumber);
        String postgis = this.convertToString(cells, lineNumber, 4);
        ZoneET zone = (ZoneET)((ZoneETDAO)this.dao).create(new Object[]{"gid", gid, "ocean", ocean, "schoolType", schoolType, "libelle", libelle});
        result.add(zone);
        String insertLine = String.format(INSERT_LINE_PATTERN, zone.getTopiaId(), zone.getTopiaVersion(), this.formatDate(zone.getTopiaCreateDate()), this.versionId, this.versionLibelle, this.versionStartDate, this.versionEndDate, zone.getGid(), zone.getLibelle().replaceAll("'", "''"), zone.getSchoolType().getTopiaId(), zone.getOcean().getTopiaId(), postgis);
        if (log.isDebugEnabled()) {
            log.debug((Object)insertLine);
        }
        return insertLine;
    }

    protected SchoolType getSchoolType(int specieCode, int lineNumber) {
        SchoolType specie = this.schoolTypeByCode.get(specieCode);
        if (specie == null) {
            throw new NullPointerException("At line [" + lineNumber + "], school type with code [" + specieCode + "] does not exists in db.");
        }
        return specie;
    }

    protected Ocean getOcean(int oceanCode, int lineNumber) {
        Ocean ocean = this.oceanByCode.get(oceanCode);
        if (ocean == null) {
            throw new NullPointerException("At line [" + lineNumber + "], ocean with code [" + oceanCode + "] does not exists in db.");
        }
        return ocean;
    }
}

