/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.peerunit.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class TesterUtil {
    private Properties props;
    private int peerName = Integer.MIN_VALUE;
    public static final TesterUtil instance = new TesterUtil();

    private TesterUtil() {
        try {
            Properties defaults = new Properties();
            InputStream is = this.getClass().getResourceAsStream("/peerunit.properties");
            defaults.load(is);
            is.close();
            this.props = new Properties(defaults);
            if (new File("peerunit.properties").exists()) {
                String filename = "peerunit.properties";
                FileInputStream fs = new FileInputStream(filename);
                this.props.load(fs);
                fs.close();
            }
        }
        catch (IOException e) {
            System.err.println("Could not find default properties' resource.");
            System.exit(1);
        }
    }

    public TesterUtil(InputStream is) {
        this();
        try {
            this.props.load(is);
        }
        catch (IOException e) {
            System.err.println("Could not find properties' file.");
            System.exit(1);
        }
    }

    public TesterUtil(Properties p) {
        this();
        this.props.putAll((Map<?, ?>)p);
    }

    private String getProperty(String property) {
        String value = this.props.getProperty(property);
        assert (value != null) : "Property " + property + " is undefined";
        return value;
    }

    private int readProperty() {
        try {
            this.peerName = Integer.valueOf(this.getProperty("tester.peers"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.peerName;
    }

    public int getExpectedTesters() {
        return Integer.valueOf(this.getProperty("tester.peers"));
    }

    public int getPeerName() {
        this.peerName = this.peerName == Integer.MIN_VALUE ? this.readProperty() : --this.peerName;
        return this.peerName;
    }

    public String getServerAddr() {
        String address = this.getProperty("tester.server");
        if (address == null) {
            try {
                address = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        return address;
    }

    public String getLogfile() {
        return this.getProperty("tester.logfile");
    }

    public String getDateformat() {
        return this.getProperty("tester.log.dateformat");
    }

    public String getTimeformat() {
        return this.getProperty("tester.log.timeformat");
    }

    public String getDelimiter() {
        return this.getProperty("tester.log.delimiter");
    }

    public String getLogfolder() {
        return this.getProperty("tester.logfolder");
    }

    public int getRelaxIndex() {
        return Integer.valueOf(this.getProperty("tester.relaxindex"));
    }

    public int getPort() {
        return Integer.valueOf(this.getProperty("tester.port"));
    }

    public int getObjects() {
        return Integer.valueOf(this.getProperty("test.objects"));
    }

    public int getSleep() {
        return Integer.valueOf(this.getProperty("test.sleep"));
    }

    public String getBootstrap() {
        return this.getProperty("test.bootstrap");
    }

    public int getBootstrapPort() {
        return Integer.valueOf(this.getProperty("test.bootstrap.port"));
    }

    public int getWaitForMethod() {
        return Integer.valueOf(this.getProperty("tester.waitForMethod"));
    }

    public int getLoopToFail() {
        return Integer.valueOf(this.getProperty("test.loopToFail"));
    }

    public int getChurnPercentage() {
        return Integer.valueOf(this.getProperty("test.churnPercentage"));
    }

    public Level getLogLevel() {
        return Level.parse(this.getProperty("tester.log.level"));
    }

    public int getTreeOrder() {
        return Integer.valueOf(this.getProperty("test.treeOrder"));
    }

    public int getTreeStrategy() {
        return Integer.valueOf(this.getProperty("test.treeStrategy"));
    }

    public int getCoordinationType() {
        return Integer.valueOf(this.getProperty("test.coordination"));
    }

    public int getTreeWaitForMethod() {
        return Integer.valueOf(this.getProperty("test.treeWaitForMethod"));
    }

    public int getStationTreeTrace() {
        return Integer.valueOf(this.getProperty("tester.stationTreeTrace"));
    }

    public String getHostsFilePath() {
        return this.getProperty("tester.hostfile");
    }

    public int getRegistryPort() {
        int port;
        try {
            port = Integer.parseInt(this.getProperty("registry.port"));
        }
        catch (NumberFormatException e) {
            port = 1099;
        }
        return port;
    }
}

