/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.peerunit.util;

import fr.inria.peerunit.util.HNode;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTree<K, V> {
    private final int order;
    private HNodeImpl head;
    private int size = 0;

    public HTree(int b) {
        this.order = b;
    }

    public HNode<K, V> head() {
        return this.head;
    }

    public void put(K key, V value) {
        if (this.head == null) {
            this.head = new HNodeImpl(key, value);
        } else {
            this.head.put(key, value);
        }
        ++this.size;
    }

    public boolean containsKey(K key) {
        return this.head == null ? false : this.head.containsKey(key);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.head = null;
        this.size = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HNodeImpl
    implements HNode<K, V> {
        private int position = 0;
        private K key;
        private V value;
        private HNodeImpl[] children = (HNodeImpl[])Array.newInstance(HNodeImpl.class, HTree.access$000(HTree.this));

        public HNodeImpl(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }

        @Override
        public HNode<K, V>[] children() {
            int i;
            for (i = 0; i < this.children.length && this.children[i] != null; ++i) {
            }
            HNodeImpl[] result = (HNodeImpl[])Array.newInstance(HNodeImpl.class, i);
            System.arraycopy(this.children, 0, result, 0, i);
            return result;
        }

        @Override
        public boolean isLeaf() {
            return this.children[0] == null;
        }

        public void put(K k, V v) {
            if (this.children[this.position] == null) {
                this.children[this.position] = new HNodeImpl(k, v);
            } else {
                this.children[this.position].put(k, v);
            }
            this.position = (this.position + 1) % HTree.this.order;
        }

        public boolean containsKey(K k) {
            boolean result = false;
            if (k == this.key) {
                result = true;
            } else {
                for (int i = 0; i < this.children.length && !result && this.children[i] != null; ++i) {
                    result = this.children[i].containsKey(k);
                }
            }
            return result;
        }

        public String toString() {
            return String.format("HNode<%s,%s>", this.key, this.value);
        }
    }
}

