/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.peerunit.test.assertion;

import fr.inria.peerunit.test.assertion.ComparisonFailure;
import fr.inria.peerunit.test.assertion.Failure;
import fr.inria.peerunit.test.assertion.InconclusiveFailure;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assert {
    public static void assertTrue(String message, boolean condition) {
        if (!condition) {
            Assert.fail(message);
        }
    }

    public static void assertTrue(boolean condition) {
        Assert.assertTrue("", condition);
    }

    public static void fail(String message) {
        throw new Failure(message);
    }

    public static void inconclusive(String message) {
        throw new InconclusiveFailure(message);
    }

    public static void fail() {
        Assert.fail("");
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        if (!(expected == actual || expected != null && expected.equals(actual))) {
            throw new ComparisonFailure(message, expected, actual);
        }
    }

    public static void assertEquals(Object expected, Object actual) {
        Assert.assertEquals("", expected, actual);
    }

    public static void assertListEquals(String message, List<?> expected, List<?> actual) {
        if (expected == null || actual == null || expected.size() != actual.size() || !expected.containsAll(actual)) {
            throw new ComparisonFailure(message, expected, actual);
        }
    }

    public static void assertListEquals(List<?> expected, List<?> actual) {
        Assert.assertListEquals("", expected, actual);
    }
}

