/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.peerunit.rmi.tester;

import fr.inria.peerunit.Bootstrapper;
import fr.inria.peerunit.Coordinator;
import fr.inria.peerunit.GlobalVariables;
import fr.inria.peerunit.Tester;
import fr.inria.peerunit.base.AbstractTester;
import fr.inria.peerunit.base.ResultSet;
import fr.inria.peerunit.base.SingleResult;
import fr.inria.peerunit.base.TestCaseWrapper;
import fr.inria.peerunit.exception.TestException;
import fr.inria.peerunit.parser.MethodDescription;
import fr.inria.peerunit.rmi.tester.Timeout;
import fr.inria.peerunit.test.assertion.InconclusiveFailure;
import fr.inria.peerunit.util.TesterUtil;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.channels.ClosedByInterruptException;
import java.rmi.RemoteException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TesterImpl
extends AbstractTester
implements Tester,
Serializable,
Runnable {
    private static final long serialVersionUID = 1L;
    private static Logger LOG = Logger.getLogger(TesterImpl.class.getName());
    private transient Coordinator coord;
    private transient Bootstrapper bootstrapper;
    private transient boolean stop = false;
    private transient TestCaseWrapper testCase;
    private transient BlockingQueue<MethodDescription> executionQueue = new ArrayBlockingQueue<MethodDescription>(2);
    private Class<?> testCaseClass;

    public TesterImpl(Bootstrapper boot, GlobalVariables gv) throws RemoteException {
        super(gv);
        this.bootstrapper = boot;
        this.setId(this.bootstrapper.register(this));
        this.testCase = new TestCaseWrapper(this);
        this.initializeLogger();
    }

    public TesterImpl(Bootstrapper boot, GlobalVariables gv, TesterUtil tu) throws RemoteException {
        this(boot, gv);
        this.defaults = tu;
    }

    protected TesterImpl(GlobalVariables gv, int i, TesterUtil tu) {
        super(gv);
        this.defaults = tu;
        this.setId(i);
        this.testCase = new TestCaseWrapper(this);
    }

    @Override
    public void setCoordinator(Coordinator c) {
        LOG.entering("TesterImpl", "setCoordinator");
        assert (c != null) : "Null coordinator";
        this.coord = c;
    }

    @Override
    public void start() throws RemoteException {
        LOG.entering("TesterImpl", "start()");
        assert (this.coord != null) : "Null coordinator";
        this.coord.registerMethods(this, this.testCase.register(this.testCaseClass));
    }

    @Override
    public void run() {
        assert (this.coord != null) : "Null coordinator";
        LOG.entering("TesterImpl", "run()");
        while (!this.stop) {
            MethodDescription md = null;
            try {
                md = this.executionQueue.poll(this.defaults.getWaitForMethod(), TimeUnit.MILLISECONDS);
                if (md == null) continue;
                Thread invocationThread = new Thread(new Invoke(md));
                if (md.getTimeout() > 0) {
                    Thread timeoutThread = new Thread(new Timeout(invocationThread, md.getTimeout()));
                    timeoutThread.start();
                }
                invocationThread.start();
            }
            catch (InterruptedException e) {
                LOG.log(Level.SEVERE, "TesterImpl:run() - InterruptedException", e);
            }
        }
        LOG.fine("Stopping Tester ");
        try {
            this.coord.quit(this);
        }
        catch (RemoteException e) {
            LOG.log(Level.SEVERE, "Error calling Coordinator.quit()", e);
        }
    }

    public void registerTestCase(Class<?> klass) {
        LOG.entering("TesterImpl", "registerTestCase(CLass)");
        this.testCaseClass = klass;
    }

    @Override
    public synchronized void execute(MethodDescription md) throws RemoteException {
        LOG.log(Level.FINE, "Starting TesterImpl::execute(MethodDescription) with: " + md);
        try {
            this.executionQueue.put(md);
        }
        catch (InterruptedException e) {
            for (StackTraceElement each : e.getStackTrace()) {
                LOG.severe(each.toString());
            }
        }
    }

    @Override
    public void kill() {
        this.quit();
        LOG.log(Level.INFO, "Test Case finished by kill ");
    }

    private void executionFinished(ResultSet r) {
        block4: {
            assert (this.coord != null) : "Null coordinator";
            try {
                this.coord.methodExecutionFinished(r);
                if (!this.testCase.isLastMethod()) break block4;
                LOG.log(Level.FINEST, "Test Case finished");
                this.quit();
            }
            catch (RemoteException e) {
                for (StackTraceElement each : e.getStackTrace()) {
                    LOG.severe(each.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        assert (this.coord != null) : "Null coordinator";
        try {
            this.executionQueue.clear();
            this.coord.quit(this);
        }
        catch (RemoteException e) {
            LOG.log(Level.SEVERE, "Remote error during quit().", e);
        }
        finally {
            this.stop = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void invoke(MethodDescription md) {
        assert (this.testCase != null) : "Null executor";
        SingleResult result = new SingleResult(this.id, md);
        try {
            result.start();
            this.testCase.invoke(md);
            if (Thread.interrupted()) {
                result.addInconclusive(null);
                LOG.finest("Thread was interrupted.");
            }
        }
        catch (InconclusiveFailure e) {
            LOG.log(Level.WARNING, "InconclusiveFailure", (Throwable)((Object)e));
            result.addInconclusive((Throwable)((Object)e));
        }
        catch (TestException e) {
            LOG.log(Level.WARNING, "TestException", (Throwable)((Object)e));
            result.addFailure(e);
        }
        catch (AssertionError e) {
            LOG.log(Level.WARNING, "AssertionError", (Throwable)((Object)e));
            result.addFailure(e);
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, "InterruptedException", e);
            result.addInconclusive(e);
        }
        catch (ClosedByInterruptException e) {
            LOG.log(Level.WARNING, "ClosedByInterruptException", e);
            result.addInconclusive(null);
        }
        catch (Throwable e) {
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            e.printStackTrace(pw);
            pw.flush();
            writer.flush();
            LOG.log(Level.WARNING, writer.toString());
            result.addError(e);
        }
        finally {
            result.stop();
        }
        LOG.log(Level.FINEST, "Tester [" + this.id + "] Executed " + md);
        this.executionFinished(result.asResultSet());
    }

    public void cleanUp() {
        LOG.fine("Tester cleaning up.");
        this.globals = null;
        this.bootstrapper = null;
        this.coord = null;
    }

    private class Invoke
    implements Runnable {
        MethodDescription md;

        public Invoke(MethodDescription md) {
            this.md = md;
        }

        public void run() {
            TesterImpl.this.invoke(this.md);
        }
    }
}

