/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.peerunit.parser;

import fr.inria.peerunit.parser.AfterClassMethod;
import fr.inria.peerunit.parser.BeforeClassMethod;
import fr.inria.peerunit.parser.TestStepMethod;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDescription
implements Comparable<MethodDescription>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private int order;
    private int timeout;

    public MethodDescription(String name, int order, int timeout) {
        this.timeout = timeout;
        this.name = name;
        this.order = order;
    }

    public MethodDescription(TestStepMethod method) {
        this(method.method().getName(), method.order(), method.timeout());
    }

    public MethodDescription(BeforeClassMethod method) {
        this(method.method().getName(), Integer.MIN_VALUE, method.timeout());
    }

    public MethodDescription(AfterClassMethod method) {
        this(method.method().getName(), Integer.MAX_VALUE, method.timeout());
    }

    @Override
    public int compareTo(MethodDescription other) {
        if (this.order < other.order) {
            return -1;
        }
        if (this.order > other.order) {
            return 1;
        }
        return this.name.compareTo(other.name);
    }

    public String toString() {
        return String.format("Method: %s Order: %d", this.name, this.order);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MethodDescription)) {
            return false;
        }
        MethodDescription other = (MethodDescription)o;
        return this.name.equals(other.name) && this.order == other.order && this.timeout == other.timeout;
    }

    public String getName() {
        return this.name;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getOrder() {
        return this.order;
    }
}

