package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class FishingOperationsUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<FishingOperationsUIModel, FishingOperationsUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CATCHES_TAB_ENABLED = "catchesTab.enabled";
    public static final String BINDING_DELETE_FISHING_OPERATION_BUTTON_ENABLED = "deleteFishingOperationButton.enabled";
    public static final String BINDING_FISHING_OPERATION_COMBO_BOX_SELECTED_ITEM = "fishingOperationComboBox.selectedItem";
    public static final String BINDING_WARNING_CONTAINER_VISIBLE = "warningContainer.visible";
    public static final String BINDING_WARNING_LABEL_TEXT = "warningLabel.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWzU8bRxQfG7DBkOYDlUJKJEM+BBJdAioNLS0JNnbjCEgFThWVQzr2ju1J1jPb2XEwsaj6J/RPaNUee6nUW09VDz330EvUf6Gqeui16ptZe+21d22TIGHMzHu/9zm/9374C405Ai08xfW6IWpM0ioxHuw8fvyw8JQU5S5xioLakgvk/kSiKHqMJk3v3JHo+vGeUl9tqq+medXmjLAO7a09lHDkqUWcCiFSomt+jaLjrB5511t1uyZaqJ5TQajf/PN39Gvzq2+jCNVt8O4ShJIcpNWOZHQPRakp0RWw9ByvWpiVwQ1BWRn8vaDO0hZ2nANcJV+gL1F8D8VsLABMosXhQ9YYWr9uSzRXok4FLDy0icCScubkuf0JZsSS6G5JGLQkSJUIQ9akpEaNGs4JSBtFziTAG7ylZmS7cR7lbFvbiUk0VuWmQtx9TcR9BdOGjRUEf0aERMvhuHn1733QSmnZtvK49AKd9dWoqYcLlk7zhKcx250rSHOBp3hdoo0ABGJSyLtRIJgZKfjIUkuCIsC29BTulbZDNx5of25DB6hi15s47qlfdo6Rk+78pCBSSCKa9im7p0pt1tOehywSSYIBlMw1v/ylEywYSKYBHlNGhDq/6vdoqimzhwsqpf4I9KESTHrycYkLKjCJ3vKJQt4LxFQ3/uRf7U4+CKbdnpEodZ6+ykBdukN/lFNmbnrWLhexLFaI02lk5zxGmvraWNr93m1jkvG8wFS2Yr3hD3g6IGBIQ3Cr5liJt1s70fZenazDjUBv+zSB4ow2xbU5KHKMxkQNjqHdj3tZ8RCuXD6c7eJDBahv/5uZ/uPnP3/KtkjwAth+M1C0g8OBnGyhsiepMn3RZcCapNbqPra3jtGEAy1bdAl+PsCxo+Y1OAf2Lit1Q6kb97FTAYix+Mtffp35/PcRFM2ihMWxmcVKPocmZEVAFrhl1u2797RHUyfjir3hNyrRqHrA0K8NzWFnElyp8JND4qjBMSpFjdQhHfMB6fB8Kkz89u/00Y/3WimJgItzoeLttIx9hmKUWfDi9GRokn7gJJi0HVIzeZvcg+geAeHPBFNRs3k+0J/bPXmIAIc/qQCLSpRsLLrd3zM5DCWweFavKYxdHaf6lkX9xow9wDK08wVbkBIRgphH9AU060wD2C+5C3ljDkAt3dlYWVtfhsokoKRwkFPPEY1gU83SJ9i2LVrURnf0NdBFI/wpuxDGQS+/utpGUSUUjE3RtU22z0iVM1qUaCssKU3AAMI2qp72pOTcylM7T+rQVe+9ApaEKe/VaCu8Rn0g+pQvdNwMUb44YarToBjvuG/IKBPpNjsxu1GXlpMLHyVZzVIv7dUKH3OnW0jtM4Nrvxs4HbvK76/Y+wPSHTxw/UXbHli0EJTwuvUd9INKNwI97jTLlJOkKtHNYeoHuRlvcvkpDBEnRLAd953wuEuUWGbPeZ+AQ1e0QcEC0cefU4dCo0K7NxbcQKmjZ3fGbWAdW6KAi8/KgtcYNPSibkg9bPCJhO3e4mJp/d2NleT62uZKcnNzOdDLnn1qiFKMSt1o19sl+BRb1NRBZoTgYp84Di6TpZ73EG9aU/syF6bal9c9v1t7l3tjZKq2PE3p70sQxdrtlaT+ExyHb+cbFEOkkwk+Pg8TJG/dSobUI8irju1niKpPV7igL1QhrB2LlllV73oXG+7OaqQzB/nM4ZmX/9CHTmEDMxjvbdbWAwhytXMFHCJ/MQufcrCP3vgQCo+TBcpMsLXdAx1Rn4khEMfVcpM/tfUa8X0wzsxAHHX8XR+EuddGWACE/wGU8E+5HBAAAA==";
    private static final Log log = LogFactory.getLog(FishingOperationsUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected TabInfo catchesTab;
    protected EditCatchesUI catchesTabContent;
    protected JButton deleteFishingOperationButton;
    protected BeanFilterableComboBox<FishingOperation> fishingOperationComboBox;
    protected TabInfo fishingOperationTab;
    protected EditFishingOperationUI fishingOperationTabContent;
    protected FishingOperationsUI fishingOperationsTopPanel = this;
    protected final FishingOperationsUIHandler handler = createHandler();
    protected FishingOperationsUIModel model;
    protected JButton newFishingOperationButton;
    protected JLabel noTraitPane;
    protected JTabbedPane tabPane;
    protected Table topPanel;
    protected JPanel warningContainer;
    protected JLabel warningLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FishingOperationsUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public FishingOperationsUI() {
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishingOperationsUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishingOperationsUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishingOperationsUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public TabInfo getCatchesTab() {
        return catchesTab;
    }

    public EditCatchesUI getCatchesTabContent() {
        return catchesTabContent;
    }

    public JButton getDeleteFishingOperationButton() {
        return deleteFishingOperationButton;
    }

    public BeanFilterableComboBox<FishingOperation> getFishingOperationComboBox() {
        return fishingOperationComboBox;
    }

    public TabInfo getFishingOperationTab() {
        return fishingOperationTab;
    }

    public EditFishingOperationUI getFishingOperationTabContent() {
        return fishingOperationTabContent;
    }

    public FishingOperationsUIHandler getHandler() {
        return handler;
    }

    public FishingOperationsUIModel getModel() {
        return model;
    }

    public JButton getNewFishingOperationButton() {
        return newFishingOperationButton;
    }

    public JLabel getNoTraitPane() {
        return noTraitPane;
    }

    public JTabbedPane getTabPane() {
        return tabPane;
    }

    public Table getTopPanel() {
        return topPanel;
    }

    public JPanel getWarningContainer() {
        return warningContainer;
    }

    public JLabel getWarningLabel() {
        return warningLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFishingOperationsTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(topPanel, BorderLayout.NORTH);
        add(tabPane);
        add(noTraitPane, BorderLayout.CENTER);
    }

    protected void addChildrenToTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        tabPane.add(fishingOperationTabContent);
        tabPane.add(catchesTabContent);
        fishingOperationTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 0));
        tabPane.setTitleAt(0, t("tutti.label.tab.fishingOperation"));
        catchesTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 1));
        tabPane.setTitleAt(1, t("tutti.label.tab.catches"));
    }

    protected void addChildrenToTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        topPanel.add(fishingOperationComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        topPanel.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(3, 3, 3, 3), 0, 0));
        topPanel.add(warningContainer, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToWarningContainer() {
        if (!allComponentsCreated) {
            return;
        }
        warningContainer.add(warningLabel, BorderLayout.CENTER);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.fishingOperations.help"));
    }

    protected void createCatchesTab() {
        $objectMap.put("catchesTab", catchesTab = new TabInfo());
        
        catchesTab.setTitle(t("tutti.label.tab.catches"));
    }

    protected void createCatchesTabContent() {
        $objectMap.put("catchesTabContent", catchesTabContent = new EditCatchesUI(this));
        
        catchesTabContent.setName("catchesTabContent");
    }

    protected void createDeleteFishingOperationButton() {
        $objectMap.put("deleteFishingOperationButton", deleteFishingOperationButton = new JButton());
        
        deleteFishingOperationButton.setName("deleteFishingOperationButton");
        deleteFishingOperationButton.setToolTipText(t("tutti.fishingOperations.action.deleteFishingOperation.tip"));
        deleteFishingOperationButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.DeleteFishingOperationAction.class);
        deleteFishingOperationButton.putClientProperty("help", "tutti.fishingOperations.action.deleteFishingOperation.help");
    }

    protected void createFishingOperationComboBox() {
        $objectMap.put("fishingOperationComboBox", fishingOperationComboBox = new BeanFilterableComboBox<FishingOperation>(this));
        
        fishingOperationComboBox.setName("fishingOperationComboBox");
        fishingOperationComboBox.setProperty("selectedFishingOperation");
        fishingOperationComboBox.setShowReset(true);
        fishingOperationComboBox.putClientProperty("help", "tutti.fishingOperations.field.fishingOperation.help");
    }

    protected void createFishingOperationTab() {
        $objectMap.put("fishingOperationTab", fishingOperationTab = new TabInfo());
        
        fishingOperationTab.setTitle(t("tutti.label.tab.fishingOperation"));
    }

    protected void createFishingOperationTabContent() {
        $objectMap.put("fishingOperationTabContent", fishingOperationTabContent = new EditFishingOperationUI(this));
        
        fishingOperationTabContent.setName("fishingOperationTabContent");
    }

    protected FishingOperationsUIHandler createHandler() {
        return new FishingOperationsUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(FishingOperationsUIModel.class));
    }

    protected void createNewFishingOperationButton() {
        $objectMap.put("newFishingOperationButton", newFishingOperationButton = new JButton());
        
        newFishingOperationButton.setName("newFishingOperationButton");
        newFishingOperationButton.setToolTipText(t("tutti.fishingOperations.action.newFishingOperation.tip"));
        newFishingOperationButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.NewFishingOperationAction.class);
        newFishingOperationButton.putClientProperty("help", "tutti.fishingOperations.action.newFishingOperation.help");
    }

    protected void createNoTraitPane() {
        $objectMap.put("noTraitPane", noTraitPane = new JLabel());
        
        noTraitPane.setName("noTraitPane");
        noTraitPane.setText(t("tutti.fishingOperations.info.no.fishingOperation.selected"));
    }

    protected void createTabPane() {
        $objectMap.put("tabPane", tabPane = new JTabbedPane());
        
        tabPane.setName("tabPane");
    }

    protected void createTopPanel() {
        $objectMap.put("topPanel", topPanel = new Table());
        
        topPanel.setName("topPanel");
    }

    protected void createWarningContainer() {
        $objectMap.put("warningContainer", warningContainer = new JPanel());
        
        warningContainer.setName("warningContainer");
        warningContainer.setLayout(new BorderLayout(10, 10));
    }

    protected void createWarningLabel() {
        $objectMap.put("warningLabel", warningLabel = new JLabel());
        
        warningLabel.setName("warningLabel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToFishingOperationsTopPanel();
        addChildrenToTopPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(newFishingOperationButton);
        $JPanel0.add(deleteFishingOperationButton);
        addChildrenToWarningContainer();
        addChildrenToTabPane();
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        fishingOperationComboBox.setBeanType(FishingOperation.class);
        fishingOperationComboBox.setBean(model);
        newFishingOperationButton.setPreferredSize(new Dimension(75,12));
        newFishingOperationButton.setIcon(SwingUtil.createActionIcon("add"));
        newFishingOperationButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.fishingOperations.action.newFishingOperation.mnemonic"),'Z'));
        deleteFishingOperationButton.setPreferredSize(new Dimension(75,12));
        deleteFishingOperationButton.setIcon(SwingUtil.createActionIcon("delete"));
        warningContainer.setBackground(new java.awt.Color(245, 218, 88));
        warningLabel.setIcon(SwingUtil.createActionIcon("warning"));
        warningLabel.setBorder(new javax.swing.border.EmptyBorder(5, 10, 5, 10));
        noTraitPane.setHorizontalAlignment(JLabel.CENTER);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, fishingOperationsTopPanel, "tutti.fishingOperations.help");
        registerHelpId(_broker, fishingOperationComboBox, "tutti.fishingOperations.field.fishingOperation.help");
        registerHelpId(_broker, newFishingOperationButton, "tutti.fishingOperations.action.newFishingOperation.help");
        registerHelpId(_broker, deleteFishingOperationButton, "tutti.fishingOperations.action.deleteFishingOperation.help");
        _broker.prepareUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("fishingOperationsTopPanel", fishingOperationsTopPanel);
        createModel();
        createBroker();
        createTopPanel();
        createFishingOperationComboBox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout());
        createNewFishingOperationButton();
        createDeleteFishingOperationButton();
        createWarningContainer();
        createWarningLabel();
        createTabPane();
        createFishingOperationTabContent();
        createCatchesTabContent();
        createNoTraitPane();
        createFishingOperationTab();
        createCatchesTab();
        // inline creation of fishingOperationsTopPanel
        setName("fishingOperationsTopPanel");
        setLayout(new BorderLayout());
        fishingOperationsTopPanel.putClientProperty("help", "tutti.fishingOperations.help");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedFishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationComboBox.setSelectedItem(model.getSelectedFishingOperation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedFishingOperation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DELETE_FISHING_OPERATION_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedFishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    deleteFishingOperationButton.setEnabled(model.getSelectedFishingOperation() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedFishingOperation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WARNING_CONTAINER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    warningContainer.setVisible(!model.isCatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WARNING_LABEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("validationErrorMessage", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    warningLabel.setText(t(model.getValidationErrorMessage()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("validationErrorMessage", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCHES_TAB_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedFishingOperation", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("catchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchesTab.setEnabled(model.getSelectedFishingOperation() != null && model.isCatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedFishingOperation", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("catchEnabled", this);
                }
            }
        });
    }

}