package fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.create;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import static org.nuiton.i18n.I18n.t;

public class CreateMarineLitterBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<CreateMarineLitterBatchUIModel, CreateMarineLitterBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MARINE_LITTER_CATEGORY_COMBO_BOX_SELECTED_ITEM = "marineLitterCategoryComboBox.selectedItem";
    public static final String BINDING_MARINE_LITTER_NUMBER_FIELD_NUMBER_VALUE = "marineLitterNumberField.numberValue";
    public static final String BINDING_MARINE_LITTER_SIZE_CATEGORY_COMBO_BOX_SELECTED_ITEM = "marineLitterSizeCategoryComboBox.selectedItem";
    public static final String BINDING_MARINE_LITTER_WEIGHT_FIELD_NUMBER_VALUE = "marineLitterWeightField.numberValue";
    public static final String BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED = "saveAndCloseButton.enabled";
    public static final String BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED = "saveAndContinueButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(CreateMarineLitterBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected Table configurationPanel;
    protected CreateMarineLitterBatchUI createMarineLitterBatchTopPanel = this;
    protected final CreateMarineLitterBatchUIHandler handler = createHandler();
    @ValidatorField( validatorId = "validator",  propertyName = "marineLitterCategory",  editorName = "marineLitterCategoryComboBox")
    protected BeanFilterableComboBox<CaracteristicQualitativeValue> marineLitterCategoryComboBox;
    protected JLabel marineLitterCategoryLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "number",  editorName = "marineLitterNumberField")
    protected NumberEditor marineLitterNumberField;
    protected JLabel marineLitterNumberLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "marineLitterSizeCategory",  editorName = "marineLitterSizeCategoryComboBox")
    protected BeanFilterableComboBox<CaracteristicQualitativeValue> marineLitterSizeCategoryComboBox;
    protected JLabel marineLitterSizeCategoryLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "weight",  editorName = "marineLitterWeightField")
    protected NumberEditor marineLitterWeightField;
    protected JLabel marineLitterWeightLabel;
    protected CreateMarineLitterBatchUIModel model;
    protected JButton saveAndCloseButton;
    protected JButton saveAndContinueButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<CreateMarineLitterBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateMarineLitterBatchUI(EditCatchesUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public CreateMarineLitterBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateMarineLitterBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateMarineLitterBatchUI() {
        $initialize();
    }

    public CreateMarineLitterBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateMarineLitterBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateMarineLitterBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateMarineLitterBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateMarineLitterBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__saveAndCloseButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveAndClose();
    }

    public void doActionPerformed__on__saveAndContinueButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveAndContinue();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public CreateMarineLitterBatchUIHandler getHandler() {
        return handler;
    }

    public BeanFilterableComboBox<CaracteristicQualitativeValue> getMarineLitterCategoryComboBox() {
        return marineLitterCategoryComboBox;
    }

    public JLabel getMarineLitterCategoryLabel() {
        return marineLitterCategoryLabel;
    }

    public NumberEditor getMarineLitterNumberField() {
        return marineLitterNumberField;
    }

    public JLabel getMarineLitterNumberLabel() {
        return marineLitterNumberLabel;
    }

    public BeanFilterableComboBox<CaracteristicQualitativeValue> getMarineLitterSizeCategoryComboBox() {
        return marineLitterSizeCategoryComboBox;
    }

    public JLabel getMarineLitterSizeCategoryLabel() {
        return marineLitterSizeCategoryLabel;
    }

    public NumberEditor getMarineLitterWeightField() {
        return marineLitterWeightField;
    }

    public JLabel getMarineLitterWeightLabel() {
        return marineLitterWeightLabel;
    }

    public CreateMarineLitterBatchUIModel getModel() {
        return model;
    }

    public JButton getSaveAndCloseButton() {
        return saveAndCloseButton;
    }

    public JButton getSaveAndContinueButton() {
        return saveAndContinueButton;
    }

    public SwingValidator<CreateMarineLitterBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(marineLitterCategoryLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(marineLitterCategoryComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(marineLitterSizeCategoryLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(marineLitterSizeCategoryComboBox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(marineLitterNumberLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(marineLitterNumberField), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(marineLitterWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(marineLitterWeightField), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCreateMarineLitterBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.createMarineLitterBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.createMarineLitterBatch.action.cancel"));
        cancelButton.setToolTipText(t("tutti.createMarineLitterBatch.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
        cancelButton.putClientProperty("help", "tutti.createMarineLitterBatch.action.cancel.help");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected CreateMarineLitterBatchUIHandler createHandler() {
        return new CreateMarineLitterBatchUIHandler();
    }

    protected void createMarineLitterCategoryComboBox() {
        $objectMap.put("marineLitterCategoryComboBox", marineLitterCategoryComboBox = new BeanFilterableComboBox<CaracteristicQualitativeValue>(this));
        
        marineLitterCategoryComboBox.setName("marineLitterCategoryComboBox");
        marineLitterCategoryComboBox.setProperty("marineLitterCategory");
        marineLitterCategoryComboBox.setShowReset(true);
        marineLitterCategoryComboBox.putClientProperty("help", "tutti.createMarineLitterBatch.field.marineLitterCategory.help");
    }

    protected void createMarineLitterCategoryLabel() {
        $objectMap.put("marineLitterCategoryLabel", marineLitterCategoryLabel = new JLabel());
        
        marineLitterCategoryLabel.setName("marineLitterCategoryLabel");
        marineLitterCategoryLabel.setText(t("tutti.createMarineLitterBatch.field.marineLitterCategory"));
        marineLitterCategoryLabel.setToolTipText(t("tutti.createMarineLitterBatch.field.marineLitterCategory.tip"));
        marineLitterCategoryLabel.putClientProperty("help", "tutti.createMarineLitterBatch.field.marineLitterCategory.help");
    }

    protected void createMarineLitterNumberField() {
        $objectMap.put("marineLitterNumberField", marineLitterNumberField = new NumberEditor(this));
        
        marineLitterNumberField.setName("marineLitterNumberField");
        marineLitterNumberField.setProperty("number");
        marineLitterNumberField.setShowReset(true);
        marineLitterNumberField.putClientProperty("help", "tutti.createMarineLitterBatch.field.number.help");
    }

    protected void createMarineLitterNumberLabel() {
        $objectMap.put("marineLitterNumberLabel", marineLitterNumberLabel = new JLabel());
        
        marineLitterNumberLabel.setName("marineLitterNumberLabel");
        marineLitterNumberLabel.setText(t("tutti.createMarineLitterBatch.field.number"));
        marineLitterNumberLabel.setToolTipText(t("tutti.createMarineLitterBatch.field.number.tip"));
        marineLitterNumberLabel.putClientProperty("help", "tutti.createMarineLitterBatch.field.number.help");
    }

    protected void createMarineLitterSizeCategoryComboBox() {
        $objectMap.put("marineLitterSizeCategoryComboBox", marineLitterSizeCategoryComboBox = new BeanFilterableComboBox<CaracteristicQualitativeValue>(this));
        
        marineLitterSizeCategoryComboBox.setName("marineLitterSizeCategoryComboBox");
        marineLitterSizeCategoryComboBox.setProperty("marineLitterSizeCategory");
        marineLitterSizeCategoryComboBox.setShowReset(true);
        marineLitterSizeCategoryComboBox.putClientProperty("help", "tutti.createMarineLitterBatch.field.marineLitterSizeCategory.help");
    }

    protected void createMarineLitterSizeCategoryLabel() {
        $objectMap.put("marineLitterSizeCategoryLabel", marineLitterSizeCategoryLabel = new JLabel());
        
        marineLitterSizeCategoryLabel.setName("marineLitterSizeCategoryLabel");
        marineLitterSizeCategoryLabel.setText(t("tutti.createMarineLitterBatch.field.marineLitterSizeCategory"));
        marineLitterSizeCategoryLabel.setToolTipText(t("tutti.createMarineLitterBatch.field.marineLitterSizeCategory.tip"));
        marineLitterSizeCategoryLabel.putClientProperty("help", "tutti.createMarineLitterBatch.field.marineLitterSizeCategory.help");
    }

    protected void createMarineLitterWeightField() {
        $objectMap.put("marineLitterWeightField", marineLitterWeightField = new NumberEditor(this));
        
        marineLitterWeightField.setName("marineLitterWeightField");
        marineLitterWeightField.setProperty("weight");
        marineLitterWeightField.setShowReset(true);
        marineLitterWeightField.putClientProperty("help", "tutti.createMarineLitterBatch.field.weight.help");
    }

    protected void createMarineLitterWeightLabel() {
        $objectMap.put("marineLitterWeightLabel", marineLitterWeightLabel = new JLabel());
        
        marineLitterWeightLabel.setName("marineLitterWeightLabel");
        marineLitterWeightLabel.setText(t("tutti.createMarineLitterBatch.field.weight"));
        marineLitterWeightLabel.setToolTipText(t("tutti.createMarineLitterBatch.field.weight.tip"));
        marineLitterWeightLabel.putClientProperty("help", "tutti.createMarineLitterBatch.field.weight.help");
        marineLitterWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getMarineLitterWeightUnit());
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CreateMarineLitterBatchUIModel.class));
    }

    protected void createSaveAndCloseButton() {
        $objectMap.put("saveAndCloseButton", saveAndCloseButton = new JButton());
        
        saveAndCloseButton.setName("saveAndCloseButton");
        saveAndCloseButton.setText(t("tutti.createMarineLitterBatch.action.saveAndClose"));
        saveAndCloseButton.setToolTipText(t("tutti.createMarineLitterBatch.action.saveAndClose.tip"));
        saveAndCloseButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveAndCloseButton"));
        saveAndCloseButton.putClientProperty("help", "tutti.createMarineLitterBatch.action.saveAndClose.help");
    }

    protected void createSaveAndContinueButton() {
        $objectMap.put("saveAndContinueButton", saveAndContinueButton = new JButton());
        
        saveAndContinueButton.setName("saveAndContinueButton");
        saveAndContinueButton.setText(t("tutti.createMarineLitterBatch.action.saveAndContinue"));
        saveAndContinueButton.setToolTipText(t("tutti.createMarineLitterBatch.action.saveAndContinue.tip"));
        saveAndContinueButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveAndContinueButton"));
        saveAndContinueButton.putClientProperty("help", "tutti.createMarineLitterBatch.action.saveAndContinue.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(CreateMarineLitterBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCreateMarineLitterBatchTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveAndContinueButton);
        $JPanel0.add(saveAndCloseButton);
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 25 property setters
        marineLitterCategoryComboBox.setBeanType(CaracteristicQualitativeValue.class);
        marineLitterSizeCategoryComboBox.setBeanType(CaracteristicQualitativeValue.class);
        marineLitterCategoryLabel.setLabelFor(marineLitterCategoryComboBox);
        marineLitterCategoryComboBox.setBean(model);
        marineLitterSizeCategoryLabel.setLabelFor(marineLitterSizeCategoryComboBox);
        marineLitterSizeCategoryComboBox.setBean(model);
        marineLitterNumberLabel.setLabelFor(marineLitterNumberField);
        marineLitterNumberField.setBean(model);
        marineLitterNumberField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        marineLitterNumberField.setNumberPattern(DECIMAL3_PATTERN);
        marineLitterNumberField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        marineLitterNumberField.setNumberType(Float.class);
        marineLitterWeightLabel.setLabelFor(marineLitterWeightField);
        marineLitterWeightField.setBean(model);
        marineLitterWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        marineLitterWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        marineLitterWeightField.setNumberType(Float.class);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createMarineLitterBatch.action.cancel.mnemonic"),'Z'));
        saveAndContinueButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndContinueButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createMarineLitterBatch.action.saveAndContinue.mnemonic"),'Z'));
        saveAndCloseButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndCloseButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.createMarineLitterBatch.action.saveAndClose.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, createMarineLitterBatchTopPanel, "tutti.createMarineLitterBatch.help");
        registerHelpId(_broker, marineLitterCategoryLabel, "tutti.createMarineLitterBatch.field.marineLitterCategory.help");
        registerHelpId(_broker, marineLitterCategoryComboBox, "tutti.createMarineLitterBatch.field.marineLitterCategory.help");
        registerHelpId(_broker, marineLitterSizeCategoryLabel, "tutti.createMarineLitterBatch.field.marineLitterSizeCategory.help");
        registerHelpId(_broker, marineLitterSizeCategoryComboBox, "tutti.createMarineLitterBatch.field.marineLitterSizeCategory.help");
        registerHelpId(_broker, marineLitterNumberLabel, "tutti.createMarineLitterBatch.field.number.help");
        registerHelpId(_broker, marineLitterNumberField, "tutti.createMarineLitterBatch.field.number.help");
        registerHelpId(_broker, marineLitterWeightLabel, "tutti.createMarineLitterBatch.field.weight.help");
        registerHelpId(_broker, marineLitterWeightField, "tutti.createMarineLitterBatch.field.weight.help");
        registerHelpId(_broker, cancelButton, "tutti.createMarineLitterBatch.action.cancel.help");
        registerHelpId(_broker, saveAndContinueButton, "tutti.createMarineLitterBatch.action.saveAndContinue.help");
        registerHelpId(_broker, saveAndCloseButton, "tutti.createMarineLitterBatch.action.saveAndClose.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("createMarineLitterBatchTopPanel", createMarineLitterBatchTopPanel);
        createModel();
        createValidator();
        createBroker();
        createConfigurationPanel();
        createMarineLitterCategoryLabel();
        createMarineLitterCategoryComboBox();
        createMarineLitterSizeCategoryLabel();
        createMarineLitterSizeCategoryComboBox();
        createMarineLitterNumberLabel();
        createMarineLitterNumberField();
        createMarineLitterWeightLabel();
        createMarineLitterWeightField();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveAndContinueButton();
        createSaveAndCloseButton();
        // inline creation of createMarineLitterBatchTopPanel
        setName("createMarineLitterBatchTopPanel");
        setLayout(new BorderLayout());
        createMarineLitterBatchTopPanel.putClientProperty("help", "tutti.createMarineLitterBatch.help");
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("marineLitterCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterCategoryComboBox.setSelectedItem(model.getMarineLitterCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("marineLitterCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_SIZE_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("marineLitterSizeCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterSizeCategoryComboBox.setSelectedItem(model.getMarineLitterSizeCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("marineLitterSizeCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_NUMBER_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("number", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterNumberField.setNumberValue(model.getNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("number", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_WEIGHT_FIELD_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("weight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterWeightField.setNumberValue(model.getWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("weight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndContinueButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndCloseButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}