/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.updater;

import fr.ifremer.tutti.ui.swing.updater.DeleteHelper;
import fr.ifremer.tutti.ui.swing.updater.UpdateModule;
import fr.ifremer.tutti.ui.swing.updater.UpdateModuleConfiguration;
import fr.ifremer.tutti.ui.swing.updater.UpdaterFileSystemPathes;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JOptionPane;

public class Updater {
    public static final int NORMAL_EXIT_CODE = 0;
    public static final int ERROR_EXIT_CODE = 1;
    public static final int RUNTIME_UPDATE_EXIT_CODE = 90;
    private final UpdaterFileSystemPathes pathHelper;

    public static void main(String ... args) {
        Updater updater = new Updater();
        int exitCode = updater.execute();
        System.exit(exitCode);
    }

    public Updater() {
        Path baseDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        if (!baseDir.isAbsolute()) {
            baseDir = baseDir.toFile().getAbsoluteFile().toPath();
        }
        System.out.println(String.format("Basedir: %s", baseDir));
        this.pathHelper = new UpdaterFileSystemPathes(baseDir);
    }

    public int execute() {
        int exitCode;
        System.out.println("updater started at " + new Date().toString());
        try {
            this.beforeUpdateRuntimeModules();
            boolean runtimeUpdate = this.updateRuntimeModules();
            if (runtimeUpdate) {
                this.afterUpdateRuntimeModules();
                exitCode = 90;
            } else {
                this.updateNoneRuntimeModules();
                this.cleanFiles();
                exitCode = 0;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            exitCode = 1;
        }
        System.out.println("updater ended   at " + new Date().toString() + " with exit code: " + exitCode);
        return exitCode;
    }

    protected void beforeUpdateRuntimeModules() throws IOException {
        Path runtimeUpdater = this.pathHelper.getUpdaterScriptPath();
        Files.deleteIfExists(runtimeUpdater);
    }

    protected boolean updateRuntimeModules() throws Exception {
        boolean mustUpdateRuntime = false;
        for (UpdateModule updateModule : UpdateModule.values()) {
            boolean updateFound;
            UpdateModuleConfiguration moduleConfiguration = updateModule.getModuleConfiguration();
            if (!moduleConfiguration.isManageByUpdater() || !moduleConfiguration.isRuntime() || !(updateFound = this.updateRuntimeModule(updateModule))) continue;
            mustUpdateRuntime = true;
        }
        return mustUpdateRuntime;
    }

    protected void afterUpdateRuntimeModules() throws IOException {
        Path runtimeUpdater = this.pathHelper.getUpdaterScriptPath();
        URL resource = this.getClass().getResource("/" + runtimeUpdater.getFileName());
        try (InputStream stream = resource.openStream();){
            Path tempFile = Files.createTempFile(runtimeUpdater.getFileName().toFile().getName(), null, new FileAttribute[0]);
            Files.copy(stream, tempFile, StandardCopyOption.REPLACE_EXISTING);
            tempFile.toFile().deleteOnExit();
            Charset charset = Charset.forName("UTF-8");
            String content = new String(Files.readAllBytes(tempFile), charset);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss");
            content = content.replaceFirst("~~BACKUP_DATE~~", dateFormat.format(new Date()));
            Files.write(runtimeUpdater, content.getBytes(), new OpenOption[0]);
        }
        this.pathHelper.makeExecutable(runtimeUpdater);
        String message = String.format("Une mise \u00e0 jour de l'ex\u00e9cutable est disponible.\nVous devez lancer le script '%s' en double cliquant dessus dans un explorateur de fichier.\nLe script se trouve dans le dossier %s.", runtimeUpdater.getFileName(), runtimeUpdater.toFile().getParentFile());
        System.out.println(message);
        JOptionPane.showMessageDialog(null, message);
    }

    protected void updateNoneRuntimeModules() throws IOException {
        for (UpdateModule updateModule : UpdateModule.values()) {
            UpdateModuleConfiguration moduleConfiguration = updateModule.getModuleConfiguration();
            if (!moduleConfiguration.isManageByUpdater() || moduleConfiguration.isRuntime()) continue;
            this.updateNoneRuntimeModule(updateModule);
        }
    }

    protected boolean updateRuntimeModule(UpdateModule updateModule) throws IOException {
        boolean moduleExist = this.pathHelper.isModuleExists(updateModule);
        boolean updateModuleExist = this.pathHelper.isUpdateModuleExists(updateModule);
        String oldVersion = moduleExist ? this.pathHelper.getModuleVersion(updateModule) : "None";
        String moduleNameStr = updateModule.getModuleLoggerName();
        System.out.println(String.format("%s Current version: %s", moduleNameStr, oldVersion));
        if (updateModuleExist) {
            String newVersion = this.pathHelper.getUpdateModuleVersion(updateModule);
            System.out.println(String.format("%s New version detected %s", moduleNameStr, newVersion));
            this.pathHelper.removeOlderBackup(updateModule);
        } else {
            System.out.println(String.format("%s No update found", moduleNameStr));
        }
        return updateModuleExist;
    }

    protected void updateNoneRuntimeModule(UpdateModule updateModule) throws IOException {
        boolean moduleExist = this.pathHelper.isModuleExists(updateModule);
        boolean updateModuleExist = this.pathHelper.isUpdateModuleExists(updateModule);
        String oldVersion = moduleExist ? this.pathHelper.getModuleVersion(updateModule) : "None";
        String moduleNameStr = updateModule.getModuleLoggerName();
        System.out.println(String.format("%s Current version: %s", moduleNameStr, oldVersion));
        if (updateModuleExist) {
            String newVersion = this.pathHelper.getUpdateModuleVersion(updateModule);
            System.out.println(String.format("%s New version detected %s", moduleNameStr, newVersion));
            this.pathHelper.removeOlderBackup(updateModule);
            if (moduleExist) {
                this.pathHelper.backupModule(updateModule, oldVersion);
            }
            System.out.println(String.format("%s Install new version %s", moduleNameStr, newVersion));
            Path modulePath = this.pathHelper.getModulePath(updateModule);
            Path moduleNewPath = this.pathHelper.getUpdateModulePath(updateModule);
            try {
                this.pathHelper.move(moduleNewPath, modulePath);
            }
            catch (IOException e) {
                String message = String.format("La mise \u00e0 jour du module '%s' a \u00e9chou\u00e9e.\nVeuillez contacter un administrateur.", new Object[]{updateModule});
                System.out.println(message);
                JOptionPane.showMessageDialog(null, message);
                e.printStackTrace();
            }
        } else {
            System.out.println(String.format("%s No update found", moduleNameStr));
        }
    }

    protected void cleanFiles() throws IOException {
        this.pathHelper.cleanObsoleteFiles();
        DeleteHelper.deleteDirectory(this.pathHelper.getUpdateDirectory());
    }
}

