/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.queue;

import fr.ifremer.isisfish.simulator.launcher.SimulationExecutor;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JToggleButton;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PauseButtonModel
extends JToggleButton.ToggleButtonModel
implements PropertyChangeListener,
ItemListener {
    private static Log log = LogFactory.getLog(PauseButtonModel.class);
    private static final long serialVersionUID = 1L;
    protected SimulationService service;
    private static final String servicePropertyName = "autoLaunch";
    private static final String executorPropertyName = "pause";

    public PauseButtonModel(SimulationService service) {
        this.service = service;
        boolean b = service.isAutoLaunch();
        service.addPropertyChangeListener(servicePropertyName, this);
        for (SimulationExecutor e : service.getSimulationExecutors()) {
            b = b && !e.isPause();
            e.addPropertyChangeListener(executorPropertyName, this);
        }
        this.setSelected(b);
        this.addItemListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        boolean b = (Boolean)event.getNewValue();
        this.setSelected(b);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        boolean b = event.getStateChange() == 1;
        this.service.setAutoLaunch(b);
        if (b) {
            for (SimulationExecutor e : this.service.getSimulationExecutors()) {
                e.resume();
            }
        }
    }
}

