/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.rule;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityUtils;
import fr.ifremer.isisfish.ui.simulator.RuleChooser;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Resource;

public class RuleParametersFactorTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -1655744662816030649L;
    private static Log log = LogFactory.getLog(RuleParametersFactorTableCellRenderer.class);
    protected RuleChooser ruleChooser;
    protected Rule rule;

    public RuleParametersFactorTableCellRenderer(RuleChooser ruleChooser, Rule rule) {
        this.ruleChooser = ruleChooser;
        this.rule = rule;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp;
        block4: {
            comp = null;
            String paramName = (String)value;
            try {
                Class paramType = RuleStorage.getParameterType(this.rule, paramName);
                boolean canBeFactor = SensitivityUtils.canBeFactor(paramType);
                if (canBeFactor) {
                    JButton button = new JButton(Resource.getIcon((String)"/icons/fatcow/brick_add.png"));
                    button.setToolTipText(I18n.t((String)"isisfish.sensitivity.ruleparameterfactortip", (Object[])new Object[0]));
                    comp = button;
                }
            }
            catch (IsisFishException ex) {
                if (!log.isWarnEnabled()) break block4;
                log.warn((Object)"Can't get value type", (Throwable)ex);
            }
        }
        if (comp == null) {
            comp = super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
        }
        return comp;
    }
}

