/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.rule;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityUtils;
import fr.ifremer.isisfish.ui.sensitivity.wizard.FactorWizardHandler;
import fr.ifremer.isisfish.ui.sensitivity.wizard.FactorWizardUI;
import fr.ifremer.isisfish.ui.simulator.RuleChooser;
import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Resource;

public class RuleParametersFactorTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = -1655744662816030649L;
    private static Log log = LogFactory.getLog(RuleParametersFactorTableCellEditor.class);
    protected RuleChooser ruleChooser;
    protected Rule rule;

    public RuleParametersFactorTableCellEditor(RuleChooser ruleChooser, Rule rule) {
        this.ruleChooser = ruleChooser;
        this.rule = rule;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JComponent comp;
        block4: {
            comp = null;
            String paramName = (String)value;
            try {
                Class paramType = RuleStorage.getParameterType(this.rule, paramName);
                boolean canBeFactor = SensitivityUtils.canBeFactor(paramType);
                if (canBeFactor) {
                    JButton button = new JButton(Resource.getIcon((String)"/icons/fatcow/brick_add.png"));
                    button.addActionListener(e -> {
                        this.cancelCellEditing();
                        this.addRuleParameterFactor(this.ruleChooser, this.rule, paramName);
                    });
                    button.setToolTipText(I18n.t((String)"isisfish.sensitivity.ruleparameterfactortip", (Object[])new Object[0]));
                    comp = button;
                }
            }
            catch (IsisFishException ex) {
                if (!log.isWarnEnabled()) break block4;
                log.warn((Object)"Can't get value type", (Throwable)ex);
            }
        }
        if (comp == null) {
            comp = new JLabel();
        }
        return comp;
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    public void addRuleParameterFactor(RuleChooser ruleChooser, Rule rule, String paramName) {
        int index = ruleChooser.getRulesList().indexOf(rule);
        String factorPath = "parameters.rule." + index + ".parameter." + paramName;
        Factor factor = new Factor(I18n.t((String)"isisfish.sensitivity.ruleparameterfactorname", (Object[])new Object[]{rule.getClass().getSimpleName(), paramName}));
        factor.setPath(factorPath);
        FactorWizardUI factorWizardUI = new FactorWizardUI((JAXXContext)ruleChooser);
        FactorWizardHandler handler = factorWizardUI.getHandler();
        handler.initExistingFactor(factorWizardUI, factor);
        factorWizardUI.pack();
        factorWizardUI.setLocationRelativeTo((Component)((Object)ruleChooser));
        factorWizardUI.setVisible(true);
    }
}

