/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.sensitivity;

import jdistlib.Binomial;
import jdistlib.Cauchy;
import jdistlib.ChiSquare;
import jdistlib.Exponential;
import jdistlib.F;
import jdistlib.Gamma;
import jdistlib.Geometric;
import jdistlib.HyperGeometric;
import jdistlib.Normal;
import jdistlib.Uniform;
import org.nuiton.i18n.I18n;

public enum Distribution {
    QUNIFPC(I18n.t((String)"QUnif %", (Object[])new Object[0]), "runif", Uniform.class, new DistributionParam("reference", I18n.t((String)"Reference value", (Object[])new Object[0]), true), new DistributionParam("coefficient", I18n.t((String)"Coefficient", (Object[])new Object[0]), false)),
    QUNIFMM(I18n.t((String)"QUnif Min/Max", (Object[])new Object[0]), "runif", Uniform.class, new DistributionParam("min", I18n.t((String)"Minimum value", (Object[])new Object[0]), true), new DistributionParam("max", I18n.t((String)"Maximum value", (Object[])new Object[0]), true)),
    DBINOM(I18n.t((String)"Dbimom", (Object[])new Object[0]), "rbinom", Binomial.class, new DistributionParam("size", I18n.t((String)"number of trials (zero or more)", (Object[])new Object[0])), new DistributionParam("prob", I18n.t((String)"probability of success on each trial", (Object[])new Object[0]))),
    DCAUCHY(I18n.t((String)"dcauchy", (Object[])new Object[0]), "rcauchy", Cauchy.class, new DistributionParam("location", I18n.t((String)"location and scale parameters. (location = 0, scale = 1)", (Object[])new Object[0])), new DistributionParam("scale", I18n.t((String)"location and scale parameters. (location = 0, scale = 1)", (Object[])new Object[0]))),
    DCHISQ(I18n.t((String)"dchisq", (Object[])new Object[0]), "rchisq", ChiSquare.class, new DistributionParam("df", I18n.t((String)"degrees of freedom (non-negative, but can be non-integer)", (Object[])new Object[0]))),
    DEXP(I18n.t((String)"dexp", (Object[])new Object[0]), "rexp", Exponential.class, new DistributionParam("rate", I18n.t((String)"vector of rates", (Object[])new Object[0]))),
    DF(I18n.t((String)"df", (Object[])new Object[0]), "rf", F.class, new DistributionParam("df1", I18n.t((String)"degrees of freedom. 'Inf' is allowed", (Object[])new Object[0])), new DistributionParam("df2", I18n.t((String)"degrees of freedom. 'Inf' is allowed", (Object[])new Object[0])), new DistributionParam("ncp", I18n.t((String)"non-centrality parameter. If omitted the central F is assumed", (Object[])new Object[0]))),
    DGAMMA(I18n.t((String)"dgamma", (Object[])new Object[0]), "rgamma", Gamma.class, new DistributionParam("shape", I18n.t((String)"shape and scale parameters. Must be positive, 'scale' strictly", (Object[])new Object[0])), new DistributionParam("rate", I18n.t((String)"an alternative way to specify the scale.", (Object[])new Object[0])), new DistributionParam("scale", I18n.t((String)"shape and scale parameters. Must be positive, 'scale' strictly", (Object[])new Object[0]))),
    DGEOM(I18n.t((String)"dgeom", (Object[])new Object[0]), "rgeom", Geometric.class, new DistributionParam("prob", I18n.t((String)"probability of success in each trial. '0 < prob <= 1'", (Object[])new Object[0]))),
    DHYPER(I18n.t((String)"dhyper", (Object[])new Object[0]), "rhyper", HyperGeometric.class, new DistributionParam("m", I18n.t((String)"the number of white balls in the urn.", (Object[])new Object[0])), new DistributionParam("n", I18n.t((String)"the number of black balls in the urn.", (Object[])new Object[0])), new DistributionParam("k", I18n.t((String)"the number of balls drawn from the urn.", (Object[])new Object[0]))),
    DLNORM(I18n.t((String)"dlnorm", (Object[])new Object[0]), "rlnorm", Normal.class, new DistributionParam("meanlog", I18n.t((String)"mean and standard deviation of the distribution on the log scale with default values of '0' and '1' respectively.", (Object[])new Object[0]), false), new DistributionParam("sdlog", I18n.t((String)"mean and standard deviation of the distribution on the log scale with default values of '0' and '1' respectively.", (Object[])new Object[0]), false));

    protected String description;
    protected String instruction;
    protected Class distClass;
    protected DistributionParam[] params;

    private Distribution(String description, String instruction, Class distClass, DistributionParam ... params) {
        this.description = description;
        this.instruction = instruction;
        this.distClass = distClass;
        this.params = params;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public Class getDistClass() {
        return this.distClass;
    }

    public DistributionParam[] getDistibutionParams() {
        return this.params;
    }

    public static class DistributionParam {
        protected String name;
        protected String description;
        protected boolean originalValue;

        public DistributionParam(String name, String description, boolean originalValue) {
            this.name = name;
            this.description = description;
            this.originalValue = originalValue;
        }

        public DistributionParam(String name, String description) {
            this(name, description, false);
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isOriginalValue() {
            return this.originalValue;
        }
    }
}

