/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.map;

import com.bbn.openmap.Layer;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.Projection;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.map.MapDataListener;
import fr.ifremer.isisfish.map.MapDataProvider;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;

public class ZoneDelimiterLayer
extends Layer
implements MapDataListener {
    private static final long serialVersionUID = 1127201121371123690L;
    private static Log log = LogFactory.getLog(ZoneDelimiterLayer.class);
    protected Projection proj = null;
    protected OMGraphicList graphics = new OMGraphicList();
    protected float pasMailleLatitude;
    protected float pasMailleLongitude;
    protected MapDataProvider mapDataProvider;
    protected Collection<Cell> cells;

    public ZoneDelimiterLayer(MapDataProvider mapDataProvider) throws TopiaException {
        this.mapDataProvider = mapDataProvider;
        this.pasMailleLatitude = mapDataProvider.getCellLengthLatitude();
        this.pasMailleLongitude = mapDataProvider.getCellLengthLongitude();
        this.cells = mapDataProvider.getCell();
        mapDataProvider.addProviderChangeListener(this);
        this.setVisible(true);
        this.generateGraphics();
    }

    protected void finalize() {
        this.mapDataProvider.removeProviderChangeListener(this);
    }

    public void setProjection(Projection proj) {
        this.proj = proj;
    }

    public Projection getProjection() {
        return this.proj;
    }

    public void renderDataForProjection(Projection proj, Graphics g) {
        if (proj == null) {
            return;
        }
        this.setProjection(proj.makeClone());
        this.paint(g);
    }

    public void projectionChanged(ProjectionEvent e) {
        this.setProjection(e.getProjection());
        this.repaint();
    }

    protected void generateGraphics() throws TopiaException {
        this.graphics.clear();
        for (Cell cell : this.cells) {
            OMRect omrect = new OMRect((double)(cell.getLatitude() + this.pasMailleLatitude), (double)cell.getLongitude(), (double)cell.getLatitude(), (double)(cell.getLongitude() + this.pasMailleLongitude), 1);
            if (cell.isLand()) {
                omrect.setLinePaint((Paint)new Color(Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue(), 0));
            } else {
                omrect.setLinePaint((Paint)Color.RED);
            }
            omrect.setVisible(true);
            this.graphics.add((OMGraphic)omrect);
        }
        this.graphics.generate(this.getProjection());
    }

    protected void refresh() {
        block2: {
            try {
                this.cells = this.mapDataProvider.getCell();
                this.generateGraphics();
                this.repaint();
            }
            catch (TopiaException eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"Can't refresh view", (Throwable)eee);
            }
        }
    }

    public void paint(Graphics g) {
        this.graphics.generate(this.getProjection());
        this.graphics.render(g);
    }

    @Override
    public void regionChanged() {
        this.refresh();
    }
}

