/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.logging;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;

@Plugin(name="SimulationThresholdFilter", category="Core", elementType="filter", printObject=true)
public final class SimulationThresholdFilter
extends AbstractFilter {
    private Level defaultThreshold;
    public static final String SIMULATION_ID = "simulationId";
    public static final String SIMULATION_LOG_FILE = "simulationLogFile";
    public static final String SIMULATION_APPLICATION_LEVEL = "simulationApplicationLevel";
    public static final String SIMULATION_LIB_LEVEL = "simulationLibLevel";
    public static final String SIMULATION_SCRIPT_LEVEL = "simulationScriptLevel";

    private SimulationThresholdFilter(Level defaultLevel, Filter.Result onMatch, Filter.Result onMismatch) {
        super(onMatch, onMismatch);
        this.defaultThreshold = defaultLevel;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        return this.filter(logger.getName(), level, ThreadContext.getContext());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        return this.filter(logger.getName(), level, ThreadContext.getContext());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        return this.filter(logger.getName(), level, ThreadContext.getContext());
    }

    public Filter.Result filter(LogEvent event) {
        return this.filter(event.getLoggerFqcn(), event.getLevel(), event.getContextData().toMap());
    }

    private Filter.Result filter(String loggerFqcn, Level level, Map<String, String> contextMap) {
        Filter.Result result;
        String simulationId = contextMap.get(SIMULATION_ID);
        if (simulationId == null) {
            result = Filter.Result.NEUTRAL;
        } else {
            Level ctxLevel = this.defaultThreshold;
            if (loggerFqcn.startsWith("fr.ifremer.isisfish")) {
                ctxLevel = Level.getLevel((String)contextMap.get(SIMULATION_APPLICATION_LEVEL));
            } else if (loggerFqcn.startsWith("org.nuiton")) {
                ctxLevel = Level.getLevel((String)contextMap.get(SIMULATION_LIB_LEVEL));
            } else if (StringUtils.startsWithAny((CharSequence)loggerFqcn, (CharSequence[])new CharSequence[]{"exports", "formules", "objectives", "optimizations", "rules", "scripts", "sensitivityanalysis", "sensitivityexports", "simulationplans", "simulators"})) {
                ctxLevel = Level.getLevel((String)contextMap.get(SIMULATION_SCRIPT_LEVEL));
            }
            result = level.isMoreSpecificThan(ctxLevel) ? this.onMatch : this.onMismatch;
        }
        return result;
    }

    @PluginFactory
    public static SimulationThresholdFilter createFilter(@PluginAttribute(value="defaultThreshold") Level defaultThreshold, @PluginAttribute(value="onMatch") Filter.Result onMatch, @PluginAttribute(value="onMismatch") Filter.Result onMismatch) {
        Level level = defaultThreshold == null ? Level.ERROR : defaultThreshold;
        return new SimulationThresholdFilter(level, onMatch, onMismatch);
    }
}

