/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.ResultStorageAbstract;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.matrix.MatrixCSVHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.util.StringUtil;

public class ResultStorageCSV
extends ResultStorageAbstract {
    private static Log log = LogFactory.getLog(ResultStorageCSV.class);
    protected int storeOnDiskStep = -1;
    protected int cacheStep = 13;
    protected TimeStep startDiskStep = null;
    private File directoryCache;
    protected int numberOfResult = 0;
    protected int numberOfResultOnDisk = 0;
    protected int numberOfResultAsked = 0;
    protected int numberOfResultReadInCache = 0;
    protected int numberOfResultReadOnDisk = 0;
    protected long bytesWritten = 0L;
    protected int maxGapWithCurrentStepReadOnDisk = 0;
    protected MatrixCSVHelper matrixCSVHelper;
    LinkedHashMap<TimeStep, Map<String, MatrixND>> cache = new LinkedHashMap<TimeStep, Map<String, MatrixND>>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<TimeStep, Map<String, MatrixND>> eldest) {
            return this.size() > ResultStorageCSV.this.cacheStep;
        }
    };
    protected HashSet<String> fileExistCache;

    public ResultStorageCSV(SimulationStorage simulation) {
        super(simulation);
        this.storeOnDiskStep = IsisFish.config.getSimulationStoreResultOnDisk();
        this.cacheStep = IsisFish.config.getSimulationStoreResultCacheStep();
    }

    protected MatrixCSVHelper getMatrixCSVHelper() {
        if (this.matrixCSVHelper == null) {
            this.matrixCSVHelper = new MatrixCSVHelper(this.decorator);
        }
        return this.matrixCSVHelper;
    }

    @Override
    public String getInfo() {
        String oldest = "";
        if (this.maxGapWithCurrentStepReadOnDisk > 0) {
            oldest = String.format("\tthe oldest step read on disk was %s step before current step\n", this.maxGapWithCurrentStepReadOnDisk);
        }
        return String.format("ResultStorageCSV:\n\t%s results written to disk on a total of %s (for %s)\n\t%s results read (%s in cache and %s on disk)\n%s", this.numberOfResultOnDisk, this.numberOfResult, StringUtil.convertMemory((long)this.bytesWritten), this.numberOfResultAsked, this.numberOfResultReadInCache, this.numberOfResultReadOnDisk, oldest);
    }

    protected File getDirectory() {
        if (this.directoryCache == null) {
            this.directoryCache = SimulationStorage.getResultDirectory(this.simulation.getDirectory());
        }
        return this.directoryCache;
    }

    protected File getMatrixDirectory(String name) {
        File file = new File(this.getDirectory(), "matrix" + File.separator + name);
        return file;
    }

    protected File getMatrixFile(TimeStep step, String name) {
        File file = new File(this.getMatrixDirectory(name), step.getStep() + "-" + name + ".csv.gz");
        return file;
    }

    protected HashSet<String> getFileExistCache() {
        if (this.fileExistCache == null) {
            this.fileExistCache = new HashSet();
            File matrixDir = this.getMatrixDirectory("");
            File[] resultDirs = matrixDir.listFiles();
            if (resultDirs != null) {
                for (File resultDir : resultDirs) {
                    Collections.addAll(this.fileExistCache, resultDir.list());
                }
            }
        }
        return this.fileExistCache;
    }

    protected boolean fileExist(File f) {
        return this.getFileExistCache().contains(f.getName());
    }

    protected void addFileExist(File f) {
        this.getFileExistCache().add(f.getName());
    }

    protected MatrixND readMatrix(String file) throws IOException {
        MatrixND result;
        try (InputStreamReader in = new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(file)), StandardCharsets.UTF_8);){
            result = this.getMatrixCSVHelper().readMatrix(in);
        }
        return result;
    }

    protected TimeStep getTimeStep(String file) {
        TimeStep result = null;
        try {
            String num = StringUtils.substringBefore((String)file, (String)"-");
            int step = Integer.parseInt(num);
            result = new TimeStep(step);
        }
        catch (NumberFormatException eee) {
            log.error((Object)("File doesn't contains step information: " + file), (Throwable)eee);
        }
        return result;
    }

    @Override
    public void delete() {
        super.delete();
        try {
            File file = this.getDirectory();
            FileUtils.deleteDirectory((File)file);
            this.fileExistCache = null;
        }
        catch (IOException eee) {
            throw new IsisFishRuntimeException("Can't delete results", eee);
        }
    }

    @Override
    protected MatrixND readResult(TimeStep step, String name) {
        ++this.numberOfResultAsked;
        MatrixND result = null;
        if (this.cache.containsKey(step)) {
            result = this.getCacheForStep(step).get(name);
        }
        if (result != null) {
            ++this.numberOfResultReadInCache;
        } else {
            File file = this.getMatrixFile(step, name);
            if (this.fileExist(file)) {
                try {
                    TimeStep currentStep;
                    result = this.readMatrix(file.getPath());
                    ++this.numberOfResultReadOnDisk;
                    SimulationControl sc = SimulationContext.get().getSimulationControl();
                    if (sc != null && !step.equals(currentStep = sc.getStep())) {
                        this.maxGapWithCurrentStepReadOnDisk = Math.max(this.maxGapWithCurrentStepReadOnDisk, currentStep.gap(step));
                    }
                }
                catch (IOException eee) {
                    log.error((Object)("Can't read result file: " + String.valueOf(file)), (Throwable)eee);
                }
            }
        }
        return result;
    }

    protected boolean isDiskResult(TimeStep step) {
        if (this.startDiskStep == null) {
            this.startDiskStep = this.getLastStep().minus(this.storeOnDiskStep);
        }
        return this.storeOnDiskStep < 0 || this.startDiskStep.before(step);
    }

    protected Map<String, MatrixND> getCacheForStep(TimeStep step) {
        Map result = this.cache.computeIfAbsent(step, k -> new HashMap());
        return result;
    }

    @Override
    protected void writeResult(TimeStep step, String name, MatrixND mat) {
        mat = this.undecorate(mat);
        this.getCacheForStep(step).put(name, mat);
        ++this.numberOfResult;
        if (this.isDiskResult(step)) {
            ++this.numberOfResultOnDisk;
            File file = this.getMatrixFile(step, name);
            file.getParentFile().mkdirs();
            CountingOutputStream counter = null;
            try {
                counter = new CountingOutputStream((OutputStream)new FileOutputStream(file));
                try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new GZIPOutputStream((OutputStream)counter), StandardCharsets.UTF_8);){
                    this.getMatrixCSVHelper().writeMatrix(out, name, mat);
                    this.addFileExist(file);
                }
            }
            catch (Exception eee) {
                throw new IsisFishRuntimeException("Can't write result: " + String.valueOf(file), eee);
            }
            finally {
                if (counter != null) {
                    this.bytesWritten += counter.getByteCount();
                }
            }
        }
    }

    @Override
    protected void writeActiveRule(TimeStep step, String name, String params) {
    }

    @Override
    public List<String> getResultName() {
        List<Object> result;
        File dir = this.getMatrixDirectory("");
        Object[] files = dir.list();
        if (files != null) {
            Arrays.sort(files);
            result = Arrays.asList(files);
        } else {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }
}

