/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.aspect;

import fr.ifremer.isisfish.annotations.ComputeResult;
import java.lang.reflect.Method;
import java.util.Map;
import org.nuiton.profiling.StatisticMethod;
import org.nuiton.profiling.Trace;

public class ComputeResultTrace
extends Trace {
    public ComputeResultTrace(boolean multithread, boolean distinctThreadCall) {
        super(multithread, distinctThreadCall);
    }

    public String getStatisticsText() {
        StringBuilder result = new StringBuilder();
        for (Trace.StatAndStack ss : this.allStatAndStack) {
            for (Map.Entry methodAndStat : ss.getStatistics().entrySet()) {
                Method method = (Method)methodAndStat.getKey();
                String resultName = method.getAnnotation(ComputeResult.class).value();
                StatisticMethod stats = (StatisticMethod)methodAndStat.getValue();
                result.append("- ").append(resultName).append(", max:").append(stats.getMax() / 1000L).append("ms").append(", mean:").append((long)stats.getMean() / 1000L).append("ms").append(", total:").append(stats.getTotal() / 1000L).append("ms").append("\n");
            }
        }
        return result.toString();
    }
}

