/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.aspect;

import fr.ifremer.isisfish.aspect.CommonsLoggingMessageHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.ClassParser;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.util.FileUtil;
import org.aspectj.util.LangUtil;
import org.aspectj.weaver.CrosscuttingMembersSet;
import org.aspectj.weaver.IClassFileProvider;
import org.aspectj.weaver.IUnwovenClassFile;
import org.aspectj.weaver.IWeaveRequestor;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.BcelWeaver;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.UnwovenClassFile;
import org.aspectj.weaver.tools.WeavingAdaptor;
import org.aspectj.weaver.tools.WeavingClassLoader;
import org.aspectj.weaver.tools.cache.SimpleCache;
import org.aspectj.weaver.tools.cache.SimpleCacheFactory;

public class AspectJWeavingAdaptor
extends WeavingAdaptor {
    protected ClassLoader parentLoader;
    protected CrosscuttingMembersSet xcutSet;

    public AspectJWeavingAdaptor(ClassLoader parentLoader, WeavingClassLoader loader) {
        this.parentLoader = parentLoader;
        this.generatedClassHandler = loader;
        this.init((ClassLoader)loader, this.getFullClassPath((ClassLoader)loader));
    }

    private void init(ClassLoader loader, List<String> classPath) {
        try {
            Field abortOnErrorField = WeavingAdaptor.class.getDeclaredField("abortOnError");
            abortOnErrorField.setAccessible(true);
            abortOnErrorField.set((Object)this, true);
            this.createMessageHandler();
            Field messageHandlerField = WeavingAdaptor.class.getDeclaredField("messageHandler");
            messageHandlerField.setAccessible(true);
            IMessageHandler messageHandler = (IMessageHandler)messageHandlerField.get((Object)this);
            this.bcelWorld = new BcelWorld(classPath, messageHandler, null);
            this.bcelWorld.setXnoInline(false);
            this.bcelWorld.getLint().loadDefaultProperties();
            if (LangUtil.is15VMOrGreater()) {
                this.bcelWorld.setBehaveInJava5Way(true);
            }
            this.bcelWorld.setMessageHandler((IMessageHandler)new CommonsLoggingMessageHandler());
            this.weaver = new BcelWeaver(this.bcelWorld);
            Field enabledField = WeavingAdaptor.class.getDeclaredField("enabled");
            enabledField.setAccessible(true);
            enabledField.set((Object)this, true);
            Field xcutSetField = BcelWeaver.class.getDeclaredField("xcutSet");
            xcutSetField.setAccessible(true);
            this.xcutSet = (CrosscuttingMembersSet)xcutSetField.get(this.weaver);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
    }

    public byte[] deploy(Class<?> aspectClass) {
        byte[] result;
        String name = aspectClass.getName();
        try (InputStream is = AspectJWeavingAdaptor.class.getResourceAsStream("/" + name.replace('.', '/') + ".class");){
            byte[] bytes = FileUtil.readAsByteArray((InputStream)is);
            is.close();
            ClassParser parser = new ClassParser(new ByteArrayInputStream(bytes), name);
            JavaClass jc = parser.parse();
            BcelObjectType bcType = this.bcelWorld.addSourceObjectType(jc, false);
            ReferenceType type = bcType.getResolvedTypeX();
            this.xcutSet.addOrReplaceAspect((ResolvedType)type);
            WeavingClassFileProvider2 wcp = new WeavingClassFileProvider2(name, bytes);
            wcp.setApplyAtAspectJMungersOnly();
            this.weaver.weave((IClassFileProvider)wcp);
            result = wcp.getBytes();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't create aspect", e);
        }
        return result;
    }

    public void prepare() {
        this.weaver.prepareForWeave();
    }

    private class WeavingClassFileProvider2
    implements IClassFileProvider {
        private final UnwovenClassFile unwovenClass;
        private final List<UnwovenClassFile> unwovenClasses = new ArrayList<UnwovenClassFile>();
        private IUnwovenClassFile wovenClass;
        private boolean isApplyAtAspectJMungersOnly = false;

        public WeavingClassFileProvider2(String name, byte[] bytes) {
            AspectJWeavingAdaptor.this.ensureDelegateInitialized(name, bytes);
            this.unwovenClass = new UnwovenClassFile(name, name, bytes);
            this.unwovenClasses.add(this.unwovenClass);
            if (AspectJWeavingAdaptor.this.shouldDump(name.replace('/', '.'), true)) {
                AspectJWeavingAdaptor.this.dump(name, bytes, true);
            }
        }

        public void setApplyAtAspectJMungersOnly() {
            this.isApplyAtAspectJMungersOnly = true;
        }

        public boolean isApplyAtAspectJMungersOnly() {
            return this.isApplyAtAspectJMungersOnly;
        }

        public byte[] getBytes() {
            if (this.wovenClass != null) {
                return this.wovenClass.getBytes();
            }
            return this.unwovenClass.getBytes();
        }

        public Iterator<UnwovenClassFile> getClassFileIterator() {
            return this.unwovenClasses.iterator();
        }

        public IWeaveRequestor getRequestor() {
            return new IWeaveRequestor(){

                public void acceptResult(IUnwovenClassFile result) {
                    if (WeavingClassFileProvider2.this.wovenClass == null) {
                        WeavingClassFileProvider2.this.wovenClass = result;
                        String name = result.getClassName();
                        if (AspectJWeavingAdaptor.this.shouldDump(name.replace('/', '.'), false)) {
                            AspectJWeavingAdaptor.this.dump(name, result.getBytes(), false);
                        }
                    } else {
                        String className = result.getClassName();
                        byte[] resultBytes = result.getBytes();
                        if (SimpleCacheFactory.isEnabled()) {
                            SimpleCache lacache = SimpleCacheFactory.createSimpleCache();
                            lacache.put(result.getClassName(), WeavingClassFileProvider2.this.wovenClass.getBytes(), result.getBytes());
                            lacache.addGeneratedClassesNames(WeavingClassFileProvider2.this.wovenClass.getClassName(), WeavingClassFileProvider2.this.wovenClass.getBytes(), result.getClassName());
                        }
                        AspectJWeavingAdaptor.this.generatedClasses.put(className, result);
                        AspectJWeavingAdaptor.this.generatedClasses.put(WeavingClassFileProvider2.this.wovenClass.getClassName(), result);
                        AspectJWeavingAdaptor.this.generatedClassHandler.acceptClass(className, null, resultBytes);
                    }
                }

                public void processingReweavableState() {
                }

                public void addingTypeMungers() {
                }

                public void weavingAspects() {
                }

                public void weavingClasses() {
                }

                public void weaveCompleted() {
                    if (AspectJWeavingAdaptor.this.delegateForCurrentClass != null) {
                        AspectJWeavingAdaptor.this.delegateForCurrentClass.weavingCompleted();
                    }
                }
            };
        }
    }
}

