/*
 * Decompiled with CFR 0.152.
 */
package simulators;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.MetierMonitor;
import fr.ifremer.isisfish.simulator.PopulationMonitor;
import fr.ifremer.isisfish.simulator.ResultManager;
import fr.ifremer.isisfish.simulator.RuleMonitor;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.Simulator;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import scripts.GravityModel;
import scripts.ResultName;
import scripts.SiMatrix;

public class DefaultSimulator
implements Simulator {
    private static Log log = LogFactory.getLog(DefaultSimulator.class);

    public void simulate(SimulationContext context) throws Exception {
        SimulationParameter param = context.getSimulationStorage().getParameter();
        SimulationControl control = context.getSimulationControl();
        int lastYear = param.getNumberOfYear();
        int lastStep = lastYear * Month.NUMBER_OF_MONTH;
        TimeStep step = control.getStep();
        ResultManager resManager = context.getResultManager();
        TopiaContext db = context.getDB();
        SiMatrix siMatrix = SiMatrix.getSiMatrix(context);
        GravityModel gravityModel = new GravityModel(context, siMatrix);
        PopulationMonitor populationMonitor = context.getPopulationMonitor();
        MetierMonitor metierMonitor = context.getMetierMonitor();
        RuleMonitor ruleMonitor = context.getRuleMonitor();
        List<Population> allpops = siMatrix.getPopulations(step);
        populationMonitor.init(allpops);
        for (Population pop : allpops) {
            MatrixND N = param.getNumberOf(pop);
            N.setName(ResultName.MATRIX_ABUNDANCE);
            populationMonitor.setN(pop, N);
        }
        param.reloadContextParameters();
        List rules = param.getRules();
        control.setText("Rules initialisation:" + rules);
        for (Rule rule : rules) {
            rule.init(context);
            log.info((Object)("Rule " + rule.getClass().getSimpleName() + " initialized"));
        }
        context.getDB().commitTransaction();
        while (step.getStep() < lastStep) {
            if (control.isStopSimulationRequest()) break;
            control.setStep(step);
            control.setProgress((long)step.getStep());
            control.setText(I18n.t((String)("begin step " + step), (Object[])new Object[0]));
            control.setText(I18n.t((String)"Reloading parameters", (Object[])new Object[0]));
            param.reloadContextParameters();
            rules = param.getRules();
            metierMonitor.clear();
            if (step.getMonth().equals((Object)Month.JANUARY)) {
                populationMonitor.clearCatch();
            }
            if (siMatrix.getStrategies(step).size() > 0 && resManager.isEnabled(ResultName.MATRIX_NO_ACTIVITY)) {
                MatrixND mat = metierMonitor.getOrCreateNoActivity(step, ResultName.MATRIX_NO_ACTIVITY, siMatrix.getStrategies(step), siMatrix.getMetiers(step));
                resManager.addResult(step, mat);
            }
            control.setText("Evaluate rules conditions (" + rules.size() + " rules)");
            for (Rule rule : rules) {
                for (Metier metier : siMatrix.getMetiers(step)) {
                    boolean active;
                    block27: {
                        active = false;
                        try {
                            active = rule.condition(context, step, metier);
                        }
                        catch (Exception eee) {
                            if (!log.isWarnEnabled()) break block27;
                            log.warn((Object)("Can't evaluate rule condition for: " + rule), (Throwable)eee);
                        }
                    }
                    ruleMonitor.setEvaluationCondition(step, rule, metier, active);
                    if (!active) continue;
                    log.info((Object)("Activate rule: " + rule.getClass().getSimpleName()));
                    resManager.addActiveRule(step, rule);
                }
            }
            control.setText("Do pre action Rules");
            for (Rule rule : rules) {
                for (Metier metier : siMatrix.getMetiers(step)) {
                    boolean condition = ruleMonitor.getEvalutionCondition(step, rule, metier);
                    if (!condition) continue;
                    rule.preAction(context, step, metier);
                }
            }
            if (resManager.isEnabled(ResultName.MATRIX_METIER_ZONE)) {
                MatrixND metierZone = siMatrix.getMetierZone(step);
                resManager.addResult(step, metierZone);
            }
            control.setText("Simulate one month");
            for (Population pop : siMatrix.getPopulations(step)) {
                this.computeMonth(context, siMatrix, step, pop);
            }
            if (siMatrix.getStrategies(step).size() > 0) {
                control.setText("Add some results");
                if (resManager.isEnabled(ResultName.MATRIX_EFFORT_PER_STRATEGY_MET)) {
                    MatrixND effortPerStrategyMet = siMatrix.matrixEffortPerStrategyMet(step);
                    resManager.addResult(step, effortPerStrategyMet);
                }
                if (resManager.isEnabled(ResultName.MATRIX_EFFORT_NOMINAL_PER_STRATEGY_MET)) {
                    MatrixND effortNominalPerStrategyMet = siMatrix.matrixEffortNominalPerStrategyMet(step);
                    resManager.addResult(step, effortNominalPerStrategyMet);
                }
                if (!"false".equalsIgnoreCase((String)param.getTagValue().get("ecoResult"))) {
                    control.setText("Add economics results");
                    this.saveGravityModel(step, resManager, gravityModel);
                }
            }
            if (resManager.isEnabled(ResultName.MATRIX_PRICE)) {
                for (Population pop : siMatrix.getPopulations(step)) {
                    MatrixND matPrice = siMatrix.matrixPrice(step, pop);
                    resManager.addResult(step, pop, matPrice);
                }
            }
            control.setText("Do post action Rules");
            for (Rule rule : rules) {
                for (Metier metier : siMatrix.getMetiers(step)) {
                    if (!ruleMonitor.getEvalutionCondition(step, rule, metier)) continue;
                    rule.postAction(context, step, metier);
                }
            }
            if (siMatrix.getStrategies(step).size() > 0) {
                control.setText("Compute discard and landing");
                for (Population pop : siMatrix.getPopulations(step)) {
                    MatrixND discard = populationMonitor.getDiscard(step, pop);
                    if (discard != null || step.getStep() == 0) {
                        if (discard == null) {
                            discard = MatrixFactory.getInstance().create(ResultName.MATRIX_DISCARDS_PER_STR_MET_PER_ZONE_POP, new List[]{siMatrix.getStrategies(step), siMatrix.getMetiers(step), pop.getPopulationGroup(), pop.getPopulationZone()}, new String[]{I18n.n((String)"Strategies", (Object[])new Object[0]), I18n.n((String)"Metiers", (Object[])new Object[0]), I18n.n((String)"Groups", (Object[])new Object[0]), I18n.n((String)"Zones", (Object[])new Object[0])});
                        }
                        resManager.addResult(step, pop, discard);
                        if (resManager.isEnabled(ResultName.MATRIX_DISCARDS_WEIGHT_PER_STR_MET_PER_ZONE_POP)) {
                            MatrixND discardWeightPerStrategyMet = siMatrix.matrixDiscardWeightPerStrategyMetPerZonePop(pop, step, discard);
                            resManager.addResult(step, pop, discardWeightPerStrategyMet);
                        }
                    }
                    if (!resManager.isEnabled(ResultName.MATRIX_LANDING_PER_MET)) continue;
                    MatrixND landing = MatrixFactory.getInstance().create(populationMonitor.getCatch(pop));
                    if (discard != null) {
                        landing = landing.minus(discard);
                    }
                    landing.setName(ResultName.MATRIX_LANDING_PER_MET);
                    resManager.addResult(step, pop, landing);
                }
            }
            control.setText("Rollback rules changes");
            db.rollbackTransaction();
            control.setText("Commit results");
            TopiaContext tx = context.getDbResult();
            tx.commitTransaction();
            step = step.next();
        }
    }

    protected boolean isEffortByCell(SimulationContext context) {
        boolean result = "true".equalsIgnoreCase((String)context.getSimulationStorage().getParameter().getTagValue().get("effortByCell"));
        return result;
    }

    protected void computeMonth(SimulationContext context, SiMatrix siMatrix, TimeStep step, Population pop) throws IsisFishException, TopiaException {
        MatrixND abundance;
        ResultStorage resManager = context.getSimulationStorage().getResultStorage();
        PopulationMonitor popMon = context.getPopulationMonitor();
        MatrixND N = popMon.getN(pop);
        if (log.isInfoEnabled()) {
            log.info((Object)("====================== begin " + step + " - " + pop + " =========================== " + System.currentTimeMillis()));
            log.info((Object)("N: " + N));
        }
        resManager.addResult(step, pop, N);
        if (resManager.isEnabled(ResultName.MATRIX_BIOMASS)) {
            MatrixND biomass = siMatrix.matrixBiomass(N, pop, step);
            resManager.addResult(step, pop, biomass);
        }
        Month month = step.getMonth();
        PopulationSeasonInfo info = pop.getPopulationSeasonInfo(month);
        MatrixND CA = step.getStep() == 0 ? MatrixFactory.getInstance().matrixId(pop.sizePopulationGroup() * pop.sizePopulationZone()) : info.getGroupChangeMatrix(month);
        log.debug((Object)("CA: " + CA));
        MatrixND M = info.getMigrationMatrix(month, N);
        log.debug((Object)("M: " + M));
        MatrixND EM = info.getEmigrationMatrix(month, N);
        log.debug((Object)("EM: " + EM));
        MatrixND IM = info.getImmigrationMatrix(month, N).transpose();
        log.debug((Object)("IM: " + IM));
        MatrixND N1D = pop.N2DToN1D(N);
        log.debug((Object)("N1D: " + N1D));
        MatrixND tmp0 = N1D.mult(CA);
        MatrixND tmp1 = M.minus(EM);
        MatrixND tmp2 = tmp0.mult(tmp1);
        MatrixND tmp3 = tmp2.add(IM);
        log.debug((Object)("N1D after mig: " + tmp3));
        N = pop.split2D(tmp3);
        log.debug((Object)("N after mig: " + N));
        MatrixND R = info.getReproductionMatrix(month, N);
        log.debug((Object)("R: " + R));
        popMon.setReproduction(step, pop, R);
        MatrixND recruitment = popMon.getRecruitment(step, pop);
        log.debug((Object)("recruitment: " + recruitment));
        popMon.applyReproductionMortality(pop);
        N = N.add(recruitment);
        log.debug((Object)("N after recru: " + N));
        if (resManager.isEnabled(ResultName.MATRIX_ABUNDANCE_BEGIN_MONTH)) {
            MatrixND abondanceBM = siMatrix.matrixAbondanceBeginMonth(N, pop, step);
            resManager.addResult(step, pop, abondanceBM);
        }
        if (resManager.isEnabled(ResultName.MATRIX_BIOMASS_BEGIN_MONTH)) {
            MatrixND biomassBM = siMatrix.matrixBiomassBeginMonth(N, pop, step);
            resManager.addResult(step, pop, biomassBM);
        }
        if (siMatrix.getStrategies(step).size() > 0) {
            MatrixND catchPerStrategyMetPerZonePop;
            if (this.isEffortByCell(context)) {
                abundance = siMatrix.matrixAbundance(N, pop, step);
                catchPerStrategyMetPerZonePop = siMatrix.matrixCatchPerStrategyMetPerZonePop(N, pop, step);
            } else {
                MatrixND matrixFishingMortality = siMatrix.matrixFishingMortality(step, pop);
                resManager.addResult(step, pop, matrixFishingMortality);
                abundance = siMatrix.matrixAbundance(N, pop, step, matrixFishingMortality);
                MatrixND catchRatePerStrategyMet = siMatrix.matrixCatchRatePerStrategyMetPerZone(pop, step, matrixFishingMortality);
                resManager.addResult(step, pop, catchRatePerStrategyMet);
                catchPerStrategyMetPerZonePop = siMatrix.matrixCatchPerStrategyMetPerZone(N, pop, step, catchRatePerStrategyMet);
            }
            popMon.holdCatch(pop, catchPerStrategyMetPerZonePop);
            resManager.addResult(step, pop, catchPerStrategyMetPerZonePop);
            if (resManager.isEnabled(ResultName.MATRIX_CATCH_WEIGHT_PER_STRATEGY_MET_PER_ZONE_POP)) {
                MatrixND catchWeightPerStrategyMet = siMatrix.matrixCatchWeightPerStrategyMetPerZonePop(step, pop, catchPerStrategyMetPerZonePop);
                resManager.addResult(step, pop, catchWeightPerStrategyMet);
            }
            if (this.isEffortByCell(context)) {
                MatrixND catchPerStrategyMetPerZoneMet = siMatrix.matrixCatchPerStrategyMetPerZoneMet(N, pop, step);
                resManager.addResult(step, pop, catchPerStrategyMetPerZoneMet);
                if (resManager.isEnabled(ResultName.MATRIX_CATCH_WEIGHT_PER_STRATEGY_MET_PER_ZONE_MET)) {
                    MatrixND catchWeightPerStrategyMet = siMatrix.matrixCatchWeightPerStrategyMetPerZoneMet(step, pop, catchPerStrategyMetPerZoneMet);
                    resManager.addResult(step, pop, catchWeightPerStrategyMet);
                }
            }
            if (resManager.isEnabled(ResultName.MATRIX_FISHING_MORTALITY_PER_GROUP) || resManager.isEnabled(ResultName.MATRIX_TOTAL_FISHING_MORTALITY)) {
                MatrixND fishingMortalityPerGroup = siMatrix.fishingMortalityPerGroup(step, pop, context.getSimulationStorage().getResultStorage());
                if (resManager.isEnabled(ResultName.MATRIX_FISHING_MORTALITY_PER_GROUP)) {
                    resManager.addResult(step, pop, fishingMortalityPerGroup);
                }
                if (resManager.isEnabled(ResultName.MATRIX_TOTAL_FISHING_MORTALITY)) {
                    MatrixND totalFishingMortality = siMatrix.totalFishingMortality(step, pop, fishingMortalityPerGroup);
                    resManager.addResult(step, pop, totalFishingMortality);
                }
            }
        } else {
            abundance = siMatrix.matrixAbundanceSsF(N, pop, step);
        }
        log.debug((Object)("abundance: " + abundance));
        popMon.setN(pop, abundance);
        log.debug((Object)("====================== end " + step + " - " + pop + " ==========================="));
    }

    private void saveGravityModel(TimeStep step, ResultManager resManager, GravityModel gravityModel) throws IsisFishException, TopiaException {
        MatrixND mat;
        if (resManager.isEnabled(ResultName.MATRIX_FISHING_TIME_PER_MONTH_PER_VESSEL)) {
            mat = gravityModel.matrixFishingTimePerMonthPerVessel(step);
            resManager.addResult(step, mat);
        }
        if (resManager.isEnabled(ResultName.MATRIX_FUEL_COSTS_OF_TRAVEL_PER_VESSEL)) {
            mat = gravityModel.matrixFuelCostsOfTravelPerVessel(step);
            resManager.addResult(step, mat);
        }
        if (resManager.isEnabled(ResultName.MATRIX_COSTS_OF_FISHING_PER_VESSEL)) {
            mat = gravityModel.matrixCostsOfFishingPerVessel(step);
            resManager.addResult(step, mat);
        }
        if (resManager.isEnabled(ResultName.MATRIX_FUEL_COSTS_PER_VESSEL)) {
            mat = gravityModel.matrixFuelCostsOfTravelPerVessel(step);
            resManager.addResult(step, mat);
        }
        if (resManager.isEnabled(ResultName.MATRIX_REPAIR_AND_MAINTENANCE_GEAR_COSTS_PER_VESSEL)) {
            mat = gravityModel.matrixRepairAndMaintenanceGearCostsPerVessel(step);
            resManager.addResult(step, mat);
        }
        if (resManager.isEnabled(ResultName.MATRIX_OTHER_RUNNING_COSTS_PER_VESSEL)) {
            mat = gravityModel.matrixOtherRunningCostsPerVessel(step);
            resManager.addResult(step, mat);
        }
        if (resManager.isEnabled(ResultName.MATRIX_SHARED_NOT_FIXED_COSTS_PER_VESSEL)) {
            mat = gravityModel.matrixSharedNotFixedCostsPerVessel(step);
            resManager.addResult(step, mat);
        }
        if (resManager.isEnabled(ResultName.MATRIX_GROSS_VALUE_OF_LANDINGS_PER_SPECIES_PER_STRATEGY_MET)) {
            mat = gravityModel.matrixGrossValueOfLandingsPerSpeciesPerStrategyMet(step);
            resManager.addResult(step, mat);
        }
        if (resManager.isEnabled(ResultName.MATRIX_GROSS_VALUE_OF_LANDINGS_PER_STRATEGY_MET)) {
            mat = gravityModel.matrixGrossValueOfLandingsPerStrategyMet(step);
            resManager.addResult(step, mat);
        }
        if (resManager.isEnabled(ResultName.MATRIX_GROSS_VALUE_OF_LANDINGS_PER_STRATEGY_MET_PER_VESSEL)) {
            mat = gravityModel.matrixGrossValueOfLandingsPerStrategyMetPerVessel(step);
            resManager.addResult(step, mat);
        }
        if (resManager.isEnabled(ResultName.MATRIX_NET_VALUE_OF_LANDINGS_PER_STRATEGY_MET)) {
            mat = gravityModel.matrixNetValueOfLandingsPerStrategyMet(step);
            resManager.addResult(step, mat);
        }
        if (resManager.isEnabled(ResultName.MATRIX_NET_VALUE_OF_LANDINGS_PER_STRATEGY_MET_PER_VESSEL)) {
            mat = gravityModel.matrixNetValueOfLandingsPerStrategyMetPerVessel(step);
            resManager.addResult(step, mat);
        }
        if (resManager.isEnabled(ResultName.MATRIX_NET_RENEVUE_TO_SHARE_PER_STRATEGY_MET_PER_VESSEL)) {
            mat = gravityModel.matrixNetRenevueToSharePerStrategyMetPerVessel(step);
            resManager.addResult(step, mat);
        }
        if (resManager.isEnabled(ResultName.MATRIX_CREW_SHARE_PER_STRATEGY_MET_PER_VESSEL)) {
            mat = gravityModel.matrixCrewSharePerStrategyMetPerVessel(step);
            resManager.addResult(step, mat);
        }
        if (resManager.isEnabled(ResultName.MATRIX_OWNER_MARGIN_OVER_VARIABLE_COSTS_PER_STRATEGY_MET_PER_VESSEL)) {
            mat = gravityModel.matrixOwnerMarginOverVariableCostsPerStrategyMetPerVessel(step);
            resManager.addResult(step, mat);
        }
        if (resManager.isEnabled(ResultName.MATRIX_VESSEL_MARGIN_OVER_VARIABLE_COSTS_PER_STRATEGY_MET_PER_VESSEL)) {
            mat = gravityModel.matrixVesselMarginOverVariableCostsPerStrategyMetPerVessel(step);
            resManager.addResult(step, mat);
        }
        if (resManager.isEnabled(ResultName.MATRIX_OWNER_MARGIN_OVER_VARIABLE_COSTS_PER_STRATEGY_PER_VESSEL)) {
            mat = gravityModel.matrixOwnerMarginOverVariableCostsPerStrategyPerVessel(step);
            resManager.addResult(step, mat);
        }
        if (resManager.isEnabled(ResultName.MATRIX_OWNER_MARGIN_OVER_VARIABLE_COSTS_PER_STRATEGY)) {
            mat = gravityModel.matrixOwnerMarginOverVariableCostsPerStrategy(step);
            resManager.addResult(step, mat);
        }
        if (resManager.isEnabled(ResultName.MATRIX_VESSEL_MARGIN_OVER_VARIABLE_COSTS_PER_STRATEGY_PER_VESSEL)) {
            mat = gravityModel.matrixVesselMarginOverVariableCostsPerStrategyPerVessel(step);
            resManager.addResult(step, mat);
        }
        if (resManager.isEnabled(ResultName.MATRIX_VESSEL_MARGIN_OVER_VARIABLE_COSTS_PER_STRATEGY)) {
            mat = gravityModel.matrixVesselMarginOverVariableCostsPerStrategy(step);
            resManager.addResult(step, mat);
        }
    }
}

