/*
 * Decompiled with CFR 0.152.
 */
package rules;

import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.rule.AbstractRule;
import fr.ifremer.isisfish.simulator.MetierMonitor;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import scripts.ResultName;
import scripts.SiMatrix;

public class TotalClosure
extends AbstractRule {
    private static Log log = LogFactory.getLog(TotalClosure.class);
    public TimeStep param_beginStep = new TimeStep(100);
    public TimeStep param_endStep = new TimeStep(119);
    public Month param_beginMonth = Month.JANUARY;
    public Month param_endMonth = Month.JANUARY;
    protected String[] necessaryResult = new String[]{ResultName.MATRIX_NO_ACTIVITY};

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }

    public String getDescription() throws Exception {
        return "Total closure of the fishery";
    }

    public void init(SimulationContext context) throws Exception {
    }

    public boolean condition(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        boolean result = true;
        if (step.before(this.param_beginStep)) {
            result = false;
        } else if (step.after(this.param_endStep)) {
            result = false;
        }
        if (step.getMonth().before(this.param_beginMonth)) {
            result = false;
        } else if (step.getMonth().after(this.param_endMonth)) {
            result = false;
        }
        return result;
    }

    public void preAction(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        MetierMonitor metierMon = context.getMetierMonitor();
        SiMatrix siMatrix = SiMatrix.getSiMatrix(context);
        MatrixND noActivity = metierMon.getOrCreateNoActivity(step, ResultName.MATRIX_NO_ACTIVITY, siMatrix.getStrategies(step), siMatrix.getMetiers(step));
        metierMon.addforbiddenMetier(metier);
        List<Strategy> strategies = siMatrix.getStrategies(step);
        for (Strategy str : strategies) {
            StrategyMonthInfo info = str.getStrategyMonthInfo(step.getMonth());
            double prop = info.getProportionMetier(metier);
            if (prop == 0.0) continue;
            noActivity.setValue((Object)str, (Object)metier, prop);
            info.setProportionMetier(metier, 0.0);
        }
    }

    public void postAction(SimulationContext context, TimeStep step, Metier metier) throws Exception {
    }
}

