<%--
  #%L
  EchoBase :: UI
  
  $Id: userForm.jsp 75 2011-11-14 09:15:15Z sletellier $
  $HeadURL: http://svn.forge.codelutin.com/svn/echobase/trunk/echobase-ui/src/main/webapp/WEB-INF/jsp/user/userForm.jsp $
  %%
  Copyright (C) 2011 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page import="fr.ifremer.echobase.ui.actions.EditActionEnum" %>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sjg" uri="/struts-jquery-grid-tags" %>

<script type="text/javascript"
        src="<s:url value='/js/gridHelper.js' />"></script>

<%-- CRUD constants --%>
<s:set name="create"><%=EditActionEnum.CREATE.toString()%>
</s:set>
<s:set name="edit"><%=EditActionEnum.EDIT.toString()%>
</s:set>
<s:set name="delete"><%=EditActionEnum.DELETE.toString()%>
</s:set>

<s:if test="userEditAction == #create">
  <s:set name="title"><s:text name="echobase.label.admin.user.create"/></s:set>
</s:if>
<s:elseif test="userEditAction == #edit">
  <s:set name="title"><s:text name="echobase.label.admin.user.edit"/></s:set>
</s:elseif>
<s:elseif test="userEditAction == #delete">
  <s:set name="title"><s:text name="echobase.label.admin.user.delete"/></s:set>
</s:elseif>

<title><s:property value="#title"/></title>

<h2><s:property value="#title"/></h2>

<s:if test="userEditAction == #create">

  <%--Create user--%>

  <s:form method="post" validate="true" namespace="/user">
    <fieldset>
      <legend>
        <s:text name="echobase.common.user"/>
      </legend>
      <s:hidden key="userEditAction" label=""/>
      <s:textfield key="user.email" label="%{getText('echobase.common.email')}"
                   size="40" required="true"/>
      <s:password key="user.password"
                  label="%{getText('echobase.common.password')}"
                  size="40" required="true"/>
      <s:checkbox key="user.admin" label="%{getText('echobase.common.admin')}"/>
    </fieldset>
    <ul class="toolbar floatRight">
      <li><s:submit action="userForm" method="doCreateOrUpdate"
                    key="echobase.action.create" theme="simple"/></li>
      <li><s:submit action="userList" key="echobase.action.backToUserList"
                    theme="simple"/></li>
    </ul>
  </s:form>
</s:if>
<s:elseif test="userEditAction == #edit">

  <%--Update user--%>

  <s:form method="post" validate="true" namespace="/user">
    <fieldset>
      <legend>
        <s:text name="echobase.common.user"/>
      </legend>
      <s:hidden key="user.id" label=""/>
      <s:hidden key="userEditAction" label=""/>
      <s:textfield key="user.email" label="%{getText('echobase.common.email')}"
                   size="40"/>
      <s:password name="user.password" value="" key="echobase.common.password"
                  size="40"/>
      <s:checkbox value="%{user.admin}" key="echobase.common.admin"/>
    </fieldset>
    <ul class="toolbar floatRight">
      <li><s:submit action="userForm" method="doCreateOrUpdate"
                    key="echobase.action.save" theme="simple"/></li>
      <li><s:submit action="userList" key="echobase.action.backToUserList"
                    theme="simple"/></li>
    </ul>
  </s:form>
</s:elseif>
<s:elseif test="userEditAction == #delete">

  <%--Delete user--%>

  <s:form method="post" validate="true" namespace="/user">
    <fieldset>
      <legend>
        <s:text name="echobase.common.user"/>
      </legend>
      <s:hidden name="user.id" label=""/>
      <s:hidden name="userEditAction" label=""/>
      <s:textfield key="user.email" label="%{getText('echobase.common.email')}"
                   size="40" disabled="true"/>
      <s:checkbox value="%{user.admin}" key="echobase.common.admin"
                  disabled="true"/>
    </fieldset>
    <ul class="toolbar floatRight">
      <li><s:submit action="userForm" method="doDelete"
                    key="echobase.action.delete" theme="simple"/></li>
      <li><s:submit action="userList" key="echobase.action.backToUserList"
                    theme="simple"/></li>
    </ul>
  </s:form>
</s:elseif>

