/*
 * #%L
 * $Id: CommonFacade.java 519 2011-01-17 17:03:28Z chatellier $
 * $HeadURL: svn+ssh://chatellier@labs.libre-entreprise.org/svnroot/coser/trunk/coser-web/src/main/java/fr/ifremer/coser/web/actions/common/CommonFacade.java $
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions.common;

import com.opensymphony.xwork2.ActionSupport;

import fr.ifremer.coser.web.CoserWebConfig;
import fr.ifremer.coser.web.ServiceFactory;

/**
 * Toutes les actions doivent étendre celle ci. Contient le code commun
 * récurent, et notamment les actions utilisé par le layout et devant
 * être presentes sur toutes les pages.
 * 
 * @author chatellier
 * @version $Revision: 519 $
 * 
 * Last update : $Date: 2011-01-17 18:03:28 +0100 (lun. 17 janv. 2011) $
 * By : $Author: chatellier $
 */
public abstract class CoserAction extends ActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 311574866032741326L;

    /**
     * Recupere l'email dans la configuration.
     * 
     * @return admin email
     */
    public String getAdminEmail() {
        CoserWebConfig config = ServiceFactory.getCoserConfig();
        String email = config.getAdminEmail();
        return email;
    }
    
    /**
     * Recupere l'email dans la configuration.
     * 
     * @return admin email
     */
    public String getApplicationVersion() {
        CoserWebConfig config = ServiceFactory.getCoserConfig();
        String email = config.getApplicationVersion();
        return email;
    }

    /**
     * Get analytics id from configuration.
     * 
     * @return analytics id
     */
    public String getAnalyticsId() {
        CoserWebConfig config = ServiceFactory.getCoserConfig();
        String id = config.getAnalyticsId();
        return id;
    }
}
